/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.menu;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.Menu;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.bukkit.utils.menu.MonitoredState;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.LoaderUtils;
import io.lumine.mythic.bukkit.utils.text.Text;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuHelper
implements Listener {
    private static MenuHelper _instance = new MenuHelper();
    private final Map<UUID, OpenMenu<?>> openMenus = Maps.newConcurrentMap();
    private final Collection<UUID> swappingMenus = Sets.newHashSet();

    protected static <T> OpenMenu<T> registerOpen(Player player, Menu<T> menu, Inventory inventory, T state, List<MenuData<T>> data, List<MenuData<T>> secondaryData) {
        OpenMenu<T> om = new OpenMenu<T>(menu, player, inventory, state, data, secondaryData);
        MenuHelper._instance.openMenus.put(player.getUniqueId(), om);
        return om;
    }

    protected static <T> OpenMenu<T> swapMenu(Player player, Menu<T> menu, Inventory inventory, T state, List<MenuData<T>> data, List<MenuData<T>> secondaryData) {
        OpenMenu<?> lastMenu = MenuHelper._instance.openMenus.remove(player.getUniqueId());
        lastMenu.getMenu().getCloseFunc().accept(lastMenu, null);
        Inventory inv = lastMenu.getInventory();
        inv.clear();
        MenuHelper._instance.swappingMenus.add(player.getUniqueId());
        OpenMenu<T> om = new OpenMenu<T>(menu, player, inventory, state, data, secondaryData);
        MenuHelper._instance.openMenus.put(player.getUniqueId(), om);
        return om;
    }

    protected static <T> OpenMenu<T> unregisterOpen(Player player) {
        OpenMenu<?> lastMenu = MenuHelper._instance.openMenus.remove(player.getUniqueId());
        if (lastMenu != null) {
            lastMenu.getMenu().getCloseFunc().accept(lastMenu, null);
        }
        return lastMenu;
    }

    public static <T> OpenMenu<?> getOpenMenu(Player player) {
        return MenuHelper._instance.openMenus.getOrDefault(player.getUniqueId(), null);
    }

    public static <T> void reopenMenu(Player player, OpenMenu<T> menu) {
        MenuHelper._instance.openMenus.put(player.getUniqueId(), menu);
        player.openInventory(menu.getInventory());
        _instance.updateMenu(player.getUniqueId(), menu, true);
    }

    protected static <T> void moveToNextPage(Player player) {
        OpenMenu openMenu = MenuHelper._instance.openMenus.getOrDefault(player.getUniqueId(), null);
        if (openMenu != null) {
            openMenu.nextPage();
            _instance.updateMenu(player.getUniqueId(), openMenu, true);
        } else {
            Log.info("moveToNextPage on unopened menu by {0}?", player.getName());
        }
    }

    protected static <T> void moveToPreviousPage(Player player) {
        OpenMenu openMenu = MenuHelper._instance.openMenus.getOrDefault(player.getUniqueId(), null);
        if (openMenu != null) {
            openMenu.previousPage();
            _instance.updateMenu(player.getUniqueId(), openMenu, true);
        } else {
            Log.info("moveToPreviousPage on unopened menu by {0}?", player.getName());
        }
    }

    protected static <T> void moveToNextSecondaryPage(Player player) {
        OpenMenu openMenu = MenuHelper._instance.openMenus.getOrDefault(player.getUniqueId(), null);
        if (openMenu != null) {
            openMenu.nextSecondaryPage();
            _instance.updateMenu(player.getUniqueId(), openMenu, true);
        } else {
            Log.info("moveToNextSecondaryPage on unopened menu by {0}?", player.getName());
        }
    }

    protected static <T> void moveToPreviousSecondaryPage(Player player) {
        OpenMenu openMenu = MenuHelper._instance.openMenus.getOrDefault(player.getUniqueId(), null);
        if (openMenu != null) {
            openMenu.previousSecondaryPage();
            _instance.updateMenu(player.getUniqueId(), openMenu, true);
        } else {
            Log.info("moveToPreviousSecondaryPage on unopened menu by {0}?", player.getName());
        }
    }

    private MenuHelper() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)LoaderUtils.getPlugin());
        Bukkit.getScheduler().runTaskTimer((Plugin)LoaderUtils.getPlugin(), this::updateMenus, 1L, 1L);
    }

    @EventHandler
    private void onOpen(InventoryOpenEvent event) {
        if (this.openMenus.containsKey(event.getPlayer().getUniqueId())) {
            OpenMenu<?> menu = this.openMenus.get(event.getPlayer().getUniqueId());
            menu.getMenu().getOpenFunc().accept(menu, event);
            Schedulers.sync().runLater(() -> {
                if (this.openMenus.containsKey(event.getPlayer().getUniqueId())) {
                    this.updateMenu(event.getPlayer().getUniqueId(), this.openMenus.get(event.getPlayer().getUniqueId()), true);
                }
            }, 1L);
        }
    }

    @EventHandler
    private void onClose(InventoryCloseEvent event) {
        if (this.openMenus.containsKey(event.getPlayer().getUniqueId())) {
            if (this.swappingMenus.contains(event.getPlayer().getUniqueId())) {
                this.swappingMenus.remove(event.getPlayer().getUniqueId());
            } else {
                OpenMenu<?> menu = this.openMenus.remove(event.getPlayer().getUniqueId());
                menu.getMenu().getCloseFunc().accept(menu, event);
            }
        }
    }

    public void registerMenuClosed(Player player) {
        if (this.openMenus.containsKey(player.getUniqueId())) {
            OpenMenu<?> menu = this.openMenus.remove(player.getUniqueId());
            menu.getMenu().getCloseFunc().accept(menu, null);
        }
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        OpenMenu<?> openMenu = this.openMenus.get(event.getWhoClicked().getUniqueId());
        if (openMenu == null) {
            return;
        }
        if (event.getAction().equals((Object)InventoryAction.COLLECT_TO_CURSOR)) {
            event.setCancelled(true);
        }
        if (openMenu.handleClick(event)) {
            event.setCancelled(true);
        }
        if (openMenu.menu.isStaticMenu()) {
            this.updateMenu(event.getWhoClicked().getUniqueId(), this.openMenus.get(event.getWhoClicked().getUniqueId()), true);
        }
    }

    @EventHandler
    private void onDrag(InventoryDragEvent event) {
        OpenMenu<?> openMenu = this.openMenus.get(event.getWhoClicked().getUniqueId());
        if (openMenu == null) {
            return;
        }
        for (Integer slot : event.getRawSlots()) {
            if (slot >= openMenu.inventory.getSize() || !openMenu.handleClick(event)) continue;
            event.setCancelled(true);
        }
        if (openMenu.menu.isStaticMenu()) {
            this.updateMenu(event.getWhoClicked().getUniqueId(), this.openMenus.get(event.getWhoClicked().getUniqueId()), true);
        }
    }

    private void updateMenus() {
        this.openMenus.forEach((uuid, menu) -> this.updateMenu((UUID)uuid, (OpenMenu)menu));
    }

    private <T> void updateMenu(UUID uuid, OpenMenu<T> openMenu, boolean force) {
        Inventory inv;
        Player player;
        try {
            player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                Schedulers.sync().runLater(() -> this.openMenus.remove(uuid), 1L);
                return;
            }
            inv = Bukkit.getPlayer((UUID)uuid).getOpenInventory().getTopInventory();
        }
        catch (Exception ex) {
            Player player2 = Bukkit.getPlayer((UUID)uuid);
            if (player2 == null) {
                player2.closeInventory();
                Schedulers.sync().runLater(() -> this.openMenus.remove(uuid), 1L);
            }
            return;
        }
        Menu menu = openMenu.menu;
        Player finalPlayer = player;
        if (menu.getUpdateInterval() > 1L && System.currentTimeMillis() - openMenu.lastUpdate < menu.getUpdateInterval() * 50L) {
            return;
        }
        if (!menu.isStaticMenu() || force) {
            ItemStack comp;
            ItemStack stack;
            int count;
            Optional<MonitoredState> maybeMonitor = menu.getMonitoredState(openMenu.state);
            if (maybeMonitor.isPresent()) {
                if (!maybeMonitor.filter(monitor -> monitor.getMonitorTimestamp() != openMenu.monitorTimestamp).isPresent()) {
                    if (menu.getBlinkingSlots().isPresent()) {
                        menu.getBlinkingSlots().get().stream().forEach(slot -> {
                            Icon icon = menu.getIcon((int)slot).get();
                            ItemStack stack = icon.build(openMenu.state, finalPlayer);
                            ItemStack comp = inv.getItem(slot.intValue());
                            if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
                                inv.setItem(slot.intValue(), stack);
                            }
                        });
                    }
                    return;
                }
                openMenu.monitorTimestamp = maybeMonitor.get().getMonitorTimestamp();
            }
            menu.sort(openMenu.state, player);
            openMenu.getIcons().forEach((slot, icon) -> {
                ItemStack stack = icon.build(openMenu.state, finalPlayer);
                ItemStack comp = inv.getItem(slot.intValue());
                if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
                    inv.setItem(slot.intValue(), stack);
                }
            });
            if (!menu.getDataSlots().isEmpty() && openMenu.getData().size() > 0) {
                count = 0;
                for (int slot2 : menu.getDataSlots()) {
                    try {
                        stack = count >= openMenu.getDisplayedData().size() ? (menu.getFallbackDataIcon() != null ? menu.getFallbackDataIcon().build(openMenu.state, finalPlayer) : new ItemStack(Material.AIR)) : openMenu.getDisplayedData().get(count).getIcon().build(openMenu.state, finalPlayer);
                        comp = inv.getItem(slot2);
                        if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
                            inv.setItem(slot2, stack);
                        }
                    }
                    catch (Error | Exception stack2) {
                        // empty catch block
                    }
                    ++count;
                }
            }
            if (!menu.getSecondaryDataSlots().isEmpty() && openMenu.getSecondaryData().size() > 0) {
                count = 0;
                for (int slot2 : menu.getSecondaryDataSlots()) {
                    try {
                        stack = count >= openMenu.getSecondaryDisplayedData().size() ? (menu.getFallbackSecondaryDataIcon() != null ? menu.getFallbackSecondaryDataIcon().build(openMenu.state, finalPlayer) : new ItemStack(Material.AIR)) : openMenu.getSecondaryDisplayedData().get(count).getIcon().build(openMenu.state, finalPlayer);
                        comp = inv.getItem(slot2);
                        if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
                            inv.setItem(slot2, stack);
                        }
                    }
                    catch (Error | Exception throwable) {
                        // empty catch block
                    }
                    ++count;
                }
            }
            openMenu.setLastUpdate(System.currentTimeMillis());
        }
    }

    private <T> void updateMenu(UUID uuid, OpenMenu<T> openMenu) {
        this.updateMenu(uuid, openMenu, false);
    }

    public static MenuHelper get_instance() {
        return _instance;
    }

    public Map<UUID, OpenMenu<?>> getOpenMenus() {
        return this.openMenus;
    }

    public Collection<UUID> getSwappingMenus() {
        return this.swappingMenus;
    }

    public static class OpenMenu<T> {
        private final Menu<T> menu;
        private final Player player;
        private final Inventory inventory;
        private final T state;
        private final List<MenuData<T>> data;
        private final List<MenuData<T>> secondaryData;
        private long lastUpdate = System.currentTimeMillis();
        private long monitorTimestamp;
        private int page = 0;
        private int pages = 1;
        private int dataPerPage = 0;
        private final Map<Integer, Icon<? super T>> icons = Maps.newHashMap();
        private List<MenuData<T>> displayedData;
        private Map<Integer, Icon<T>> displayedIcons = Maps.newHashMap();
        private int secondaryPage = 0;
        private int secondaryPages = 1;
        private int secondaryDataPerPage = 0;
        private List<MenuData<T>> secondaryDisplayedData;
        private Map<Integer, Icon<T>> secondaryDisplayedIcons = Maps.newHashMap();

        public OpenMenu(Menu<T> menu, Player player, Inventory inventory, T state, List<MenuData<T>> data, List<MenuData<T>> secondaryData) {
            int count;
            int end;
            int start;
            this.menu = menu;
            this.player = player;
            this.inventory = inventory;
            this.state = state;
            this.icons.putAll(menu.getIcons());
            this.data = data;
            this.secondaryData = secondaryData;
            this.dataPerPage = menu.getDataSlots().size();
            if (this.dataPerPage > 0) {
                end = (start = this.page * this.dataPerPage) + this.dataPerPage;
                this.displayedData = data.subList(start, end < data.size() ? end : data.size());
                this.pages = Numbers.floor(data.size() / this.dataPerPage);
                count = 0;
                for (int slot : menu.getDataSlots()) {
                    if (count < this.getDisplayedData().size()) {
                        this.displayedIcons.put(slot, this.getDisplayedData().get(count).getIcon());
                    }
                    ++count;
                }
            }
            this.secondaryDataPerPage = menu.getSecondaryDataSlots().size();
            if (this.secondaryDataPerPage > 0) {
                end = (start = this.secondaryPage * this.secondaryDataPerPage) + this.secondaryDataPerPage;
                this.secondaryDisplayedData = secondaryData.subList(start, end < secondaryData.size() ? end : secondaryData.size());
                this.secondaryPages = Numbers.floor(secondaryData.size() / this.secondaryDataPerPage);
                count = 0;
                for (int slot : menu.getSecondaryDataSlots()) {
                    if (count < this.getSecondaryDisplayedData().size()) {
                        this.secondaryDisplayedIcons.put(slot, this.getSecondaryDisplayedData().get(count).getIcon());
                    }
                    ++count;
                }
            }
        }

        public boolean handleClick(InventoryDragEvent event) {
            try {
                if (event.getInventory() == null) {
                    return false;
                }
                if (event.getRawSlots().size() > 1) {
                    return true;
                }
                if (event.getType().equals((Object)DragType.SINGLE)) {
                    event.getInventorySlots().forEach(slot -> this.handleRightClick((int)slot));
                } else if (event.getType().equals((Object)DragType.EVEN)) {
                    event.getInventorySlots().forEach(slot -> this.handleClick((int)slot));
                }
                return true;
            }
            catch (Error | Exception ex) {
                Text.sendMessage((CommandSender)((Player)event.getWhoClicked()), "<red>Sorry, an error occurred!");
                ex.printStackTrace();
                return true;
            }
        }

        public boolean handleClick(InventoryClickEvent event) {
            try {
                if (event.getClickedInventory() == null) {
                    return false;
                }
                if (event.getClick() == ClickType.RIGHT) {
                    this.handleRightClick(event.getRawSlot());
                } else if (event.getClick() == ClickType.LEFT) {
                    this.handleClick(event.getRawSlot());
                } else if (event.getClick() == ClickType.SHIFT_LEFT) {
                    this.handleShiftClick(event.getRawSlot());
                } else if (event.getClick() == ClickType.SHIFT_RIGHT) {
                    this.handleShiftRightClick(event.getRawSlot());
                } else if (event.getClick() == ClickType.DOUBLE_CLICK) {
                    this.handleDoubleClick(event.getRawSlot());
                } else if (event.getClick() == ClickType.MIDDLE) {
                    this.handleMiddleClick(event.getRawSlot());
                } else if (event.getClick() == ClickType.DROP) {
                    this.handleDropClick(event.getRawSlot());
                } else if (event.getClick() == ClickType.CONTROL_DROP) {
                    this.handleDropAllClick(event.getRawSlot());
                } else if (event.getClick() == ClickType.SWAP_OFFHAND) {
                    this.handleSwapOffhandClick(event.getRawSlot());
                }
                if (this.menu.getDefaultClickFunc() != null) {
                    return this.menu.getDefaultClickFunc().apply(this, event);
                }
                if (event.getClickedInventory().getType() == InventoryType.PLAYER) {
                    return event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY;
                }
                return true;
            }
            catch (Error | Exception ex) {
                Text.sendMessage((CommandSender)((Player)event.getWhoClicked()), "<red>Sorry, an error occurred!");
                ex.printStackTrace();
                return true;
            }
        }

        private void handleClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleRightClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getRightClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleShiftClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getShiftClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleShiftRightClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getShiftRightClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleDoubleClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getDoubleClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleMiddleClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getMiddleClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleDropClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getDropClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleDropAllClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getDropAllClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleSwapOffhandClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getSwapOffhandClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        public Optional<Icon<? super T>> getIcon(int slot) {
            if (!this.menu.getDataSlots().isEmpty() && this.menu.getDataSlots().contains(slot)) {
                return Optional.ofNullable(this.displayedIcons.getOrDefault(slot, null));
            }
            if (!this.menu.getSecondaryDataSlots().isEmpty() && this.menu.getSecondaryDataSlots().contains(slot)) {
                return Optional.ofNullable(this.secondaryDisplayedIcons.getOrDefault(slot, null));
            }
            return this.menu.getIcon(slot);
        }

        public void setIcon(int slot, Icon<? super T> icon) {
            this.icons.put(slot, icon);
        }

        public void setPage(int page) {
            int start;
            this.page = page;
            int end = (start = page * this.dataPerPage) + this.dataPerPage;
            this.displayedData = this.data.subList(start, end < this.data.size() ? end : this.data.size());
            int count = 0;
            this.displayedIcons.clear();
            for (int slot : this.menu.getDataSlots()) {
                if (count < this.getDisplayedData().size()) {
                    this.displayedIcons.put(slot, this.getDisplayedData().get(count).getIcon());
                }
                ++count;
            }
        }

        public void nextPage() {
            this.setPage(this.page + 1 > this.pages ? this.pages : this.page + 1);
        }

        public void previousPage() {
            this.setPage(this.page - 1 <= 0 ? 0 : this.page - 1);
        }

        public void setSecondaryPage(int page) {
            int start;
            this.secondaryPage = page;
            int end = (start = page * this.secondaryDataPerPage) + this.secondaryDataPerPage;
            this.secondaryDisplayedData = this.secondaryData.subList(start, end < this.secondaryData.size() ? end : this.secondaryData.size());
            int count = 0;
            this.secondaryDisplayedIcons.clear();
            for (int slot : this.menu.getSecondaryDataSlots()) {
                if (count < this.getSecondaryDisplayedData().size()) {
                    this.secondaryDisplayedIcons.put(slot, this.getSecondaryDisplayedData().get(count).getIcon());
                }
                ++count;
            }
        }

        public void nextSecondaryPage() {
            this.setSecondaryPage(this.secondaryPage + 1 > this.secondaryPages ? this.secondaryPages : this.secondaryPage + 1);
        }

        public void previousSecondaryPage() {
            this.setSecondaryPage(this.secondaryPage - 1 <= 0 ? 0 : this.secondaryPage - 1);
        }

        public Menu<T> getMenu() {
            return this.menu;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Inventory getInventory() {
            return this.inventory;
        }

        public List<MenuData<T>> getData() {
            return this.data;
        }

        public List<MenuData<T>> getSecondaryData() {
            return this.secondaryData;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }

        public int getPage() {
            return this.page;
        }

        public int getPages() {
            return this.pages;
        }

        public int getDataPerPage() {
            return this.dataPerPage;
        }

        public Map<Integer, Icon<? super T>> getIcons() {
            return this.icons;
        }

        public List<MenuData<T>> getDisplayedData() {
            return this.displayedData;
        }

        public Map<Integer, Icon<T>> getDisplayedIcons() {
            return this.displayedIcons;
        }

        public int getSecondaryPage() {
            return this.secondaryPage;
        }

        public int getSecondaryPages() {
            return this.secondaryPages;
        }

        public int getSecondaryDataPerPage() {
            return this.secondaryDataPerPage;
        }

        public List<MenuData<T>> getSecondaryDisplayedData() {
            return this.secondaryDisplayedData;
        }

        public Map<Integer, Icon<T>> getSecondaryDisplayedIcons() {
            return this.secondaryDisplayedIcons;
        }
    }
}

