/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.regex.Pattern;

public class RandomDouble {
    private static Pattern PATTERN = Pattern.compile("^(-?(?:\\d*\\.)?\\d+)((?:to|-)(-?(?:\\d*\\.)?\\d+))?$");
    private static Pattern PATTERN_RANGE = Pattern.compile("^-?\\d*(?:\\.\\d+)?(to|-)\\d+(?:\\.\\d+)?$");
    private static Object2BooleanMap<String> matchesCache = Object2BooleanMaps.synchronize((Object2BooleanMap)new Object2BooleanOpenHashMap());
    private static Object2BooleanMap<String> matchesRangeCache = Object2BooleanMaps.synchronize((Object2BooleanMap)new Object2BooleanOpenHashMap());
    private boolean isStatic;
    private double min;
    private double max;

    public RandomDouble(double i) {
        this.min = i;
        this.max = i;
        this.isStatic = true;
    }

    public RandomDouble(double i, double j) {
        this.min = i;
        this.max = j;
        this.isStatic = false;
    }

    public RandomDouble(String value) {
        try {
            if (value.contains("to")) {
                String[] split = value.split("to");
                this.min = Double.valueOf(split[0]);
                this.max = Double.valueOf(split[1]);
                this.isStatic = false;
            } else if (!value.startsWith("-") && value.contains("-")) {
                String[] split = value.split("-");
                this.min = Double.valueOf(split[0]);
                this.max = Double.valueOf(split[1]);
                this.isStatic = false;
            } else {
                this.min = Double.valueOf(value);
                this.max = Double.valueOf(value);
                this.isStatic = true;
            }
        }
        catch (Exception ex) {
            this.min = 1.0;
            this.max = 1.0;
            this.isStatic = true;
            ex.printStackTrace();
        }
    }

    public double get() {
        return this.isStatic ? this.min : this.min + Math.random() * (this.max - this.min);
    }

    public String toString() {
        return "RandomDouble{" + this.min + " to " + this.max + "}";
    }

    public static boolean matches(String value) {
        if (matchesCache.containsKey((Object)value)) {
            return matchesCache.getBoolean((Object)value);
        }
        boolean matches = PATTERN.matcher(value).matches();
        matchesCache.put((Object)value, matches);
        return matches;
    }

    public static boolean matchesRange(String value) {
        if (matchesRangeCache.containsKey((Object)value)) {
            return matchesRangeCache.getBoolean((Object)value);
        }
        boolean matches = PATTERN_RANGE.matcher(value).matches();
        matchesRangeCache.put((Object)value, matches);
        return matches;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

