/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files;

import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.Mappings;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.RealMappings;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files.MappingType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ProguardMapping
implements MappingType {
    private static final Map<String, Class<?>> PRIMITIVES = Map.of("boolean", Boolean.TYPE, "byte", Byte.TYPE, "short", Short.TYPE, "int", Integer.TYPE, "long", Long.TYPE, "float", Float.TYPE, "double", Double.TYPE, "char", Character.TYPE);
    private static final Logger LOGGER = Logger.getLogger("ProguardMapping");
    private static final Pattern CLASS_REGEX = Pattern.compile("(?<original>[\\w.$]+) -> (?<obfuscated>[\\w.$]+):");
    private static final Pattern METHOD_REGEX = Pattern.compile("    (?:(?:\\d+:\\d+:)?[\\w.$\\[\\]]+ )?(?<original>[\\w<>$]+)\\((?<parameters>[\\w.$, \\[\\]]*)\\) -> (?<obfuscated>[\\w<>]+)");
    private static final Pattern FIELD_REGEX = Pattern.compile("    (?:[\\w.$\\[\\]]+ )?(?<original>[\\w$]+) -> (?<obfuscated>\\w+)");
    private static final Pattern METHOD_PARAMETERS_REGEX = Pattern.compile("([\\w.$]+)(\\[\\])?,?");
    private final boolean failOnLineParse;

    public ProguardMapping(boolean failOnLineParse) {
        this.failOnLineParse = failOnLineParse;
    }

    @Override
    public Mappings parse(@NotNull List<String> lines) {
        ArrayList<ObfuscatedClass> parsedClasses = new ArrayList<ObfuscatedClass>();
        String classOriginal = null;
        String classObfuscated = null;
        ArrayList<ObfuscatedMethod> classMethods = null;
        ArrayList<ObfuscatedField> classFields = null;
        for (String line : lines) {
            if (line.startsWith("#") || line.contains("package-info")) continue;
            Matcher classMatch = CLASS_REGEX.matcher(line);
            if (classMatch.matches()) {
                if (classOriginal != null) {
                    parsedClasses.add(new ObfuscatedClass(classOriginal, classObfuscated, classMethods, classFields));
                }
                classOriginal = classMatch.group("original");
                classObfuscated = classMatch.group("obfuscated");
                classMethods = new ArrayList<ObfuscatedMethod>();
                classFields = new ArrayList<ObfuscatedField>();
                continue;
            }
            Matcher methodMatch = METHOD_REGEX.matcher(line);
            if (methodMatch.matches()) {
                classMethods.add(new ObfuscatedMethod(methodMatch.group("original"), methodMatch.group("obfuscated"), methodMatch.group("parameters")));
                continue;
            }
            Matcher fieldMatch = FIELD_REGEX.matcher(line);
            if (fieldMatch.matches()) {
                classFields.add(new ObfuscatedField(fieldMatch.group("original"), fieldMatch.group("obfuscated")));
                continue;
            }
            if (this.failOnLineParse) {
                throw new IllegalArgumentException("Failed to parse line " + line);
            }
            LOGGER.log(Level.WARNING, "Failed to parse line {0}", line);
        }
        if (classOriginal != null) {
            parsedClasses.add(new ObfuscatedClass(classOriginal, classObfuscated, classMethods, classFields));
        }
        LOGGER.log(Level.FINE, "Found {0} classes to remap", parsedClasses.size());
        HashMap fakeTypes = new HashMap();
        Map classes = parsedClasses.stream().map(clazz -> new RealMappings.RealClassMapping(clazz.original, clazz.obfuscated, new ArrayList<RealMappings.RealClassMapping.RealFieldMapping>(), new ArrayList<RealMappings.RealClassMapping.RealMethodMapping>())).collect(Collectors.toMap(RealMappings.RealClassMapping::getOriginalName, Function.identity()));
        for (ObfuscatedClass parsedClass : parsedClasses) {
            RealMappings.RealClassMapping classMapping = (RealMappings.RealClassMapping)classes.get(parsedClass.original);
            classMapping.fields().addAll(parsedClass.fields.stream().map(field -> new RealMappings.RealClassMapping.RealFieldMapping(field.original, field.obfuscated)).toList());
            classMapping.methods().addAll(parsedClass.methods.stream().map(method -> new RealMappings.RealClassMapping.RealMethodMapping(method.original, method.obfuscated, this.parseParameters(method.parameters, fakeTypes, classes))).toList());
        }
        return new RealMappings(classes.values());
    }

    @NotNull
    protected @NotNull Type @NotNull [] parseParameters(@NotNull String parameters, Map<@NotNull String, Type> fakeTypes, Map<@NotNull String, RealMappings.RealClassMapping> classes) {
        ArrayList types = new ArrayList(2);
        Matcher matcher = METHOD_PARAMETERS_REGEX.matcher(parameters);
        while (matcher.find()) {
            String typeName = matcher.group(1);
            boolean isArray = matcher.group(2) != null;
            Class<?> clazz = null;
            TypeDescriptor.OfField<Class<?>> type = (TypeDescriptor.OfField<Class<?>>)((Object)classes.get(typeName));
            if (type == null && (clazz = PRIMITIVES.get(typeName)) == null) {
                try {
                    clazz = Class.forName(typeName);
                }
                catch (ClassNotFoundException __) {
                    if (!fakeTypes.containsKey(typeName)) {
                        LOGGER.log(Level.FINER, "Cannot find class {0}", typeName);
                        fakeTypes.put(typeName, new FakeType(typeName));
                    }
                    type = fakeTypes.get(typeName);
                }
            }
            if (clazz != null) {
                type = isArray ? clazz.arrayType() : clazz;
            } else if (isArray) {
                type = new Mappings.ClassMapping.ClassArrayType((Type)((Object)type));
            }
            types.add((Class<?>)type);
        }
        return (Type[])types.toArray(Type[]::new);
    }

    @Override
    public void write(@NotNull BufferedWriter writer, @NotNull Mappings mappings) throws IOException {
        for (Mappings.ClassMapping classMapping : mappings.getClasses()) {
            writer.append("%s -> %s:".formatted(classMapping.getOriginalName(), classMapping.getMappedName()));
            writer.newLine();
            for (Mappings.ClassMapping.FieldMapping fieldMapping : classMapping.getFields()) {
                writer.append("    %s -> %s".formatted(fieldMapping.getOriginalName(), fieldMapping.getMappedName()));
                writer.newLine();
            }
            for (Mappings.ClassMapping.MethodMapping methodMapping : classMapping.getMethods()) {
                String parameters = Stream.of(methodMapping.getParameterTypes()).map(parameter -> parameter.getTypeName()).collect(Collectors.joining(","));
                writer.append("    %s(%s) -> %s".formatted(methodMapping.getOriginalName(), parameters, methodMapping.getMappedName()));
                writer.newLine();
            }
        }
    }

    private record ObfuscatedClass(String original, String obfuscated, List<ObfuscatedMethod> methods, List<ObfuscatedField> fields) {
    }

    private record ObfuscatedMethod(String original, String obfuscated, String parameters) {
    }

    private record ObfuscatedField(String original, String obfuscated) {
    }

    protected record FakeType(String name) implements Type
    {
        @Override
        public String getTypeName() {
            return this.name;
        }
    }
}

