/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.redis.jedis;

import io.lumine.mythic.bukkit.utils.lib.pool2.impl.GenericObjectPoolConfig;
import io.lumine.mythic.bukkit.utils.redis.jedis.DefaultJedisClientConfig;
import io.lumine.mythic.bukkit.utils.redis.jedis.HostAndPort;
import io.lumine.mythic.bukkit.utils.redis.jedis.Jedis;
import io.lumine.mythic.bukkit.utils.redis.jedis.JedisClientConfig;
import io.lumine.mythic.bukkit.utils.redis.jedis.JedisClusterHostAndPortMap;
import io.lumine.mythic.bukkit.utils.redis.jedis.JedisClusterInfoCache;
import io.lumine.mythic.bukkit.utils.redis.jedis.JedisPool;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisConnectionException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;

public abstract class JedisClusterConnectionHandler
implements Closeable {
    protected final JedisClusterInfoCache cache;

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, password, null);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, null, password, clientName);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, 0, user, password, clientName);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, clientName, false, null, null, null, null);
    }

    @Deprecated
    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, null, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, portMap);
    }

    @Deprecated
    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, 0, user, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, portMap);
    }

    @Deprecated
    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        this(nodes, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).user(user).password(password).clientName(clientName).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build(), poolConfig, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).user(user).password(password).clientName(clientName).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).hostAndPortMapper(portMap).build());
    }

    @Deprecated
    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, JedisClientConfig seedNodesClientConfig, GenericObjectPoolConfig<Jedis> poolConfig, JedisClientConfig clusterNodesClientConfig) {
        this.cache = new JedisClusterInfoCache(poolConfig, clusterNodesClientConfig);
        this.initializeSlotsCache(nodes, seedNodesClientConfig);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, JedisClientConfig clientConfig) {
        this.cache = new JedisClusterInfoCache(poolConfig, clientConfig);
        this.initializeSlotsCache(nodes, clientConfig);
    }

    protected abstract Jedis getConnection();

    protected abstract Jedis getConnectionFromSlot(int var1);

    public Jedis getConnectionFromNode(HostAndPort node) {
        return this.cache.setupNodeIfNotExist(node).getResource();
    }

    public Map<String, JedisPool> getNodes() {
        return this.cache.getNodes();
    }

    private void initializeSlotsCache(Set<HostAndPort> startNodes, JedisClientConfig clientConfig) {
        ArrayList<HostAndPort> startNodeList = new ArrayList<HostAndPort>(startNodes);
        Collections.shuffle(startNodeList);
        for (HostAndPort hostAndPort : startNodeList) {
            try (Jedis jedis = new Jedis(hostAndPort, clientConfig);){
                this.cache.discoverClusterNodesAndSlots(jedis);
                return;
            }
            catch (JedisConnectionException jedisConnectionException) {
            }
        }
    }

    public void renewSlotCache() {
        this.cache.renewClusterSlots(null);
    }

    public void renewSlotCache(Jedis jedis) {
        this.cache.renewClusterSlots(jedis);
    }

    @Override
    public void close() {
        this.cache.reset();
    }
}

