/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.config;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.core.config.DropMethod;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillString;
import java.io.File;
import java.util.HashSet;
import org.bukkit.Material;

public class LegacyConfigExecutor
implements PropertyHolder {
    private static final DoubleProp VERSION = Property.Double(Scope.CONFIG, "Version");
    private static final BooleanProp GENERAL_ALLOW_METRICS = Property.Boolean(Scope.CONFIG, "General.AllowMetrics", true);
    private static final BooleanProp GENERAL_CHECK_UPDATES = Property.Boolean(Scope.CONFIG, "General.CheckForUpdates", true);
    private static final BooleanProp GENERAL_COMPATIB_MODE = Property.Boolean(Scope.CONFIG, "General.CompatibilityMode", false);
    private static final BooleanProp GENERAL_ERROR_LOGGING = Property.Boolean(Scope.CONFIG, "General.ErrorLogging", true);
    private static final BooleanProp CANCEL_DAMAGE_IF_0 = Property.Boolean(Scope.CONFIG, "General.CancelDamageIfZero", false);
    private static final BooleanProp GENERAL_LOAD_EXAMPLES = Property.Boolean(Scope.CONFIG, "General.LoadExampleConfigs", true);
    private static final StringProp GENERAL_LANGUAGE = Property.String(Scope.CONFIG, "General.Language", "enUS");
    private static final IntProp DEBUG_LEVEL = Property.Int(Scope.CONFIG, "General.DebugLevel", 0);
    private static final BooleanProp DEBUG_MODE = Property.Boolean(Scope.CONFIG, "General.DebugMode", false);
    private static final BooleanProp DEBUG_SPAWNERS = Property.Boolean(Scope.CONFIG, "General.DebugSpawners", false);
    private static final IntProp CLOCK_SPEED = Property.Int(Scope.CONFIG, "Clock.Main", 1);
    private static final IntProp CLOCK_RANDOM_SPAWNING = Property.Int(Scope.CONFIG, "Clock.RandomSpawning", 1);
    private static final IntProp CLOCK_SAVING = Property.Int(Scope.CONFIG, "Clock.Saving", 300);
    private static final StringProp MOBS_KILL_MESSAGE_PREFIX = Property.String(Scope.CONFIG, "Mobs.KillMessagePrefix", null);
    private IOLoader<MythicBukkit> settings;
    private MythicConfig config;
    private Boolean allowMetrics = true;
    private Boolean allowUpdateChecking = true;
    private Boolean useCompatibilityMode = false;
    private Boolean loadExampleConfigs = true;
    private Boolean fireAPIDeathEvent = true;
    private Boolean fireAPISkillEvent = true;
    private Boolean fireAPICustomSkillEvent = true;
    private int debugLevel = -1;
    private boolean debugMode = false;
    private boolean debugSpawners = false;
    private Boolean doErrorLogging = true;
    private boolean cancelDamageIfZero = false;
    private DropMethod defaultDropMethod = DropMethod.VANILLA;
    private int clockIntervalMain = 1;
    private int clockIntervalRandomSpawning = 1;
    private int clockIntervalSaving = 300;
    public int SpawningInterval = 1;
    public int timerupdate;
    public int walkupdate;
    public int ShowHealthRadius = 25;
    public int ScanInterval = 10;
    public int ClnrInterval = 600;
    private int bossBarUpdateInterval = 20;
    public boolean EnableAIModifiers = true;
    public boolean EnableThreatTables = true;
    public String killMessagePrefix = "";
    public Boolean mobsDespawnByDefault = false;
    public Boolean preventOtherDropsByDefault = false;
    public String defaultLevelModifierHealth;
    public String defaultLevelModifierDamage;
    public String defaultLevelModifierPower;
    public String defaultLevelModifierArmor;
    public String defaultLevelModifierKBR;
    public String scalingEquationDamage = null;
    public String scalingEquationHealth = null;
    public boolean EnableTimerSkills = true;
    public Boolean skillsIgnoreArmorStandsByDefault = true;
    public boolean targetSelf = false;
    public boolean targetPlayers = true;
    public boolean targetArmorStands = false;
    public boolean targetMarkers = false;
    public boolean targetCreativeMode = true;
    public boolean targetSpectatorMode = true;
    public boolean targetCitizensNPCs = false;
    public boolean targetAnimals = true;
    public boolean targetCreatures = true;
    public boolean targetMonsters = true;
    public boolean targetWaterMobs = true;
    public boolean targetFlyingMobs = true;
    public boolean targetSameFaction = true;
    public boolean targetOwner = true;
    public boolean targetNonMythic = true;
    public boolean targetVillagers = true;
    public int SpawnerRange = 40;
    public boolean rsGeneratePoints = false;
    public int rsMaxMobsPerChunk = 20;
    public int randomSpawningPlayerRadiusMax = 64;
    public int randomSpawningPlayerRadiusMin = 16;
    public int randomSpawningPlayerRadiusY = 16;
    public int rsPointsPerSecondLand = 10;
    public int rsPointsPerSecondAir = 0;
    public int rsPointsPerSecondSea = 1;
    public int rsPointsPerSecondLava = 0;
    public int rsPointsPerSecondGround = 0;
    public int rsMaxGenerationTimeMillis = 20;
    public boolean rsDespawnVanillaOutsideRadius = false;
    public boolean vanillaSpawnsDisabled = false;
    public boolean updateItems = true;
    public boolean compatHeroesXPEnable = false;
    public boolean compatHeroesShowXPMessage = true;
    public String compatHeroesXPMessageFormat = "";
    public boolean compatSkillAPIShowXPMessage = true;
    public String compatSkillAPIXPMessageFormat = "";
    public boolean compatVaultShowMoneyMessage = true;
    public String compatVaultMoneyMessageFormat = "";
    public boolean compatMcMMOShowXPMessage = true;
    public String compatMcMMOXPMessageFormat = "";
    private final MythicBukkit plugin;
    private static HashSet<Material> transparentBlocks = new HashSet();

    public LegacyConfigExecutor(MythicBukkit core) {
        this.plugin = core;
    }

    public File getConfigFolder() {
        File configFolder = new File(this.getPlugin().getDataFolder(), "config");
        if (!configFolder.exists()) {
            configFolder.mkdir();
        }
        return configFolder;
    }

    public void loadSettings() {
        this.settings = new IOLoader<MythicBukkit>(this.plugin, "config.yml");
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Settings...", new Object[0]);
        File configFile = new File(this.getPlugin().getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.getPlugin().saveResource("config.yml", false);
        }
        MythicConfigImpl mc = new MythicConfigImpl("Configuration", this.settings.getCustomConfig());
        this.allowMetrics = (Boolean)GENERAL_ALLOW_METRICS.get(this);
        this.allowUpdateChecking = (Boolean)GENERAL_CHECK_UPDATES.get(this);
        this.useCompatibilityMode = (Boolean)GENERAL_COMPATIB_MODE.get(this);
        this.doErrorLogging = (Boolean)GENERAL_ERROR_LOGGING.get(this);
        this.cancelDamageIfZero = (Boolean)CANCEL_DAMAGE_IF_0.get(this);
        this.debugLevel = (Integer)DEBUG_LEVEL.get(this);
        this.clockIntervalMain = (Integer)CLOCK_SPEED.get(this);
        this.clockIntervalRandomSpawning = (Integer)CLOCK_RANDOM_SPAWNING.get(this);
        this.clockIntervalSaving = (Integer)CLOCK_SAVING.get(this);
        this.SpawningInterval = mc.getInteger("Clock.SpawnsInterval", 2);
        this.ScanInterval = mc.getInteger("Clock.ScannerInterval", 10);
        this.ClnrInterval = mc.getInteger("Clock.CleanupInterval", 600);
        this.targetSelf = mc.getBoolean("Targeters.Filters.Default.TargetSelf", false);
        this.targetPlayers = mc.getBoolean("Targeters.Filters.Default.TargetPlayers", true);
        this.targetArmorStands = mc.getBoolean("Targeters.Filters.Default.TargetArmorStands", false);
        this.targetMarkers = mc.getBoolean("Targeters.Filters.Default.TargetMarkers", false);
        this.targetCreativeMode = mc.getBoolean("Targeters.Filters.Default.TargetCreativeMode", true);
        this.targetSpectatorMode = mc.getBoolean("Targeters.Filters.Default.TargetSpectatorMode", true);
        this.targetCitizensNPCs = mc.getBoolean("Targeters.Filters.Default.TargetCitizensNPCs", false);
        this.targetAnimals = mc.getBoolean("Targeters.Filters.Default.TargetAnimals", true);
        this.targetCreatures = mc.getBoolean("Targeters.Filters.Default.TargetCreatures", true);
        this.targetMonsters = mc.getBoolean("Targeters.Filters.Default.TargetMonsters", true);
        this.targetWaterMobs = mc.getBoolean("Targeters.Filters.Default.TargetWaterMobs", true);
        this.targetFlyingMobs = mc.getBoolean("Targeters.Filters.Default.TargetFlyingMobs", true);
        this.targetSameFaction = mc.getBoolean("Targeters.Filters.Default.TargetSameFaction", true);
        this.targetOwner = mc.getBoolean("Targeters.Filters.Default.TargetOwner", true);
        this.targetNonMythic = mc.getBoolean("Targeters.Filters.Default.TargetNonMythic", true);
        this.targetVillagers = mc.getBoolean("Targeters.Filters.Default.TargetVillagers", true);
        this.mobsDespawnByDefault = mc.getBoolean("Mobs.DespawnByDefault", true);
        this.preventOtherDropsByDefault = mc.getBoolean("Mobs.PreventOtherDropsByDefault", false);
        this.EnableTimerSkills = mc.getBoolean("Mobs.EnableTimerSkills", true);
        this.EnableThreatTables = mc.getBoolean("Mobs.EnableThreatTables", true);
        this.killMessagePrefix = (String)MOBS_KILL_MESSAGE_PREFIX.get(this);
        this.bossBarUpdateInterval = mc.getInteger("Mobs.BossBar.UpdateInterval", 20);
        this.rsGeneratePoints = mc.getBoolean("RandomSpawning.GenerateSpawnPoints", false);
        this.rsMaxMobsPerChunk = mc.getInteger("RandomSpawning.MaxMobsPerChunk", 2);
        this.randomSpawningPlayerRadiusMax = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayer", 64);
        this.randomSpawningPlayerRadiusMin = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayerMin", 16);
        this.randomSpawningPlayerRadiusY = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayerY", 16);
        this.rsPointsPerSecondLand = mc.getInteger("RandomSpawning.PointsPerSecond.Land", 10);
        this.rsPointsPerSecondAir = mc.getInteger("RandomSpawning.PointsPerSecond.Air", 1);
        this.rsPointsPerSecondSea = mc.getInteger("RandomSpawning.PointsPerSecond.Sea", 1);
        this.rsPointsPerSecondLava = mc.getInteger("RandomSpawning.PointsPerSecond.Lava", 0);
        this.rsPointsPerSecondGround = mc.getInteger("RandomSpawning.PointsPerSecond.Ground", 0);
        this.rsDespawnVanillaOutsideRadius = mc.getBoolean("RandomSpawning.DespawnLazyRandomMobs", true);
        this.rsMaxGenerationTimeMillis = mc.getInteger("RandomSpawning.MaxGenerationTime", 20);
        this.vanillaSpawnsDisabled = mc.getBoolean("RandomSpawning.DisableVanillaSpawns", false);
        this.compatHeroesXPEnable = mc.getBoolean("Compatibility.Heroes.Enabled", this.compatHeroesXPEnable);
        this.compatHeroesShowXPMessage = mc.getBoolean("Compatibility.Heroes.ShowXPMessage", this.compatHeroesShowXPMessage);
        this.compatHeroesXPMessageFormat = mc.getString("Compatibility.Heroes.XPMessageFormat", this.compatHeroesXPMessageFormat);
        this.compatMcMMOShowXPMessage = mc.getBoolean("Compatibility.McMMO.ShowXPMessage", this.compatMcMMOShowXPMessage);
        this.compatMcMMOXPMessageFormat = mc.getString("Compatibility.McMMO.XPMessageFormat", this.compatMcMMOXPMessageFormat);
        this.compatSkillAPIShowXPMessage = mc.getBoolean("Compatibility.SkillAPI.ShowXPMessage", this.compatSkillAPIShowXPMessage);
        this.compatSkillAPIXPMessageFormat = mc.getString("Compatibility.SkillAPI.XPMessageFormat", this.compatSkillAPIXPMessageFormat);
        this.compatVaultShowMoneyMessage = mc.getBoolean("Compatibility.Vault.ShowMoneyMessage", this.compatVaultShowMoneyMessage);
        this.compatVaultMoneyMessageFormat = mc.getString("Compatibility.Vault.MoneyMessageFormat", this.compatVaultMoneyMessageFormat);
        this.compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(this.compatHeroesXPMessageFormat);
        this.compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(this.compatMcMMOXPMessageFormat);
        this.compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(this.compatSkillAPIXPMessageFormat);
        this.compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(this.compatVaultMoneyMessageFormat);
        this.updateItems = mc.getBoolean("ItemUpdating.Enabled", true);
        this.loadExampleConfigs = mc.getBoolean("LoadExampleConfigs", true);
        this.scalingEquationDamage = mc.getString("Mobs.ScalingEquations.Damage", "V * ((1.05)^(L-1))");
        this.scalingEquationHealth = mc.getString("Mobs.ScalingEquations.Health", "V * ((1.05)^(L-1))");
        if (this.settings.getCustomConfig().contains("Configuration.Mobs.Scaling")) {
            for (String world : this.settings.getCustomConfig().getConfigurationSection("Configuration.Mobs.Scaling").getKeys(false)) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "*** Loading WorldScaling for world " + world, new Object[0]);
                MythicConfigImpl mythicConfigImpl = new MythicConfigImpl("Configuration.Mobs.Scaling." + world, this.settings.getCustomConfig());
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Default Level Modifiers...", new Object[0]);
        this.defaultLevelModifierHealth = mc.getString("Mobs.DefaultLevelModifiers.Health", "0.1");
        this.defaultLevelModifierDamage = mc.getString("Mobs.DefaultLevelModifiers.Damage", "0");
        this.defaultLevelModifierPower = mc.getString("Mobs.DefaultLevelModifiers.Power", "0");
        this.defaultLevelModifierArmor = mc.getString("Mobs.DefaultLevelModifiers.Armor", "0");
        this.defaultLevelModifierKBR = mc.getString("Mobs.DefaultLevelModifiers.KnockbackResistance", "0");
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public boolean getDespawnMobsByDefault() {
        return this.mobsDespawnByDefault;
    }

    public boolean getPreventOtherDropsByDefault() {
        return this.preventOtherDropsByDefault;
    }

    public HashSet<Material> getTransparentBlocks() {
        return transparentBlocks;
    }

    public boolean shouldUpdateItems() {
        return this.updateItems;
    }

    @Override
    public String getPropertyNode() {
        return "Configuration";
    }

    public IOLoader<MythicBukkit> getSettings() {
        return this.settings;
    }

    public int getSpawningInterval() {
        return this.SpawningInterval;
    }

    public int getTimerupdate() {
        return this.timerupdate;
    }

    public int getWalkupdate() {
        return this.walkupdate;
    }

    public int getShowHealthRadius() {
        return this.ShowHealthRadius;
    }

    public int getScanInterval() {
        return this.ScanInterval;
    }

    public int getClnrInterval() {
        return this.ClnrInterval;
    }

    public boolean isEnableAIModifiers() {
        return this.EnableAIModifiers;
    }

    public boolean isEnableThreatTables() {
        return this.EnableThreatTables;
    }

    public String getDefaultLevelModifierHealth() {
        return this.defaultLevelModifierHealth;
    }

    public String getDefaultLevelModifierDamage() {
        return this.defaultLevelModifierDamage;
    }

    public String getDefaultLevelModifierPower() {
        return this.defaultLevelModifierPower;
    }

    public String getDefaultLevelModifierArmor() {
        return this.defaultLevelModifierArmor;
    }

    public String getDefaultLevelModifierKBR() {
        return this.defaultLevelModifierKBR;
    }

    public boolean isEnableTimerSkills() {
        return this.EnableTimerSkills;
    }

    public int getSpawnerRange() {
        return this.SpawnerRange;
    }

    public boolean isRsGeneratePoints() {
        return this.rsGeneratePoints;
    }

    public int getRsMaxMobsPerChunk() {
        return this.rsMaxMobsPerChunk;
    }

    public int getRsPointsPerSecondLand() {
        return this.rsPointsPerSecondLand;
    }

    public int getRsPointsPerSecondAir() {
        return this.rsPointsPerSecondAir;
    }

    public int getRsPointsPerSecondSea() {
        return this.rsPointsPerSecondSea;
    }

    public int getRsPointsPerSecondLava() {
        return this.rsPointsPerSecondLava;
    }

    public int getRsPointsPerSecondGround() {
        return this.rsPointsPerSecondGround;
    }

    public int getRsMaxGenerationTimeMillis() {
        return this.rsMaxGenerationTimeMillis;
    }

    public boolean isRsDespawnVanillaOutsideRadius() {
        return this.rsDespawnVanillaOutsideRadius;
    }

    public boolean isUpdateItems() {
        return this.updateItems;
    }

    public boolean isCompatHeroesXPEnable() {
        return this.compatHeroesXPEnable;
    }

    public boolean isCompatHeroesShowXPMessage() {
        return this.compatHeroesShowXPMessage;
    }

    public String getCompatHeroesXPMessageFormat() {
        return this.compatHeroesXPMessageFormat;
    }

    public boolean isCompatSkillAPIShowXPMessage() {
        return this.compatSkillAPIShowXPMessage;
    }

    public String getCompatSkillAPIXPMessageFormat() {
        return this.compatSkillAPIXPMessageFormat;
    }

    public boolean isCompatVaultShowMoneyMessage() {
        return this.compatVaultShowMoneyMessage;
    }

    public String getCompatVaultMoneyMessageFormat() {
        return this.compatVaultMoneyMessageFormat;
    }

    public boolean isCompatMcMMOShowXPMessage() {
        return this.compatMcMMOShowXPMessage;
    }

    public String getCompatMcMMOXPMessageFormat() {
        return this.compatMcMMOXPMessageFormat;
    }

    public void setSettings(IOLoader<MythicBukkit> settings) {
        this.settings = settings;
    }

    public void setConfig(MythicConfig config) {
        this.config = config;
    }

    public void setAllowMetrics(Boolean allowMetrics) {
        this.allowMetrics = allowMetrics;
    }

    public void setAllowUpdateChecking(Boolean allowUpdateChecking) {
        this.allowUpdateChecking = allowUpdateChecking;
    }

    public void setUseCompatibilityMode(Boolean useCompatibilityMode) {
        this.useCompatibilityMode = useCompatibilityMode;
    }

    public void setLoadExampleConfigs(Boolean loadExampleConfigs) {
        this.loadExampleConfigs = loadExampleConfigs;
    }

    public void setFireAPIDeathEvent(Boolean fireAPIDeathEvent) {
        this.fireAPIDeathEvent = fireAPIDeathEvent;
    }

    public void setFireAPISkillEvent(Boolean fireAPISkillEvent) {
        this.fireAPISkillEvent = fireAPISkillEvent;
    }

    public void setFireAPICustomSkillEvent(Boolean fireAPICustomSkillEvent) {
        this.fireAPICustomSkillEvent = fireAPICustomSkillEvent;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setDebugSpawners(boolean debugSpawners) {
        this.debugSpawners = debugSpawners;
    }

    public void setDoErrorLogging(Boolean doErrorLogging) {
        this.doErrorLogging = doErrorLogging;
    }

    public void setCancelDamageIfZero(boolean cancelDamageIfZero) {
        this.cancelDamageIfZero = cancelDamageIfZero;
    }

    public void setDefaultDropMethod(DropMethod defaultDropMethod) {
        this.defaultDropMethod = defaultDropMethod;
    }

    public void setClockIntervalMain(int clockIntervalMain) {
        this.clockIntervalMain = clockIntervalMain;
    }

    public void setClockIntervalRandomSpawning(int clockIntervalRandomSpawning) {
        this.clockIntervalRandomSpawning = clockIntervalRandomSpawning;
    }

    public void setClockIntervalSaving(int clockIntervalSaving) {
        this.clockIntervalSaving = clockIntervalSaving;
    }

    public void setSpawningInterval(int SpawningInterval) {
        this.SpawningInterval = SpawningInterval;
    }

    public void setTimerupdate(int timerupdate) {
        this.timerupdate = timerupdate;
    }

    public void setWalkupdate(int walkupdate) {
        this.walkupdate = walkupdate;
    }

    public void setShowHealthRadius(int ShowHealthRadius) {
        this.ShowHealthRadius = ShowHealthRadius;
    }

    public void setScanInterval(int ScanInterval) {
        this.ScanInterval = ScanInterval;
    }

    public void setClnrInterval(int ClnrInterval) {
        this.ClnrInterval = ClnrInterval;
    }

    public void setBossBarUpdateInterval(int bossBarUpdateInterval) {
        this.bossBarUpdateInterval = bossBarUpdateInterval;
    }

    public void setEnableAIModifiers(boolean EnableAIModifiers) {
        this.EnableAIModifiers = EnableAIModifiers;
    }

    public void setEnableThreatTables(boolean EnableThreatTables) {
        this.EnableThreatTables = EnableThreatTables;
    }

    public void setKillMessagePrefix(String killMessagePrefix) {
        this.killMessagePrefix = killMessagePrefix;
    }

    public void setMobsDespawnByDefault(Boolean mobsDespawnByDefault) {
        this.mobsDespawnByDefault = mobsDespawnByDefault;
    }

    public void setPreventOtherDropsByDefault(Boolean preventOtherDropsByDefault) {
        this.preventOtherDropsByDefault = preventOtherDropsByDefault;
    }

    public void setDefaultLevelModifierHealth(String defaultLevelModifierHealth) {
        this.defaultLevelModifierHealth = defaultLevelModifierHealth;
    }

    public void setDefaultLevelModifierDamage(String defaultLevelModifierDamage) {
        this.defaultLevelModifierDamage = defaultLevelModifierDamage;
    }

    public void setDefaultLevelModifierPower(String defaultLevelModifierPower) {
        this.defaultLevelModifierPower = defaultLevelModifierPower;
    }

    public void setDefaultLevelModifierArmor(String defaultLevelModifierArmor) {
        this.defaultLevelModifierArmor = defaultLevelModifierArmor;
    }

    public void setDefaultLevelModifierKBR(String defaultLevelModifierKBR) {
        this.defaultLevelModifierKBR = defaultLevelModifierKBR;
    }

    public void setScalingEquationDamage(String scalingEquationDamage) {
        this.scalingEquationDamage = scalingEquationDamage;
    }

    public void setScalingEquationHealth(String scalingEquationHealth) {
        this.scalingEquationHealth = scalingEquationHealth;
    }

    public void setEnableTimerSkills(boolean EnableTimerSkills) {
        this.EnableTimerSkills = EnableTimerSkills;
    }

    public void setSkillsIgnoreArmorStandsByDefault(Boolean skillsIgnoreArmorStandsByDefault) {
        this.skillsIgnoreArmorStandsByDefault = skillsIgnoreArmorStandsByDefault;
    }

    public void setTargetSelf(boolean targetSelf) {
        this.targetSelf = targetSelf;
    }

    public void setTargetPlayers(boolean targetPlayers) {
        this.targetPlayers = targetPlayers;
    }

    public void setTargetArmorStands(boolean targetArmorStands) {
        this.targetArmorStands = targetArmorStands;
    }

    public void setTargetMarkers(boolean targetMarkers) {
        this.targetMarkers = targetMarkers;
    }

    public void setTargetCreativeMode(boolean targetCreativeMode) {
        this.targetCreativeMode = targetCreativeMode;
    }

    public void setTargetSpectatorMode(boolean targetSpectatorMode) {
        this.targetSpectatorMode = targetSpectatorMode;
    }

    public void setTargetCitizensNPCs(boolean targetCitizensNPCs) {
        this.targetCitizensNPCs = targetCitizensNPCs;
    }

    public void setTargetAnimals(boolean targetAnimals) {
        this.targetAnimals = targetAnimals;
    }

    public void setTargetCreatures(boolean targetCreatures) {
        this.targetCreatures = targetCreatures;
    }

    public void setTargetMonsters(boolean targetMonsters) {
        this.targetMonsters = targetMonsters;
    }

    public void setTargetWaterMobs(boolean targetWaterMobs) {
        this.targetWaterMobs = targetWaterMobs;
    }

    public void setTargetFlyingMobs(boolean targetFlyingMobs) {
        this.targetFlyingMobs = targetFlyingMobs;
    }

    public void setTargetSameFaction(boolean targetSameFaction) {
        this.targetSameFaction = targetSameFaction;
    }

    public void setTargetOwner(boolean targetOwner) {
        this.targetOwner = targetOwner;
    }

    public void setTargetNonMythic(boolean targetNonMythic) {
        this.targetNonMythic = targetNonMythic;
    }

    public void setTargetVillagers(boolean targetVillagers) {
        this.targetVillagers = targetVillagers;
    }

    public void setSpawnerRange(int SpawnerRange) {
        this.SpawnerRange = SpawnerRange;
    }

    public void setRsGeneratePoints(boolean rsGeneratePoints) {
        this.rsGeneratePoints = rsGeneratePoints;
    }

    public void setRsMaxMobsPerChunk(int rsMaxMobsPerChunk) {
        this.rsMaxMobsPerChunk = rsMaxMobsPerChunk;
    }

    public void setRandomSpawningPlayerRadiusMax(int randomSpawningPlayerRadiusMax) {
        this.randomSpawningPlayerRadiusMax = randomSpawningPlayerRadiusMax;
    }

    public void setRandomSpawningPlayerRadiusMin(int randomSpawningPlayerRadiusMin) {
        this.randomSpawningPlayerRadiusMin = randomSpawningPlayerRadiusMin;
    }

    public void setRandomSpawningPlayerRadiusY(int randomSpawningPlayerRadiusY) {
        this.randomSpawningPlayerRadiusY = randomSpawningPlayerRadiusY;
    }

    public void setRsPointsPerSecondLand(int rsPointsPerSecondLand) {
        this.rsPointsPerSecondLand = rsPointsPerSecondLand;
    }

    public void setRsPointsPerSecondAir(int rsPointsPerSecondAir) {
        this.rsPointsPerSecondAir = rsPointsPerSecondAir;
    }

    public void setRsPointsPerSecondSea(int rsPointsPerSecondSea) {
        this.rsPointsPerSecondSea = rsPointsPerSecondSea;
    }

    public void setRsPointsPerSecondLava(int rsPointsPerSecondLava) {
        this.rsPointsPerSecondLava = rsPointsPerSecondLava;
    }

    public void setRsPointsPerSecondGround(int rsPointsPerSecondGround) {
        this.rsPointsPerSecondGround = rsPointsPerSecondGround;
    }

    public void setRsMaxGenerationTimeMillis(int rsMaxGenerationTimeMillis) {
        this.rsMaxGenerationTimeMillis = rsMaxGenerationTimeMillis;
    }

    public void setRsDespawnVanillaOutsideRadius(boolean rsDespawnVanillaOutsideRadius) {
        this.rsDespawnVanillaOutsideRadius = rsDespawnVanillaOutsideRadius;
    }

    public void setVanillaSpawnsDisabled(boolean vanillaSpawnsDisabled) {
        this.vanillaSpawnsDisabled = vanillaSpawnsDisabled;
    }

    public void setUpdateItems(boolean updateItems) {
        this.updateItems = updateItems;
    }

    public void setCompatHeroesXPEnable(boolean compatHeroesXPEnable) {
        this.compatHeroesXPEnable = compatHeroesXPEnable;
    }

    public void setCompatHeroesShowXPMessage(boolean compatHeroesShowXPMessage) {
        this.compatHeroesShowXPMessage = compatHeroesShowXPMessage;
    }

    public void setCompatHeroesXPMessageFormat(String compatHeroesXPMessageFormat) {
        this.compatHeroesXPMessageFormat = compatHeroesXPMessageFormat;
    }

    public void setCompatSkillAPIShowXPMessage(boolean compatSkillAPIShowXPMessage) {
        this.compatSkillAPIShowXPMessage = compatSkillAPIShowXPMessage;
    }

    public void setCompatSkillAPIXPMessageFormat(String compatSkillAPIXPMessageFormat) {
        this.compatSkillAPIXPMessageFormat = compatSkillAPIXPMessageFormat;
    }

    public void setCompatVaultShowMoneyMessage(boolean compatVaultShowMoneyMessage) {
        this.compatVaultShowMoneyMessage = compatVaultShowMoneyMessage;
    }

    public void setCompatVaultMoneyMessageFormat(String compatVaultMoneyMessageFormat) {
        this.compatVaultMoneyMessageFormat = compatVaultMoneyMessageFormat;
    }

    public void setCompatMcMMOShowXPMessage(boolean compatMcMMOShowXPMessage) {
        this.compatMcMMOShowXPMessage = compatMcMMOShowXPMessage;
    }

    public void setCompatMcMMOXPMessageFormat(String compatMcMMOXPMessageFormat) {
        this.compatMcMMOXPMessageFormat = compatMcMMOXPMessageFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LegacyConfigExecutor)) {
            return false;
        }
        LegacyConfigExecutor other = (LegacyConfigExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDebugLevel() != other.getDebugLevel()) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        if (this.isDebugSpawners() != other.isDebugSpawners()) {
            return false;
        }
        if (this.isCancelDamageIfZero() != other.isCancelDamageIfZero()) {
            return false;
        }
        if (this.getClockIntervalMain() != other.getClockIntervalMain()) {
            return false;
        }
        if (this.getClockIntervalRandomSpawning() != other.getClockIntervalRandomSpawning()) {
            return false;
        }
        if (this.getClockIntervalSaving() != other.getClockIntervalSaving()) {
            return false;
        }
        if (this.getSpawningInterval() != other.getSpawningInterval()) {
            return false;
        }
        if (this.getTimerupdate() != other.getTimerupdate()) {
            return false;
        }
        if (this.getWalkupdate() != other.getWalkupdate()) {
            return false;
        }
        if (this.getShowHealthRadius() != other.getShowHealthRadius()) {
            return false;
        }
        if (this.getScanInterval() != other.getScanInterval()) {
            return false;
        }
        if (this.getClnrInterval() != other.getClnrInterval()) {
            return false;
        }
        if (this.getBossBarUpdateInterval() != other.getBossBarUpdateInterval()) {
            return false;
        }
        if (this.isEnableAIModifiers() != other.isEnableAIModifiers()) {
            return false;
        }
        if (this.isEnableThreatTables() != other.isEnableThreatTables()) {
            return false;
        }
        if (this.isEnableTimerSkills() != other.isEnableTimerSkills()) {
            return false;
        }
        if (this.isTargetSelf() != other.isTargetSelf()) {
            return false;
        }
        if (this.isTargetPlayers() != other.isTargetPlayers()) {
            return false;
        }
        if (this.isTargetArmorStands() != other.isTargetArmorStands()) {
            return false;
        }
        if (this.isTargetMarkers() != other.isTargetMarkers()) {
            return false;
        }
        if (this.isTargetCreativeMode() != other.isTargetCreativeMode()) {
            return false;
        }
        if (this.isTargetSpectatorMode() != other.isTargetSpectatorMode()) {
            return false;
        }
        if (this.isTargetCitizensNPCs() != other.isTargetCitizensNPCs()) {
            return false;
        }
        if (this.isTargetAnimals() != other.isTargetAnimals()) {
            return false;
        }
        if (this.isTargetCreatures() != other.isTargetCreatures()) {
            return false;
        }
        if (this.isTargetMonsters() != other.isTargetMonsters()) {
            return false;
        }
        if (this.isTargetWaterMobs() != other.isTargetWaterMobs()) {
            return false;
        }
        if (this.isTargetFlyingMobs() != other.isTargetFlyingMobs()) {
            return false;
        }
        if (this.isTargetSameFaction() != other.isTargetSameFaction()) {
            return false;
        }
        if (this.isTargetOwner() != other.isTargetOwner()) {
            return false;
        }
        if (this.isTargetNonMythic() != other.isTargetNonMythic()) {
            return false;
        }
        if (this.isTargetVillagers() != other.isTargetVillagers()) {
            return false;
        }
        if (this.getSpawnerRange() != other.getSpawnerRange()) {
            return false;
        }
        if (this.isRsGeneratePoints() != other.isRsGeneratePoints()) {
            return false;
        }
        if (this.getRsMaxMobsPerChunk() != other.getRsMaxMobsPerChunk()) {
            return false;
        }
        if (this.getRandomSpawningPlayerRadiusMax() != other.getRandomSpawningPlayerRadiusMax()) {
            return false;
        }
        if (this.getRandomSpawningPlayerRadiusMin() != other.getRandomSpawningPlayerRadiusMin()) {
            return false;
        }
        if (this.getRandomSpawningPlayerRadiusY() != other.getRandomSpawningPlayerRadiusY()) {
            return false;
        }
        if (this.getRsPointsPerSecondLand() != other.getRsPointsPerSecondLand()) {
            return false;
        }
        if (this.getRsPointsPerSecondAir() != other.getRsPointsPerSecondAir()) {
            return false;
        }
        if (this.getRsPointsPerSecondSea() != other.getRsPointsPerSecondSea()) {
            return false;
        }
        if (this.getRsPointsPerSecondLava() != other.getRsPointsPerSecondLava()) {
            return false;
        }
        if (this.getRsPointsPerSecondGround() != other.getRsPointsPerSecondGround()) {
            return false;
        }
        if (this.getRsMaxGenerationTimeMillis() != other.getRsMaxGenerationTimeMillis()) {
            return false;
        }
        if (this.isRsDespawnVanillaOutsideRadius() != other.isRsDespawnVanillaOutsideRadius()) {
            return false;
        }
        if (this.isVanillaSpawnsDisabled() != other.isVanillaSpawnsDisabled()) {
            return false;
        }
        if (this.isUpdateItems() != other.isUpdateItems()) {
            return false;
        }
        if (this.isCompatHeroesXPEnable() != other.isCompatHeroesXPEnable()) {
            return false;
        }
        if (this.isCompatHeroesShowXPMessage() != other.isCompatHeroesShowXPMessage()) {
            return false;
        }
        if (this.isCompatSkillAPIShowXPMessage() != other.isCompatSkillAPIShowXPMessage()) {
            return false;
        }
        if (this.isCompatVaultShowMoneyMessage() != other.isCompatVaultShowMoneyMessage()) {
            return false;
        }
        if (this.isCompatMcMMOShowXPMessage() != other.isCompatMcMMOShowXPMessage()) {
            return false;
        }
        Boolean this$allowMetrics = this.getAllowMetrics();
        Boolean other$allowMetrics = other.getAllowMetrics();
        if (this$allowMetrics == null ? other$allowMetrics != null : !((Object)this$allowMetrics).equals(other$allowMetrics)) {
            return false;
        }
        Boolean this$allowUpdateChecking = this.getAllowUpdateChecking();
        Boolean other$allowUpdateChecking = other.getAllowUpdateChecking();
        if (this$allowUpdateChecking == null ? other$allowUpdateChecking != null : !((Object)this$allowUpdateChecking).equals(other$allowUpdateChecking)) {
            return false;
        }
        Boolean this$useCompatibilityMode = this.getUseCompatibilityMode();
        Boolean other$useCompatibilityMode = other.getUseCompatibilityMode();
        if (this$useCompatibilityMode == null ? other$useCompatibilityMode != null : !((Object)this$useCompatibilityMode).equals(other$useCompatibilityMode)) {
            return false;
        }
        Boolean this$loadExampleConfigs = this.getLoadExampleConfigs();
        Boolean other$loadExampleConfigs = other.getLoadExampleConfigs();
        if (this$loadExampleConfigs == null ? other$loadExampleConfigs != null : !((Object)this$loadExampleConfigs).equals(other$loadExampleConfigs)) {
            return false;
        }
        Boolean this$fireAPIDeathEvent = this.getFireAPIDeathEvent();
        Boolean other$fireAPIDeathEvent = other.getFireAPIDeathEvent();
        if (this$fireAPIDeathEvent == null ? other$fireAPIDeathEvent != null : !((Object)this$fireAPIDeathEvent).equals(other$fireAPIDeathEvent)) {
            return false;
        }
        Boolean this$fireAPISkillEvent = this.getFireAPISkillEvent();
        Boolean other$fireAPISkillEvent = other.getFireAPISkillEvent();
        if (this$fireAPISkillEvent == null ? other$fireAPISkillEvent != null : !((Object)this$fireAPISkillEvent).equals(other$fireAPISkillEvent)) {
            return false;
        }
        Boolean this$fireAPICustomSkillEvent = this.getFireAPICustomSkillEvent();
        Boolean other$fireAPICustomSkillEvent = other.getFireAPICustomSkillEvent();
        if (this$fireAPICustomSkillEvent == null ? other$fireAPICustomSkillEvent != null : !((Object)this$fireAPICustomSkillEvent).equals(other$fireAPICustomSkillEvent)) {
            return false;
        }
        Boolean this$doErrorLogging = this.getDoErrorLogging();
        Boolean other$doErrorLogging = other.getDoErrorLogging();
        if (this$doErrorLogging == null ? other$doErrorLogging != null : !((Object)this$doErrorLogging).equals(other$doErrorLogging)) {
            return false;
        }
        Boolean this$mobsDespawnByDefault = this.getMobsDespawnByDefault();
        Boolean other$mobsDespawnByDefault = other.getMobsDespawnByDefault();
        if (this$mobsDespawnByDefault == null ? other$mobsDespawnByDefault != null : !((Object)this$mobsDespawnByDefault).equals(other$mobsDespawnByDefault)) {
            return false;
        }
        if (this.getPreventOtherDropsByDefault() != other.getPreventOtherDropsByDefault()) {
            return false;
        }
        Boolean this$skillsIgnoreArmorStandsByDefault = this.getSkillsIgnoreArmorStandsByDefault();
        Boolean other$skillsIgnoreArmorStandsByDefault = other.getSkillsIgnoreArmorStandsByDefault();
        if (this$skillsIgnoreArmorStandsByDefault == null ? other$skillsIgnoreArmorStandsByDefault != null : !((Object)this$skillsIgnoreArmorStandsByDefault).equals(other$skillsIgnoreArmorStandsByDefault)) {
            return false;
        }
        IOLoader<MythicBukkit> this$settings = this.getSettings();
        IOLoader<MythicBukkit> other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        MythicConfig this$config = this.getConfig();
        MythicConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        DropMethod this$defaultDropMethod = this.getDefaultDropMethod();
        DropMethod other$defaultDropMethod = other.getDefaultDropMethod();
        if (this$defaultDropMethod == null ? other$defaultDropMethod != null : !((Object)((Object)this$defaultDropMethod)).equals((Object)other$defaultDropMethod)) {
            return false;
        }
        String this$killMessagePrefix = this.getKillMessagePrefix();
        String other$killMessagePrefix = other.getKillMessagePrefix();
        if (this$killMessagePrefix == null ? other$killMessagePrefix != null : !this$killMessagePrefix.equals(other$killMessagePrefix)) {
            return false;
        }
        String this$defaultLevelModifierHealth = this.getDefaultLevelModifierHealth();
        String other$defaultLevelModifierHealth = other.getDefaultLevelModifierHealth();
        if (this$defaultLevelModifierHealth == null ? other$defaultLevelModifierHealth != null : !this$defaultLevelModifierHealth.equals(other$defaultLevelModifierHealth)) {
            return false;
        }
        String this$defaultLevelModifierDamage = this.getDefaultLevelModifierDamage();
        String other$defaultLevelModifierDamage = other.getDefaultLevelModifierDamage();
        if (this$defaultLevelModifierDamage == null ? other$defaultLevelModifierDamage != null : !this$defaultLevelModifierDamage.equals(other$defaultLevelModifierDamage)) {
            return false;
        }
        String this$defaultLevelModifierPower = this.getDefaultLevelModifierPower();
        String other$defaultLevelModifierPower = other.getDefaultLevelModifierPower();
        if (this$defaultLevelModifierPower == null ? other$defaultLevelModifierPower != null : !this$defaultLevelModifierPower.equals(other$defaultLevelModifierPower)) {
            return false;
        }
        String this$defaultLevelModifierArmor = this.getDefaultLevelModifierArmor();
        String other$defaultLevelModifierArmor = other.getDefaultLevelModifierArmor();
        if (this$defaultLevelModifierArmor == null ? other$defaultLevelModifierArmor != null : !this$defaultLevelModifierArmor.equals(other$defaultLevelModifierArmor)) {
            return false;
        }
        String this$defaultLevelModifierKBR = this.getDefaultLevelModifierKBR();
        String other$defaultLevelModifierKBR = other.getDefaultLevelModifierKBR();
        if (this$defaultLevelModifierKBR == null ? other$defaultLevelModifierKBR != null : !this$defaultLevelModifierKBR.equals(other$defaultLevelModifierKBR)) {
            return false;
        }
        String this$scalingEquationDamage = this.getScalingEquationDamage();
        String other$scalingEquationDamage = other.getScalingEquationDamage();
        if (this$scalingEquationDamage == null ? other$scalingEquationDamage != null : !this$scalingEquationDamage.equals(other$scalingEquationDamage)) {
            return false;
        }
        String this$scalingEquationHealth = this.getScalingEquationHealth();
        String other$scalingEquationHealth = other.getScalingEquationHealth();
        if (this$scalingEquationHealth == null ? other$scalingEquationHealth != null : !this$scalingEquationHealth.equals(other$scalingEquationHealth)) {
            return false;
        }
        String this$compatHeroesXPMessageFormat = this.getCompatHeroesXPMessageFormat();
        String other$compatHeroesXPMessageFormat = other.getCompatHeroesXPMessageFormat();
        if (this$compatHeroesXPMessageFormat == null ? other$compatHeroesXPMessageFormat != null : !this$compatHeroesXPMessageFormat.equals(other$compatHeroesXPMessageFormat)) {
            return false;
        }
        String this$compatSkillAPIXPMessageFormat = this.getCompatSkillAPIXPMessageFormat();
        String other$compatSkillAPIXPMessageFormat = other.getCompatSkillAPIXPMessageFormat();
        if (this$compatSkillAPIXPMessageFormat == null ? other$compatSkillAPIXPMessageFormat != null : !this$compatSkillAPIXPMessageFormat.equals(other$compatSkillAPIXPMessageFormat)) {
            return false;
        }
        String this$compatVaultMoneyMessageFormat = this.getCompatVaultMoneyMessageFormat();
        String other$compatVaultMoneyMessageFormat = other.getCompatVaultMoneyMessageFormat();
        if (this$compatVaultMoneyMessageFormat == null ? other$compatVaultMoneyMessageFormat != null : !this$compatVaultMoneyMessageFormat.equals(other$compatVaultMoneyMessageFormat)) {
            return false;
        }
        String this$compatMcMMOXPMessageFormat = this.getCompatMcMMOXPMessageFormat();
        String other$compatMcMMOXPMessageFormat = other.getCompatMcMMOXPMessageFormat();
        if (this$compatMcMMOXPMessageFormat == null ? other$compatMcMMOXPMessageFormat != null : !this$compatMcMMOXPMessageFormat.equals(other$compatMcMMOXPMessageFormat)) {
            return false;
        }
        MythicBukkit this$plugin = this.getPlugin();
        MythicBukkit other$plugin = other.getPlugin();
        return !(this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LegacyConfigExecutor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDebugLevel();
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + (this.isDebugSpawners() ? 79 : 97);
        result = result * 59 + (this.isCancelDamageIfZero() ? 79 : 97);
        result = result * 59 + this.getClockIntervalMain();
        result = result * 59 + this.getClockIntervalRandomSpawning();
        result = result * 59 + this.getClockIntervalSaving();
        result = result * 59 + this.getSpawningInterval();
        result = result * 59 + this.getTimerupdate();
        result = result * 59 + this.getWalkupdate();
        result = result * 59 + this.getShowHealthRadius();
        result = result * 59 + this.getScanInterval();
        result = result * 59 + this.getClnrInterval();
        result = result * 59 + this.getBossBarUpdateInterval();
        result = result * 59 + (this.isEnableAIModifiers() ? 79 : 97);
        result = result * 59 + (this.isEnableThreatTables() ? 79 : 97);
        result = result * 59 + (this.isEnableTimerSkills() ? 79 : 97);
        result = result * 59 + (this.isTargetSelf() ? 79 : 97);
        result = result * 59 + (this.isTargetPlayers() ? 79 : 97);
        result = result * 59 + (this.isTargetArmorStands() ? 79 : 97);
        result = result * 59 + (this.isTargetMarkers() ? 79 : 97);
        result = result * 59 + (this.isTargetCreativeMode() ? 79 : 97);
        result = result * 59 + (this.isTargetSpectatorMode() ? 79 : 97);
        result = result * 59 + (this.isTargetCitizensNPCs() ? 79 : 97);
        result = result * 59 + (this.isTargetAnimals() ? 79 : 97);
        result = result * 59 + (this.isTargetCreatures() ? 79 : 97);
        result = result * 59 + (this.isTargetMonsters() ? 79 : 97);
        result = result * 59 + (this.isTargetWaterMobs() ? 79 : 97);
        result = result * 59 + (this.isTargetFlyingMobs() ? 79 : 97);
        result = result * 59 + (this.isTargetSameFaction() ? 79 : 97);
        result = result * 59 + (this.isTargetOwner() ? 79 : 97);
        result = result * 59 + (this.isTargetNonMythic() ? 79 : 97);
        result = result * 59 + (this.isTargetVillagers() ? 79 : 97);
        result = result * 59 + this.getSpawnerRange();
        result = result * 59 + (this.isRsGeneratePoints() ? 79 : 97);
        result = result * 59 + this.getRsMaxMobsPerChunk();
        result = result * 59 + this.getRandomSpawningPlayerRadiusMax();
        result = result * 59 + this.getRandomSpawningPlayerRadiusMin();
        result = result * 59 + this.getRandomSpawningPlayerRadiusY();
        result = result * 59 + this.getRsPointsPerSecondLand();
        result = result * 59 + this.getRsPointsPerSecondAir();
        result = result * 59 + this.getRsPointsPerSecondSea();
        result = result * 59 + this.getRsPointsPerSecondLava();
        result = result * 59 + this.getRsPointsPerSecondGround();
        result = result * 59 + this.getRsMaxGenerationTimeMillis();
        result = result * 59 + (this.isRsDespawnVanillaOutsideRadius() ? 79 : 97);
        result = result * 59 + (this.isVanillaSpawnsDisabled() ? 79 : 97);
        result = result * 59 + (this.isUpdateItems() ? 79 : 97);
        result = result * 59 + (this.isCompatHeroesXPEnable() ? 79 : 97);
        result = result * 59 + (this.isCompatHeroesShowXPMessage() ? 79 : 97);
        result = result * 59 + (this.isCompatSkillAPIShowXPMessage() ? 79 : 97);
        result = result * 59 + (this.isCompatVaultShowMoneyMessage() ? 79 : 97);
        result = result * 59 + (this.isCompatMcMMOShowXPMessage() ? 79 : 97);
        Boolean $allowMetrics = this.getAllowMetrics();
        result = result * 59 + ($allowMetrics == null ? 43 : ((Object)$allowMetrics).hashCode());
        Boolean $allowUpdateChecking = this.getAllowUpdateChecking();
        result = result * 59 + ($allowUpdateChecking == null ? 43 : ((Object)$allowUpdateChecking).hashCode());
        Boolean $useCompatibilityMode = this.getUseCompatibilityMode();
        result = result * 59 + ($useCompatibilityMode == null ? 43 : ((Object)$useCompatibilityMode).hashCode());
        Boolean $loadExampleConfigs = this.getLoadExampleConfigs();
        result = result * 59 + ($loadExampleConfigs == null ? 43 : ((Object)$loadExampleConfigs).hashCode());
        Boolean $fireAPIDeathEvent = this.getFireAPIDeathEvent();
        result = result * 59 + ($fireAPIDeathEvent == null ? 43 : ((Object)$fireAPIDeathEvent).hashCode());
        Boolean $fireAPISkillEvent = this.getFireAPISkillEvent();
        result = result * 59 + ($fireAPISkillEvent == null ? 43 : ((Object)$fireAPISkillEvent).hashCode());
        Boolean $fireAPICustomSkillEvent = this.getFireAPICustomSkillEvent();
        result = result * 59 + ($fireAPICustomSkillEvent == null ? 43 : ((Object)$fireAPICustomSkillEvent).hashCode());
        Boolean $doErrorLogging = this.getDoErrorLogging();
        result = result * 59 + ($doErrorLogging == null ? 43 : ((Object)$doErrorLogging).hashCode());
        Boolean $mobsDespawnByDefault = this.getMobsDespawnByDefault();
        result = result * 59 + ($mobsDespawnByDefault == null ? 43 : ((Object)$mobsDespawnByDefault).hashCode());
        result = result * 59 + (this.getPreventOtherDropsByDefault() ? 79 : 97);
        Boolean $skillsIgnoreArmorStandsByDefault = this.getSkillsIgnoreArmorStandsByDefault();
        result = result * 59 + ($skillsIgnoreArmorStandsByDefault == null ? 43 : ((Object)$skillsIgnoreArmorStandsByDefault).hashCode());
        IOLoader<MythicBukkit> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        MythicConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        DropMethod $defaultDropMethod = this.getDefaultDropMethod();
        result = result * 59 + ($defaultDropMethod == null ? 43 : ((Object)((Object)$defaultDropMethod)).hashCode());
        String $killMessagePrefix = this.getKillMessagePrefix();
        result = result * 59 + ($killMessagePrefix == null ? 43 : $killMessagePrefix.hashCode());
        String $defaultLevelModifierHealth = this.getDefaultLevelModifierHealth();
        result = result * 59 + ($defaultLevelModifierHealth == null ? 43 : $defaultLevelModifierHealth.hashCode());
        String $defaultLevelModifierDamage = this.getDefaultLevelModifierDamage();
        result = result * 59 + ($defaultLevelModifierDamage == null ? 43 : $defaultLevelModifierDamage.hashCode());
        String $defaultLevelModifierPower = this.getDefaultLevelModifierPower();
        result = result * 59 + ($defaultLevelModifierPower == null ? 43 : $defaultLevelModifierPower.hashCode());
        String $defaultLevelModifierArmor = this.getDefaultLevelModifierArmor();
        result = result * 59 + ($defaultLevelModifierArmor == null ? 43 : $defaultLevelModifierArmor.hashCode());
        String $defaultLevelModifierKBR = this.getDefaultLevelModifierKBR();
        result = result * 59 + ($defaultLevelModifierKBR == null ? 43 : $defaultLevelModifierKBR.hashCode());
        String $scalingEquationDamage = this.getScalingEquationDamage();
        result = result * 59 + ($scalingEquationDamage == null ? 43 : $scalingEquationDamage.hashCode());
        String $scalingEquationHealth = this.getScalingEquationHealth();
        result = result * 59 + ($scalingEquationHealth == null ? 43 : $scalingEquationHealth.hashCode());
        String $compatHeroesXPMessageFormat = this.getCompatHeroesXPMessageFormat();
        result = result * 59 + ($compatHeroesXPMessageFormat == null ? 43 : $compatHeroesXPMessageFormat.hashCode());
        String $compatSkillAPIXPMessageFormat = this.getCompatSkillAPIXPMessageFormat();
        result = result * 59 + ($compatSkillAPIXPMessageFormat == null ? 43 : $compatSkillAPIXPMessageFormat.hashCode());
        String $compatVaultMoneyMessageFormat = this.getCompatVaultMoneyMessageFormat();
        result = result * 59 + ($compatVaultMoneyMessageFormat == null ? 43 : $compatVaultMoneyMessageFormat.hashCode());
        String $compatMcMMOXPMessageFormat = this.getCompatMcMMOXPMessageFormat();
        result = result * 59 + ($compatMcMMOXPMessageFormat == null ? 43 : $compatMcMMOXPMessageFormat.hashCode());
        MythicBukkit $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        return result;
    }

    public String toString() {
        return "LegacyConfigExecutor(settings=" + String.valueOf(this.getSettings()) + ", config=" + String.valueOf(this.getConfig()) + ", allowMetrics=" + this.getAllowMetrics() + ", allowUpdateChecking=" + this.getAllowUpdateChecking() + ", useCompatibilityMode=" + this.getUseCompatibilityMode() + ", loadExampleConfigs=" + this.getLoadExampleConfigs() + ", fireAPIDeathEvent=" + this.getFireAPIDeathEvent() + ", fireAPISkillEvent=" + this.getFireAPISkillEvent() + ", fireAPICustomSkillEvent=" + this.getFireAPICustomSkillEvent() + ", debugLevel=" + this.getDebugLevel() + ", debugMode=" + this.isDebugMode() + ", debugSpawners=" + this.isDebugSpawners() + ", doErrorLogging=" + this.getDoErrorLogging() + ", cancelDamageIfZero=" + this.isCancelDamageIfZero() + ", defaultDropMethod=" + String.valueOf((Object)this.getDefaultDropMethod()) + ", clockIntervalMain=" + this.getClockIntervalMain() + ", clockIntervalRandomSpawning=" + this.getClockIntervalRandomSpawning() + ", clockIntervalSaving=" + this.getClockIntervalSaving() + ", SpawningInterval=" + this.getSpawningInterval() + ", timerupdate=" + this.getTimerupdate() + ", walkupdate=" + this.getWalkupdate() + ", ShowHealthRadius=" + this.getShowHealthRadius() + ", ScanInterval=" + this.getScanInterval() + ", ClnrInterval=" + this.getClnrInterval() + ", bossBarUpdateInterval=" + this.getBossBarUpdateInterval() + ", EnableAIModifiers=" + this.isEnableAIModifiers() + ", EnableThreatTables=" + this.isEnableThreatTables() + ", killMessagePrefix=" + this.getKillMessagePrefix() + ", mobsDespawnByDefault=" + this.getMobsDespawnByDefault() + ", preventOtherDropsByDefault=" + this.getPreventOtherDropsByDefault() + ", defaultLevelModifierHealth=" + this.getDefaultLevelModifierHealth() + ", defaultLevelModifierDamage=" + this.getDefaultLevelModifierDamage() + ", defaultLevelModifierPower=" + this.getDefaultLevelModifierPower() + ", defaultLevelModifierArmor=" + this.getDefaultLevelModifierArmor() + ", defaultLevelModifierKBR=" + this.getDefaultLevelModifierKBR() + ", scalingEquationDamage=" + this.getScalingEquationDamage() + ", scalingEquationHealth=" + this.getScalingEquationHealth() + ", EnableTimerSkills=" + this.isEnableTimerSkills() + ", skillsIgnoreArmorStandsByDefault=" + this.getSkillsIgnoreArmorStandsByDefault() + ", targetSelf=" + this.isTargetSelf() + ", targetPlayers=" + this.isTargetPlayers() + ", targetArmorStands=" + this.isTargetArmorStands() + ", targetMarkers=" + this.isTargetMarkers() + ", targetCreativeMode=" + this.isTargetCreativeMode() + ", targetSpectatorMode=" + this.isTargetSpectatorMode() + ", targetCitizensNPCs=" + this.isTargetCitizensNPCs() + ", targetAnimals=" + this.isTargetAnimals() + ", targetCreatures=" + this.isTargetCreatures() + ", targetMonsters=" + this.isTargetMonsters() + ", targetWaterMobs=" + this.isTargetWaterMobs() + ", targetFlyingMobs=" + this.isTargetFlyingMobs() + ", targetSameFaction=" + this.isTargetSameFaction() + ", targetOwner=" + this.isTargetOwner() + ", targetNonMythic=" + this.isTargetNonMythic() + ", targetVillagers=" + this.isTargetVillagers() + ", SpawnerRange=" + this.getSpawnerRange() + ", rsGeneratePoints=" + this.isRsGeneratePoints() + ", rsMaxMobsPerChunk=" + this.getRsMaxMobsPerChunk() + ", randomSpawningPlayerRadiusMax=" + this.getRandomSpawningPlayerRadiusMax() + ", randomSpawningPlayerRadiusMin=" + this.getRandomSpawningPlayerRadiusMin() + ", randomSpawningPlayerRadiusY=" + this.getRandomSpawningPlayerRadiusY() + ", rsPointsPerSecondLand=" + this.getRsPointsPerSecondLand() + ", rsPointsPerSecondAir=" + this.getRsPointsPerSecondAir() + ", rsPointsPerSecondSea=" + this.getRsPointsPerSecondSea() + ", rsPointsPerSecondLava=" + this.getRsPointsPerSecondLava() + ", rsPointsPerSecondGround=" + this.getRsPointsPerSecondGround() + ", rsMaxGenerationTimeMillis=" + this.getRsMaxGenerationTimeMillis() + ", rsDespawnVanillaOutsideRadius=" + this.isRsDespawnVanillaOutsideRadius() + ", vanillaSpawnsDisabled=" + this.isVanillaSpawnsDisabled() + ", updateItems=" + this.isUpdateItems() + ", compatHeroesXPEnable=" + this.isCompatHeroesXPEnable() + ", compatHeroesShowXPMessage=" + this.isCompatHeroesShowXPMessage() + ", compatHeroesXPMessageFormat=" + this.getCompatHeroesXPMessageFormat() + ", compatSkillAPIShowXPMessage=" + this.isCompatSkillAPIShowXPMessage() + ", compatSkillAPIXPMessageFormat=" + this.getCompatSkillAPIXPMessageFormat() + ", compatVaultShowMoneyMessage=" + this.isCompatVaultShowMoneyMessage() + ", compatVaultMoneyMessageFormat=" + this.getCompatVaultMoneyMessageFormat() + ", compatMcMMOShowXPMessage=" + this.isCompatMcMMOShowXPMessage() + ", compatMcMMOXPMessageFormat=" + this.getCompatMcMMOXPMessageFormat() + ", plugin=" + String.valueOf(this.getPlugin()) + ")";
    }

    public Boolean getAllowMetrics() {
        return this.allowMetrics;
    }

    public Boolean getAllowUpdateChecking() {
        return this.allowUpdateChecking;
    }

    public Boolean getUseCompatibilityMode() {
        return this.useCompatibilityMode;
    }

    public Boolean getLoadExampleConfigs() {
        return this.loadExampleConfigs;
    }

    public Boolean getFireAPIDeathEvent() {
        return this.fireAPIDeathEvent;
    }

    public Boolean getFireAPISkillEvent() {
        return this.fireAPISkillEvent;
    }

    public Boolean getFireAPICustomSkillEvent() {
        return this.fireAPICustomSkillEvent;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isDebugSpawners() {
        return this.debugSpawners;
    }

    public Boolean getDoErrorLogging() {
        return this.doErrorLogging;
    }

    public boolean isCancelDamageIfZero() {
        return this.cancelDamageIfZero;
    }

    public DropMethod getDefaultDropMethod() {
        return this.defaultDropMethod;
    }

    public int getClockIntervalMain() {
        return this.clockIntervalMain;
    }

    public int getClockIntervalRandomSpawning() {
        return this.clockIntervalRandomSpawning;
    }

    public int getClockIntervalSaving() {
        return this.clockIntervalSaving;
    }

    public int getBossBarUpdateInterval() {
        return this.bossBarUpdateInterval;
    }

    public String getKillMessagePrefix() {
        return this.killMessagePrefix;
    }

    public Boolean getMobsDespawnByDefault() {
        return this.mobsDespawnByDefault;
    }

    public String getScalingEquationDamage() {
        return this.scalingEquationDamage;
    }

    public String getScalingEquationHealth() {
        return this.scalingEquationHealth;
    }

    public Boolean getSkillsIgnoreArmorStandsByDefault() {
        return this.skillsIgnoreArmorStandsByDefault;
    }

    public boolean isTargetSelf() {
        return this.targetSelf;
    }

    public boolean isTargetPlayers() {
        return this.targetPlayers;
    }

    public boolean isTargetArmorStands() {
        return this.targetArmorStands;
    }

    public boolean isTargetMarkers() {
        return this.targetMarkers;
    }

    public boolean isTargetCreativeMode() {
        return this.targetCreativeMode;
    }

    public boolean isTargetSpectatorMode() {
        return this.targetSpectatorMode;
    }

    public boolean isTargetCitizensNPCs() {
        return this.targetCitizensNPCs;
    }

    public boolean isTargetAnimals() {
        return this.targetAnimals;
    }

    public boolean isTargetCreatures() {
        return this.targetCreatures;
    }

    public boolean isTargetMonsters() {
        return this.targetMonsters;
    }

    public boolean isTargetWaterMobs() {
        return this.targetWaterMobs;
    }

    public boolean isTargetFlyingMobs() {
        return this.targetFlyingMobs;
    }

    public boolean isTargetSameFaction() {
        return this.targetSameFaction;
    }

    public boolean isTargetOwner() {
        return this.targetOwner;
    }

    public boolean isTargetNonMythic() {
        return this.targetNonMythic;
    }

    public boolean isTargetVillagers() {
        return this.targetVillagers;
    }

    public int getRandomSpawningPlayerRadiusMax() {
        return this.randomSpawningPlayerRadiusMax;
    }

    public int getRandomSpawningPlayerRadiusMin() {
        return this.randomSpawningPlayerRadiusMin;
    }

    public int getRandomSpawningPlayerRadiusY() {
        return this.randomSpawningPlayerRadiusY;
    }

    public boolean isVanillaSpawnsDisabled() {
        return this.vanillaSpawnsDisabled;
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    static {
        for (Material m4 : Material.values()) {
            if (!m4.isTransparent() && m4.isSolid() && m4.isOccluding()) continue;
            transparentBlocks.add(m4);
        }
    }
}

