/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.config;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderBoolean;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.serialize.Percent;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.config.GenericConfig;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderBooleanImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderColorImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class MythicConfigImpl
implements GenericConfig,
Cloneable,
MythicConfig {
    private String configName;
    private File file;
    private FileConfiguration fc;

    public MythicConfigImpl(FileConfiguration fc) {
        this(null, null, fc);
    }

    public MythicConfigImpl(String name, FileConfiguration fc) {
        this(name, null, fc);
    }

    public MythicConfigImpl(MythicConfig config, String name) {
        this(name, config.getFile(), config.getFileConfiguration());
    }

    public MythicConfigImpl(File file) {
        this("", file);
    }

    public MythicConfigImpl(String name, File file) {
        this(name, file, null);
        this.fc = new YamlConfiguration();
        try {
            this.fc.load(file);
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
        if (!this.fc.isConfigurationSection(this.configName)) {
            this.fc.createSection(this.configName);
        }
    }

    public MythicConfigImpl(String name, File file, FileConfiguration fc) {
        this.configName = name;
        this.file = file;
        this.fc = fc;
    }

    @Override
    public void setKey(String key) {
        this.configName = key;
    }

    @Override
    public String getKey() {
        return this.configName;
    }

    @Override
    public String getFileName() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        if (this.configName != null) {
            return "Nested Configuration '" + this.configName + "'";
        }
        return "API";
    }

    @Override
    public FileConfiguration getFileConfiguration() {
        return this.fc;
    }

    public String getNode(String field) {
        if (this.configName == null || this.configName.length() == 0) {
            return "";
        }
        if (field == null || field.isEmpty()) {
            return this.configName;
        }
        return this.configName + ".";
    }

    @Override
    public void deleteNodeAndSave() {
        this.fc.set(this.getNode(null), null);
        this.save();
    }

    @Override
    public boolean isSet(String key) {
        return this.fc.isSet(this.getNode(key) + key);
    }

    @Override
    public String determineWhichKeyToUse(String def, String ... keys) {
        for (String key : keys) {
            if (!this.isSet(key)) continue;
            return key;
        }
        return def;
    }

    @Override
    public void set(String key, Object value) {
        this.fc.set(this.getNode(key) + key, value);
    }

    @Override
    public void setSave(String field, Object value) {
        this.fc.set(this.getNode(field) + field, value);
        this.save();
    }

    @Override
    public void unset(String field) {
        this.fc.set(this.getNode(field) + field, null);
    }

    @Override
    public void unsetSave(String key) {
        this.unset(key);
        this.save();
    }

    @Override
    public void load() {
        this.fc = YamlConfiguration.loadConfiguration((File)this.file);
    }

    @Override
    public void save() {
        if (this.file == null) {
            MythicLogger.errorGenericConfig("Save operation not supported on null file: " + this.getFileName());
            return;
        }
        try {
            this.fc.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MythicConfig getNestedConfig(String key) {
        return new MythicConfigImpl(this.getNode(key) + key, this.file, this.fc);
    }

    @Override
    public Map<String, MythicConfig> getNestedConfigs(String field) {
        HashMap<String, MythicConfig> map = new HashMap<String, MythicConfig>();
        if (!this.isSet(field)) {
            return map;
        }
        for (String k : this.getKeys(field)) {
            map.put(k, new MythicConfigImpl(this.getNode(field) + field + "." + k, this.fc));
        }
        return map;
    }

    @Override
    public String getString(String field) {
        String key = this.getNode(field) + field;
        return this.fc.getString(key, this.fc.getString(key.toLowerCase()));
    }

    @Override
    public String getString(String[] key) {
        return this.getString(key, null, new String[0]);
    }

    @Override
    public String getString(String field, String def) {
        String key = this.getNode(field) + field;
        return this.fc.getString(key, this.fc.getString(key.toLowerCase(), def));
    }

    @Override
    public String getString(String[] keysToCheck, String finalDefaultValue, String ... defaultValues) {
        for (String key : keysToCheck) {
            String get;
            if (this.isConfigurationSection(key) || (get = this.getString(key, null)) == null) continue;
            return get;
        }
        for (String value : defaultValues) {
            if (value == null) continue;
            return value;
        }
        return finalDefaultValue;
    }

    @Override
    public String getNamespacedString(String field) {
        String key = this.getNode(field) + field;
        return this.wrapWithNamespace(this.fc.getString(key, this.fc.getString(key.toLowerCase())));
    }

    @Override
    public String getNamespacedString(String[] key) {
        return this.getString(key, null, new String[0]);
    }

    @Override
    public String getNamespacedString(String field, String def) {
        String key = this.getNode(field) + field;
        return this.wrapWithNamespace(this.fc.getString(key, this.fc.getString(key.toLowerCase(), def)));
    }

    @Override
    public String getNamespacedString(String[] keysToCheck, String finalDefaultValue, String ... defaultValues) {
        for (String key : keysToCheck) {
            String get;
            if (this.isConfigurationSection(key) || (get = this.getString(key, null)) == null) continue;
            return this.wrapWithNamespace(get);
        }
        for (String value : defaultValues) {
            if (value == null) continue;
            return this.wrapWithNamespace(value);
        }
        return this.wrapWithNamespace(finalDefaultValue);
    }

    private String wrapWithNamespace(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains(":")) {
            return "minecraft:" + string.toLowerCase();
        }
        return string.toLowerCase();
    }

    @Override
    public Chroma getColor(String field) {
        return this.getColor(field, Chroma.of(255, 255, 255));
    }

    @Override
    public Chroma getColor(String field, Chroma def) {
        String data = this.getString(field, null);
        if (data == null) {
            return def;
        }
        return Chroma.of(data);
    }

    @Override
    public PlaceholderString getPlaceholderString(String field) {
        String key = this.getNode(field) + field;
        String s2 = this.fc.getString(key);
        if (s2 == null) {
            return null;
        }
        return PlaceholderString.of(s2);
    }

    @Override
    public PlaceholderString getPlaceholderString(String field, String def) {
        String key = this.getNode(field) + field;
        String s2 = this.fc.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderString.of(s2);
    }

    @Override
    public PlaceholderString getPlaceholderString(String[] field) {
        String value = this.getString(field, null, new String[0]);
        if (value == null) {
            return null;
        }
        return PlaceholderString.of(value);
    }

    @Override
    public PlaceholderString getPlaceholderString(String[] field, String def) {
        String value = this.getString(field, def, new String[0]);
        if (value == null) {
            return null;
        }
        return PlaceholderString.of(value);
    }

    @Override
    public String getColorString(String field) {
        String key = this.getNode(field) + field;
        String s2 = this.fc.getString(key);
        if (s2 != null) {
            s2 = Text.colorizeLegacy(s2);
        }
        return s2;
    }

    @Override
    public String getColorString(String field, String def) {
        String key = this.getNode(field) + field;
        String s2 = this.fc.getString(key, def);
        if (s2 != null) {
            s2 = Text.colorizeLegacy(s2);
        }
        return s2;
    }

    @Override
    public boolean getBoolean(String field) {
        String key = this.getNode(field) + field;
        return this.fc.getBoolean(this.getNode(field) + field);
    }

    @Override
    public boolean getBoolean(String field, boolean def) {
        return this.fc.getBoolean(this.getNode(field) + field, def);
    }

    public Boolean getBooleanNullable(String field) {
        if (this.fc.isSet(this.getNode(field) + field)) {
            return this.fc.getBoolean(this.getNode(field) + field);
        }
        return null;
    }

    public Boolean getBooleanNullable(String[] field) {
        for (String key : field) {
            if (!this.fc.isSet(this.getNode(key) + key)) continue;
            return this.fc.getBoolean(this.getNode(key) + key);
        }
        return null;
    }

    @Override
    public PlaceholderBoolean getPlaceholderBoolean(String field) {
        if (this.fc.isSet(this.getNode(field) + field)) {
            return PlaceholderBooleanImpl.of(this.fc.getString(this.getNode(field) + field));
        }
        return null;
    }

    @Override
    public PlaceholderBoolean getPlaceholderBoolean(String[] field) {
        for (String key : field) {
            if (!this.fc.isSet(this.getNode(key) + key)) continue;
            return PlaceholderBooleanImpl.of(this.fc.getString(this.getNode(key) + key));
        }
        return null;
    }

    @Override
    public PlaceholderBoolean getPlaceholderBoolean(String field, Boolean def) {
        if (this.fc.isSet(this.getNode(field) + field)) {
            return PlaceholderBooleanImpl.of(this.fc.getString(this.getNode(field) + field));
        }
        return def == null ? null : PlaceholderBoolean.of(def.toString());
    }

    @Override
    public PlaceholderBoolean getPlaceholderBoolean(String[] field, Boolean def) {
        for (String key : field) {
            if (!this.fc.isSet(this.getNode(key) + key)) continue;
            return PlaceholderBooleanImpl.of(this.fc.getString(this.getNode(key) + key));
        }
        return def == null ? null : PlaceholderBoolean.of(def.toString());
    }

    @Override
    public int getInteger(String field) {
        String key = this.getNode(field) + field;
        return this.fc.getInt(key, this.fc.getInt(key.toLowerCase()));
    }

    @Override
    public int getInteger(String field, int def) {
        String key = this.getNode(field) + field;
        return this.fc.getInt(key, this.fc.getInt(key.toLowerCase(), def));
    }

    @Override
    public int getInteger(String[] keys, int def) {
        for (String string : keys) {
            String string2 = this.getNode(string) + string;
            if (!this.fc.isInt(string2)) continue;
            return this.fc.getInt(string2);
        }
        return def;
    }

    @Override
    @Deprecated
    public int getInt(String field) {
        String key = this.getNode(field) + field;
        return this.fc.getInt(this.getNode(field) + field);
    }

    @Override
    @Deprecated
    public int getInt(String field, int def) {
        String key = this.getNode(field) + field;
        return this.fc.getInt(this.getNode(field) + field, def);
    }

    @Override
    public float getFloat(String field) {
        return (float)this.getDouble(field);
    }

    @Override
    public float getFloat(String field, float def) {
        return (float)this.getDouble(field, def);
    }

    @Override
    public Percent getPercent(String field) {
        String percent = this.getString(field);
        if (percent == null) {
            return Percent.of(1.0);
        }
        return Percent.of(percent);
    }

    @Override
    public Percent getPercent(String field, Percent def) {
        String percent = this.getString(field);
        if (percent == null) {
            return def;
        }
        return Percent.of(percent);
    }

    @Override
    public double getDouble(String field) {
        String key = this.getNode(field) + field;
        return this.fc.getDouble(this.getNode(field) + field);
    }

    @Override
    public double getDouble(String field, double def) {
        String key = this.getNode(field) + field;
        return this.fc.getDouble(this.getNode(field) + field, def);
    }

    @Override
    public List<String> getStringList(String field) {
        String key = this.getNode(field) + field;
        return this.fc.getStringList(this.getNode(field) + field);
    }

    @Override
    public List<String> getStringList(String field, List<String> def) {
        String key = this.getNode(field) + field;
        if (this.fc.isSet(this.getNode(field) + field)) {
            return this.fc.getStringList(this.getNode(field) + field);
        }
        return def;
    }

    @Override
    public List<String> getColorStringList(String field) {
        String key = this.getNode(field) + field;
        List list = this.fc.getStringList(this.getNode(field) + field);
        ArrayList<String> parsed = new ArrayList<String>();
        if (list != null) {
            for (String str : list) {
                parsed.add(ChatColor.translateAlternateColorCodes((char)'&', (String)str));
            }
        }
        return parsed;
    }

    @Override
    public List<PlaceholderString> getPlaceholderStringList(String field) {
        String key = this.getNode(field) + field;
        List list = this.fc.getStringList(this.getNode(field) + field);
        ArrayList<PlaceholderString> parsed = new ArrayList<PlaceholderString>();
        if (list != null) {
            for (String str : list) {
                parsed.add(PlaceholderString.of(str));
            }
        }
        return parsed;
    }

    @Override
    public List<PlaceholderString> getPlaceholderStringList(String field, List<String> def) {
        String key = this.getNode(field) + field;
        List<String> list = this.getStringList(field, def);
        ArrayList<PlaceholderString> parsed = new ArrayList<PlaceholderString>();
        if (list != null) {
            for (String str : list) {
                parsed.add(PlaceholderString.of(str));
            }
        }
        return parsed;
    }

    @Override
    public List<PlaceholderString> getPlaceholderStringListAlt(String field, List<PlaceholderString> def) {
        String key = this.getNode(field) + field;
        List<String> list = this.getStringList(field);
        if (list == null || list.isEmpty()) {
            return def;
        }
        ArrayList<PlaceholderString> parsed = new ArrayList<PlaceholderString>();
        if (list != null) {
            for (String str : list) {
                parsed.add(PlaceholderString.of(str));
            }
        }
        return parsed;
    }

    @Override
    public List<Map<?, ?>> getMapList(String field) {
        String key = this.getNode(field) + field;
        return this.fc.getMapList(this.getNode(field) + field);
    }

    @Override
    public List<?> getList(String field) {
        String key = this.getNode(field) + field;
        if (this.fc.isSet(key)) {
            return this.fc.getList(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getList(key.toLowerCase());
        }
        return null;
    }

    @Override
    public List<Byte> getByteList(String field) {
        String key = this.getNode(field) + field;
        if (this.fc.isSet(key)) {
            return this.fc.getByteList(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getByteList(key.toLowerCase());
        }
        return null;
    }

    @Override
    public ItemStack getItemStack(String field, String def) {
        String key = this.getNode(field) + field;
        if (this.fc.isSet(key)) {
            return this.fc.getItemStack(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getItemStack(key.toLowerCase());
        }
        try {
            return new ItemStack(Material.valueOf((String)def));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public boolean isConfigurationSection(String field) {
        String key = this.getNode(field) + field;
        return this.fc.isConfigurationSection(key);
    }

    @Override
    public Set<String> getKeys() {
        return this.fc.getConfigurationSection(this.configName).getKeys(false);
    }

    @Override
    public Set<String> getKeys(String field) {
        String key = this.getNode(field) + field;
        return this.fc.getConfigurationSection(key).getKeys(false);
    }

    @Override
    public boolean isList(String field) {
        String key = this.getNode(field) + field;
        return this.fc.isList(key);
    }

    @Override
    public PlaceholderInt getPlaceholderInt(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInt(String[] key, String def) {
        String s2 = this.getString(key, def, new String[0]);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInt(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderDouble.of(s2);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderDouble.of(s2);
    }

    @Override
    public PlaceholderColorImpl getPlaceholderColor(String key, String def) {
        PlaceholderString s2 = this.getPlaceholderString(key, def);
        if (s2 == null) {
            return null;
        }
        return new PlaceholderColorImpl(s2);
    }

    @Override
    public <T extends Enum> T getEnum(String field, Class<T> clazz, T def) {
        try {
            String in = this.getString(field);
            if (in == null) {
                return def;
            }
            T value = Enum.valueOf(clazz, in.toUpperCase());
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (Error | Exception ex) {
            return def;
        }
    }

    @Override
    public void merge(MythicConfig tmplConfig, List<String> keysToIgnore) {
        FileConfiguration thisFile = this.fc;
        FileConfiguration tmplFile = tmplConfig.getFileConfiguration();
        String thisMob = this.configName;
        String tmplMob = tmplConfig.getKey();
        for (String key : tmplConfig.getKeys("")) {
            Object section;
            if (keysToIgnore.contains(key)) continue;
            if (!this.getStringList(key).isEmpty()) {
                List<String> templateStringList = tmplConfig.getStringList(key);
                List<String> currentStringList = this.getStringList(key);
                templateStringList.addAll(currentStringList);
                this.set(key, templateStringList);
                continue;
            }
            if (!this.isSet(key)) {
                if (tmplConfig.isConfigurationSection(key)) {
                    section = tmplFile.getConfigurationSection(tmplMob + "." + key);
                    for (String sectionKey : section.getKeys(false)) {
                        this.set(key + "." + sectionKey, section.get(sectionKey));
                    }
                    continue;
                }
                this.set(key, tmplFile.get(tmplMob + "." + key));
                continue;
            }
            section = thisFile.get(thisMob + "." + key);
            if (!(section instanceof MemorySection)) continue;
            MemorySection thisMemory = (MemorySection)section;
            MemorySection templateMemory = (MemorySection)tmplFile.get(tmplMob + "." + key);
            for (String node : templateMemory.getKeys(false)) {
                if (thisMemory.isSet(node)) continue;
                Object nodeValue = templateMemory.get(node);
                thisMemory.set(node, nodeValue);
            }
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

