/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.mobs;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.EditableMenuBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.menus.MenuManager;
import io.lumine.mythic.core.menus.MythicMenu;
import io.lumine.mythic.core.menus.mobs.MobBrowseMode;
import io.lumine.mythic.core.menus.mobs.MobMenuContext;
import io.lumine.mythic.core.mobs.MobType;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MobBrowseMenu
extends MythicMenu<MobMenuContext> {
    public MobBrowseMenu(MythicBukkit plugin, MenuManager manager) {
        super(plugin, manager, "/menus/mob-browser.yml");
    }

    public void open(Player player) {
        this.open(player, new MobMenuContext());
    }

    @Override
    public void open(Player player, MobMenuContext context) {
        if (context.getMode() == MobBrowseMode.PACKS && context.getPackFilter() == null) {
            ArrayList data = Lists.newArrayList();
            for (Pack pack : this.getPlugin().getPackManager().getPacks()) {
                data.add(() -> pack.createMenuIcon((pContext, pPlayer) -> {
                    pContext.setPackFilter(pack);
                    this.open((Player)pPlayer, (MobMenuContext)pContext);
                }));
            }
            this.getPlugin().getMenuManager().getMobBrowseMenu().open(player, context, data);
        } else {
            ArrayList mobs = Lists.newArrayList();
            this.getPlugin().getMobManager().getMobTypes().forEach(mob -> mobs.add((MobType)mob));
            if (context.hasPackFilter()) {
                mobs.removeIf(mm4 -> mm4.getPack() == null || mm4.getPack() != context.getPackFilter());
            }
            if (context.hasFilter()) {
                this.getPlugin().getMobManager().filterMobs(mobs, context.getFilter());
            }
            Collections.sort(mobs, (i1, i2) -> i1.getInternalName().compareToIgnoreCase(i2.getInternalName()));
            this.getPlugin().getMenuManager().getMobBrowseMenu().open(player, context, mobs);
        }
    }

    @Override
    public EditableMenuBuilder<MobMenuContext> build(EditableMenuBuilder<MobMenuContext> builder) {
        builder = this.addPageButtons(builder);
        builder.getIcon("BACK_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            if (context.getMode() == MobBrowseMode.PACKS && context.hasPackFilter()) {
                context.clearPackFilter();
                this.open((Player)player, (MobMenuContext)context);
            } else {
                this.getMenuManager().getMainMenu().open((Player)player, player);
            }
        }));
        builder.getIcon("VIEW_BUTTON").ifPresent(icon -> icon.getBuilder().lore(context -> Lists.newArrayList((Object[])new String[]{"<gold>Current View<white>: <yellow>" + String.valueOf((Object)context.getMode())})).click((context, player) -> {
            context.clearPackFilter();
            context.setMode(context.getMode().next());
            this.open((Player)player, (MobMenuContext)context);
        }));
        builder.getIcon("FILTER_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            player.closeInventory();
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the text you'd like to search for:", "<gray>Type cancel to abort filtering.");
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                context.setFilter(input);
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> this.open((Player)player, (MobMenuContext)context));
        }));
        builder.getIcon("FILTER_RESET_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            context.clearFilter();
            this.open((Player)player, (MobMenuContext)context);
        }));
        return builder;
    }
}

