/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.ai.goals;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.utils.serialize.Locus;
import io.lumine.mythic.core.mobs.ai.Pathfinder;
import io.lumine.mythic.core.mobs.ai.PathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@MythicAIGoal(name="patrolRoute", aliases={"patrol"}, version="4.6", description="Patrol along a set path of points")
public class PatrolGoal
extends Pathfinder
implements PathfindingGoal {
    private int currentDestination = -1;
    private List<AbstractLocation> points = new ArrayList<AbstractLocation>();
    private float speed;
    private double tolerance;

    public PatrolGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.goalType = Pathfinder.GoalType.MOVE_LOOK;
        try {
            ArrayList<Locus> defpoints = new ArrayList<Locus>();
            if (this.dataVar1 != null) {
                String[] split2 = this.dataVar1.split(";");
                for (String s2 : split2) {
                    try {
                        String[] split3 = s2.split(",");
                        double x = Double.valueOf(split3[0]);
                        double y = Double.valueOf(split3[1]);
                        double z = Double.valueOf(split3[2]);
                        defpoints.add(Locus.of(x, y, z));
                    }
                    catch (Error | Exception ex) {
                        // empty catch block
                    }
                }
            }
            for (Locus locus : mlc.getLocationList(new String[]{"points", "p"}, defpoints)) {
                this.points.add(new AbstractLocation(entity.getWorld(), locus.getX(), locus.getY(), locus.getZ()));
            }
            float defSpeed = 1.0f;
            try {
                defSpeed = Float.valueOf(this.dataVar2).floatValue();
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
            this.speed = mlc.getFloat(new String[]{"speed", "s"}, defSpeed);
            this.tolerance = mlc.getDouble(new String[]{"tolerance", "t"}, 3.0);
            this.currentDestination = this.getNearestLocation();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getNearestLocation() {
        AbstractLocation entityLocation = this.entity.getLocation();
        AbstractLocation closest = this.points.stream().min(Comparator.comparing(l -> l.distanceSquared(entityLocation))).orElse(null);
        if (closest == null) {
            return -1;
        }
        return this.points.indexOf(closest);
    }

    @Override
    public boolean shouldStart() {
        if (this.points.size() < 2) {
            return false;
        }
        AbstractLocation currentTarget = this.points.get(this.currentDestination);
        if (this.entity.getLocation().distanceSquared(currentTarget) <= this.tolerance) {
            if (++this.currentDestination == this.points.size()) {
                this.currentDestination = 0;
            }
            currentTarget = this.points.get(this.currentDestination);
        }
        PatrolGoal.ai().navigateToLocation(this.entity, currentTarget, this.speed);
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean shouldEnd() {
        return true;
    }

    @Override
    public void end() {
    }
}

