/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.tracker;

import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.core.mobs.tracker.DamageRecordManager;
import io.lumine.mythic.core.mobs.tracker.DamageSnapshot;
import io.lumine.mythic.core.mobs.tracker.DamageSnapshotBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DamageRecord {
    private final DamageRecordManager manager;
    private final UUID linkedEntity;
    private double totalDamageDone = 0.0;
    private final Map<UUID, DamageSnapshotBundle> damagingPlayers = new HashMap<UUID, DamageSnapshotBundle>();

    public DamageRecord(DamageRecordManager manager, UUID uuid) {
        this.manager = manager;
        this.linkedEntity = uuid;
    }

    public Collection<UUID> getDamagers() {
        return this.damagingPlayers.keySet();
    }

    public void registerSnapshot(DamageSnapshot snapshot) {
        UUID damager = snapshot.getDamagingEntity();
        if (this.damagingPlayers.containsKey(damager)) {
            this.damagingPlayers.get(damager).addSnapshot(snapshot);
        } else {
            DamageSnapshotBundle bundle = new DamageSnapshotBundle(damager);
            bundle.addSnapshot(snapshot);
            this.damagingPlayers.put(damager, bundle);
        }
        this.totalDamageDone += snapshot.getDamageAmount();
    }

    public UUID getTopDamager() {
        UUID topDamager = null;
        double highestDamage = 0.0;
        for (Map.Entry<UUID, DamageSnapshotBundle> entry : this.damagingPlayers.entrySet()) {
            double totalDamage = entry.getValue().getTotalDamage();
            if (!(totalDamage > highestDamage)) continue;
            highestDamage = totalDamage;
            topDamager = entry.getKey();
        }
        return topDamager;
    }

    public UUID getDamagerInPlace(int position) {
        ArrayList<Map.Entry<UUID, DamageSnapshotBundle>> sortedEntries = new ArrayList<Map.Entry<UUID, DamageSnapshotBundle>>(this.damagingPlayers.entrySet());
        sortedEntries.sort((entry1, entry2) -> Double.compare(((DamageSnapshotBundle)entry2.getValue()).getTotalDamage(), ((DamageSnapshotBundle)entry1.getValue()).getTotalDamage()));
        int zeroBasedIndex = position - 1;
        if (zeroBasedIndex >= 0 && zeroBasedIndex < sortedEntries.size()) {
            return (UUID)((Map.Entry)sortedEntries.get(zeroBasedIndex)).getKey();
        }
        return null;
    }

    public double getDamageInPlace(int position) {
        ArrayList<Map.Entry<UUID, DamageSnapshotBundle>> sortedEntries = new ArrayList<Map.Entry<UUID, DamageSnapshotBundle>>(this.damagingPlayers.entrySet());
        sortedEntries.sort((entry1, entry2) -> Double.compare(((DamageSnapshotBundle)entry2.getValue()).getTotalDamage(), ((DamageSnapshotBundle)entry1.getValue()).getTotalDamage()));
        int zeroBasedIndex = position - 1;
        if (zeroBasedIndex >= 0 && zeroBasedIndex < sortedEntries.size()) {
            return ((DamageSnapshotBundle)((Map.Entry)sortedEntries.get(zeroBasedIndex)).getValue()).getTotalDamage();
        }
        return 0.0;
    }

    public int getPlace(UUID entity) {
        ArrayList<Map.Entry<UUID, DamageSnapshotBundle>> sortedEntries = new ArrayList<Map.Entry<UUID, DamageSnapshotBundle>>(this.damagingPlayers.entrySet());
        sortedEntries.sort((entry1, entry2) -> Double.compare(((DamageSnapshotBundle)entry2.getValue()).getTotalDamage(), ((DamageSnapshotBundle)entry1.getValue()).getTotalDamage()));
        for (int i = 0; i < sortedEntries.size(); ++i) {
            if (!((UUID)((Map.Entry)sortedEntries.get(i)).getKey()).equals(entity)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean didEnoughDamage(UUID entity, double minAmount) {
        DamageSnapshotBundle bundle = this.damagingPlayers.get(entity);
        return bundle != null && bundle.getTotalDamage() >= minAmount;
    }

    public double getDamageDonePercent(AbstractPlayer player) {
        DamageSnapshotBundle bundle = this.damagingPlayers.get(player.getUniqueId());
        if (bundle == null) {
            return 0.0;
        }
        return bundle.getTotalDamage() / this.totalDamageDone;
    }

    public String toString() {
        return "DamageRecord{linkedEntity=" + String.valueOf(this.linkedEntity) + ", damagingPlayers=" + String.valueOf(this.damagingPlayers) + "}";
    }

    public Map<UUID, DamageSnapshotBundle> getDamagingPlayers() {
        return this.damagingPlayers;
    }
}

