/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class SkillMetadataImpl
implements SkillMetadata,
Cloneable {
    private final SkillTrigger cause;
    private IParentSkill caller = null;
    private SkillTriggerMetadata triggerMetadata;
    private SkillCaster caster;
    private AbstractItemStack casterItem;
    private AbstractEntity trigger;
    private AbstractLocation origin;
    private Collection<AbstractEntity> eTargets;
    private Collection<AbstractLocation> lTargets;
    private boolean consoleTarget;
    private Map<String, Object> metadata = Maps.newHashMap();
    private Map<String, String> parameters = Maps.newHashMap();
    private VariableRegistry variables = new VariableRegistry();
    private float power = 1.0f;
    private boolean executeAfterDeath;
    private boolean async = true;
    private AtomicBoolean isTerminated = new AtomicBoolean(false);

    public SkillMetadataImpl(SkillTrigger cause, SkillCaster am, AbstractEntity trigger) {
        this.cause = cause;
        this.caster = am;
        this.casterItem = am.getEntity().getItemMainHand().map(AbstractItemStack::copy).orElse(null);
        this.trigger = trigger;
        this.executeAfterDeath = cause == SkillTriggers.DEATH || cause == SkillTriggers.DESPAWNED;
    }

    public SkillMetadataImpl(SkillTrigger cause, SkillCaster am, AbstractEntity trigger, AbstractLocation origin, Collection<AbstractEntity> feTargets, Collection<AbstractLocation> flTargets, float power) {
        this.cause = cause;
        this.caster = am;
        this.casterItem = am.getEntity().getItemMainHand().map(AbstractItemStack::copy).orElse(null);
        this.trigger = trigger;
        this.origin = origin;
        this.eTargets = feTargets;
        this.lTargets = flTargets;
        this.power = power;
        this.executeAfterDeath = cause == SkillTriggers.DEATH || cause == SkillTriggers.DESPAWNED;
    }

    public SkillMetadataImpl(SkillMetadataImpl source) {
        this.cause = source.getCause();
        this.caster = source.getCaster();
        this.casterItem = source.getCasterItem();
        this.trigger = source.getTrigger();
        this.origin = source.getOrigin();
        this.eTargets = source.getEntityTargets();
        this.lTargets = source.getLocationTargets();
        this.power = source.getPower();
        this.executeAfterDeath = source.getExecuteAfterDeath();
    }

    @Override
    public SkillMetadataImpl setOrigin(AbstractLocation o) {
        this.origin = o;
        return this;
    }

    @Override
    public boolean getIsAsync() {
        return this.async;
    }

    @Override
    public SkillMetadataImpl setIsAsync(boolean b) {
        this.async = b;
        return this;
    }

    @Override
    public IParentSkill getCallingEvent() {
        return this.caller;
    }

    @Override
    public void setCallingEvent(IParentSkill caller) {
        this.caller = caller;
    }

    @Override
    public void cancelEvent() {
        if (this.caller != null) {
            this.caller.setCancelled();
        }
    }

    @Override
    public Collection<AbstractEntity> getEntityTargets() {
        return this.eTargets;
    }

    @Override
    public SkillMetadataImpl setEntityTargets(Collection<AbstractEntity> targets) {
        if (this.lTargets != null) {
            this.lTargets = new HashSet<AbstractLocation>();
        }
        this.eTargets = targets;
        return this;
    }

    @Override
    public SkillMetadataImpl setEntityTarget(AbstractEntity target) {
        if (this.lTargets != null) {
            this.lTargets = new HashSet<AbstractLocation>();
        }
        this.eTargets = new HashSet<AbstractEntity>();
        this.eTargets.add(target);
        return this;
    }

    @Override
    public Collection<AbstractLocation> getLocationTargets() {
        return this.lTargets;
    }

    @Override
    public SkillMetadataImpl setLocationTargets(Collection<AbstractLocation> targets) {
        if (this.eTargets != null) {
            this.eTargets = new HashSet<AbstractEntity>();
        }
        this.lTargets = targets;
        return this;
    }

    @Override
    public SkillMetadataImpl setLocationTarget(AbstractLocation target) {
        if (this.eTargets != null) {
            this.eTargets = new HashSet<AbstractEntity>();
        }
        this.lTargets = new HashSet<AbstractLocation>();
        this.lTargets.add(target);
        return this;
    }

    @Override
    public boolean hasTarget() {
        return this.isConsoleTarget() || this.eTargets != null && !this.eTargets.isEmpty() || this.lTargets != null && !this.lTargets.isEmpty();
    }

    @Override
    public SkillMetadataImpl setMetadata(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    @Override
    public Optional<Object> getMetadata(String key) {
        return Optional.ofNullable(this.metadata.getOrDefault(key, null));
    }

    public SkillMetadataImpl clone() throws CloneNotSupportedException {
        return (SkillMetadataImpl)super.clone();
    }

    @Override
    public SkillMetadataImpl deepClone() {
        return this.deepClone(true);
    }

    @Override
    public SkillMetadataImpl deeperClone() {
        return this.deeperClone(true);
    }

    @Override
    public SkillMetadataImpl deepClone(boolean terminatable) {
        try {
            SkillMetadataImpl clone = this.clone();
            clone.setParameters(Maps.newHashMap(this.parameters));
            clone.setCallingEvent(this.getCallingEvent());
            if (this.getEntityTargets() != null && !this.getEntityTargets().isEmpty()) {
                clone.setEntityTargets(new HashSet<AbstractEntity>(this.getEntityTargets()));
            }
            if (this.getLocationTargets() != null && !this.getLocationTargets().isEmpty()) {
                clone.setLocationTargets(new HashSet<AbstractLocation>(this.getLocationTargets()));
            }
            if (terminatable) {
                clone.setTerminatedReference(this.isTerminated);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public SkillMetadataImpl deeperClone(boolean terminatable) {
        try {
            SkillMetadataImpl clone = this.clone();
            clone.setMetadata(Maps.newHashMap(this.metadata));
            clone.setParameters(Maps.newHashMap(this.parameters));
            clone.setVariables(this.variables.clone());
            clone.setCallingEvent(this.getCallingEvent());
            if (this.getEntityTargets() != null && !this.getEntityTargets().isEmpty()) {
                clone.setEntityTargets(new HashSet<AbstractEntity>(this.getEntityTargets()));
            }
            if (this.getLocationTargets() != null && !this.getLocationTargets().isEmpty()) {
                clone.setLocationTargets(new HashSet<AbstractLocation>(this.getLocationTargets()));
            }
            if (terminatable) {
                clone.setTerminatedReference(this.isTerminated);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setCaster(SkillCaster caster) {
        this.caster = caster;
        if (this.casterItem == null) {
            this.casterItem = caster.getEntity().getItemMainHand().orElse(null);
        }
    }

    @Override
    public void setTrigger(AbstractEntity entity) {
        this.trigger = entity;
    }

    @Override
    public void setTerminatedReference(AtomicBoolean atomicBoolean) {
        this.isTerminated = atomicBoolean;
    }

    @Override
    public void terminate() {
        this.isTerminated.set(true);
    }

    @Override
    public boolean isTerminated() {
        return this.isTerminated.get();
    }

    @Override
    public boolean getExecuteAfterDeath() {
        return this.executeAfterDeath;
    }

    @Override
    public void setExecuteAfterDeath(boolean bool) {
        this.executeAfterDeath = bool;
    }

    @Override
    public SkillTrigger getCause() {
        return this.cause;
    }

    @Override
    public SkillTriggerMetadata getTriggerMetadata() {
        return this.triggerMetadata;
    }

    public void setTriggerMetadata(SkillTriggerMetadata triggerMetadata) {
        this.triggerMetadata = triggerMetadata;
    }

    @Override
    public SkillCaster getCaster() {
        return this.caster;
    }

    @Override
    public AbstractItemStack getCasterItem() {
        return this.casterItem;
    }

    public void setCasterItem(AbstractItemStack casterItem) {
        this.casterItem = casterItem;
    }

    @Override
    public AbstractEntity getTrigger() {
        return this.trigger;
    }

    @Override
    public AbstractLocation getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isConsoleTarget() {
        return this.consoleTarget;
    }

    @Override
    public void setConsoleTarget(boolean consoleTarget) {
        this.consoleTarget = consoleTarget;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public VariableRegistry getVariables() {
        return this.variables;
    }

    public void setVariables(VariableRegistry variables) {
        this.variables = variables;
    }

    @Override
    public float getPower() {
        return this.power;
    }

    @Override
    public void setPower(float power) {
        this.power = power;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }
}

