/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.EnumSet;
import java.util.HashSet;
import org.bukkit.entity.EntityType;

@MythicCondition(author="Ashijin", name="entityType", aliases={"mobtype"}, description="Tests the entity type of the target")
public class EntityTypeCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="type", aliases={"types", "t"}, description="A list of entity types to match")
    protected EnumSet<EntityType> entityTypes;

    public EntityTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String entityTypesStringList = mlc.getString(new String[]{"types", "type", "t"}, null, this.conditionVar);
        HashSet<EntityType> collection = new HashSet<EntityType>();
        if (entityTypesStringList != null) {
            for (String entityTypeString : entityTypesStringList.split(",")) {
                for (EntityType e : EntityType.values()) {
                    if (!e.toString().matches(Patterns.toRegex(entityTypeString.toUpperCase()))) continue;
                    try {
                        collection.add(e);
                    }
                    catch (Exception exception) {
                        MythicLogger.errorConditionConfig(this, mlc, "Couldn't parse \"" + entityTypeString + "\" as an EntityType!");
                    }
                }
            }
        }
        this.entityTypes = !collection.isEmpty() ? EnumSet.copyOf(collection) : EnumSet.noneOf(EntityType.class);
    }

    @Override
    public boolean check(AbstractEntity targetEntity) {
        return this.entityTypes.contains(targetEntity.getBukkitEntity().getType());
    }
}

