/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

@MythicCondition(author="Ashijin", name="score", aliases={}, description="Checks a scoreboard value of the target entity")
public class ScoreCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="objective", aliases={"o"}, description="The objective")
    private final PlaceholderString obj;
    @MythicField(name="entry", aliases={"e"}, description="The entry")
    private final PlaceholderString ent;
    @MythicField(name="value", aliases={"v"}, description="The value to match")
    private final PlaceholderString val;

    public ScoreCondition(String line, MythicLineConfig mlc) {
        super(line);
        String[] split = this.conditionVar.split(";");
        String val = split.length > 1 ? split[0] : "";
        String condObj = split.length > 2 ? split[1] : "";
        String condEnt = split.length > 3 ? split[2] : "";
        this.obj = mlc.getPlaceholderString(new String[]{"objective", "obj", "o"}, condObj, new String[0]);
        this.ent = mlc.getPlaceholderString(new String[]{"entry", "ent", "e"}, condEnt, new String[0]);
        this.val = mlc.getPlaceholderString(new String[]{"value", "val", "v"}, val, new String[0]);
    }

    @Override
    public boolean check(AbstractEntity target) {
        String entry;
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = scoreboard.getObjective(this.obj.get(target));
        if (objective == null) {
            objective = scoreboard.registerNewObjective(this.obj.get(target), "dummy");
        }
        int score = (entry = this.ent.get(target)).isBlank() ? (target.isPlayer() ? objective.getScore(target.asPlayer().getName()).getScore() : objective.getScore(target.getUniqueId().toString()).getScore()) : objective.getScore(entry).getScore();
        return new RangedDouble(this.val.get(target)).equals(score);
    }
}

