/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

@MythicCondition(author="Ashijin", name="targetInLineOfSight", aliases={}, description="Tests if the target has line of sight to their target")
public class TargetInLineOfSightCondition
extends SkillCondition
implements IEntityCondition {
    public TargetInLineOfSightCondition(String line, MythicLineConfig mlc) {
        super(line);
    }

    @Override
    public boolean check(AbstractEntity entity) {
        Entity entity2 = entity.getBukkitEntity();
        if (!(entity2 instanceof Mob)) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Entity is not a mob", new Object[0]);
            return true;
        }
        Mob mob = (Mob)entity2;
        LivingEntity target = mob.getTarget();
        if (target == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Entity does not have a target", new Object[0]);
            return false;
        }
        boolean bool = mob.hasLineOfSight((Entity)target);
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "{0} LOS to {1} == {2}", entity.getUniqueId(), target.getUniqueId(), bool);
        return bool;
    }
}

