/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="oxygen", version="4.11", description="Gives the target player oxygen")
public class OxygenMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="amount", aliases={"a"}, description="The amount of oxygen to give")
    protected PlaceholderInt amount;

    public OxygenMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || !target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        int currentOxygen = target.asPlayer().getRemainingAir();
        int oxygen = currentOxygen + this.amount.get(data, target);
        if (oxygen >= target.asPlayer().getMaximumAir()) {
            target.asPlayer().setRemainingAir(target.asPlayer().getMaximumAir());
        } else {
            target.asPlayer().setRemainingAir(oxygen);
        }
        return SkillResult.SUCCESS;
    }
}

