/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.io.File;
import java.util.Collection;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicMechanic(author="Ashijin", name="effect:particlelineequation", aliases={"particlelineequation", "particlelineeq"})
public class ParticleLineEquationEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float distanceBetween;
    protected float startYOffset;
    protected float targetYOffset;
    protected boolean fromOrigin;
    protected PlaceholderString equationX;
    protected PlaceholderString equationY;
    protected PlaceholderString equationZ;
    protected double maxDistance;

    public ParticleLineEquationEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo", "ystartoffset", "ys"}, 0.0f);
        this.targetYOffset = mlc.getFloat(new String[]{"targetyoffset", "tyo", "ytargetoffset", "yt"}, 0.0f);
        this.distanceBetween = mlc.getFloat(new String[]{"distancebetween", "db"}, 1.0f);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.equationX = mlc.getPlaceholderString(new String[]{"equationx", "eqx"}, "0", new String[0]);
        this.equationY = mlc.getPlaceholderString(new String[]{"equationy", "eqy"}, "0", new String[0]);
        this.equationZ = mlc.getPlaceholderString(new String[]{"equationz", "eqz"}, "0", new String[0]);
        this.maxDistance = mlc.getDouble(new String[]{"maxdistance", "md"}, 256.0);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        this.playParticleLineEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playParticleLineEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleLineEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        double distance;
        SkillCaster am = data.getCaster();
        AbstractLocation origin = data.getOrigin();
        AbstractLocation targetLocation = target.clone().add(0.0, this.targetYOffset, 0.0);
        AbstractLocation startLocation = this.fromOrigin ? origin.add(0.0, this.startYOffset, 0.0) : (this.useEyeLocation ? am.getEntity().getEyeLocation() : am.getEntity().getLocation().add(0.0, this.startYOffset, 0.0));
        if (this.setYaw) {
            startLocation.setYaw(this.yaw);
        }
        if (this.setPitch) {
            startLocation.setPitch(this.pitch);
        }
        if (this.startForwardOffset != 0.0f) {
            startLocation = MythicUtil.move(this.faulty, startLocation, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset.get(data) != 0.0f) {
            startLocation = MythicUtil.move(this.faulty, startLocation, 0.0, 0.0, this.startSideOffset.get(data));
        }
        if ((distance = startLocation.distance(targetLocation)) > this.maxDistance) {
            distance = this.maxDistance;
        }
        AbstractVector direction = targetLocation.toVector().subtract(startLocation.toVector()).normalize();
        int totalParticles = (int)Math.round(distance / (double)this.distanceBetween);
        double step = distance / (double)totalParticles;
        String equationX = this.equationX.get(data);
        Expression expressionX = new ExpressionBuilder(equationX).operator(Operators.operators).functions(Functions.functions).variables("t", "distance").build().setVariable("distance", distance);
        String equationY = this.equationX.get(data);
        Expression expressionY = new ExpressionBuilder(equationY).operator(Operators.operators).functions(Functions.functions).variables("t", "distance").build().setVariable("distance", distance);
        String equationZ = this.equationX.get(data);
        Expression expressionZ = new ExpressionBuilder(equationZ).operator(Operators.operators).functions(Functions.functions).variables("t", "distance").build().setVariable("distance", distance);
        for (int i = 0; i < totalParticles; ++i) {
            double t2 = step * (double)i / distance;
            expressionX.setVariable("t", t2);
            expressionY.setVariable("t", t2);
            expressionZ.setVariable("t", t2);
            double offsetX = expressionX.evaluate();
            double offsetY = expressionY.evaluate();
            double offsetZ = expressionZ.evaluate();
            AbstractLocation particleLocation = startLocation.clone().add(direction.clone().multiply(step * (double)i)).add(offsetX, offsetY, offsetZ);
            this.playParticleEffect(data, particleLocation, audience);
        }
    }
}

