/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Steerable;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Seyarada", name="saddle", aliases={"giveSaddle", "setSaddle"}, description="Gives a saddle to the target")
public class SaddleMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="take", aliases={"t", "remove", "r"}, description="If it should take the saddle away", defValue="false")
    protected boolean take;

    public SaddleMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.take = mlc.getBoolean(new String[]{"take", "t", "remove", "r"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (entity instanceof Steerable) {
            Steerable steerable = (Steerable)entity;
            steerable.setSaddle(!this.take);
        } else {
            entity = target.getBukkitEntity();
            if (entity instanceof Horse) {
                Horse horse = (Horse)entity;
                if (this.take) {
                    horse.getInventory().setSaddle(new ItemStack(Material.AIR));
                } else {
                    horse.getInventory().setSaddle(new ItemStack(Material.SADDLE));
                }
            }
        }
        return SkillResult.SUCCESS;
    }
}

