/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ash", name="setMaterialCooldown", description="Sets the given material to be on cooldown for the target player")
public class SetMaterialCooldownMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private Material material;
    private PlaceholderInt duration;

    public SetMaterialCooldownMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String strMaterial = mlc.getString(new String[]{"material", "mat", "m"}, "ENDER_PEARL", new String[0]).toUpperCase();
        try {
            this.material = Material.matchMaterial((String)strMaterial);
        }
        catch (Error | Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Material '" + strMaterial + "' not found");
            this.material = Material.ENDER_PEARL;
        }
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, "100", new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        if (!(entity instanceof Player)) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = (Player)entity;
        player.setCooldown(this.material, this.duration.get(data, target));
        return SkillResult.SUCCESS;
    }
}

