/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemMatcher;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemMatcher;
import io.lumine.mythic.bukkit.events.MythicModifiedInventoryEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="stealitem", aliases={"steal", "stealitems", "itemsteal"}, description="Steals an item from the target and puts it in the mob's hand")
public class StealItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private AbstractItemMatcher item;
    private PlaceholderInt amount;
    private PlaceholderFloat dropChance;
    private boolean exact;
    @MythicField(name="onSteal", aliases={"then"}, version="5.8", description="Skill to execute on successfully stealing")
    protected Optional<Skill> onStealSkill = Optional.empty();

    public StealItemMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
        this.dropChance = mlc.getPlaceholderFloat(new String[]{"dropchance", "dc"}, 0.0f, new String[0]);
        this.item = ((MythicBukkit)this.getPlugin()).getBootstrap().getItemMatcher(mlc);
        String onStealSkillName = mlc.getString(new String[]{"onstealskill", "onsteal", "then"});
        this.getManager().queueSecondPass(() -> {
            if (onStealSkillName != null) {
                this.onStealSkill = this.getManager().getSkill(file, this, onStealSkillName);
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = BukkitAdapter.adapt(target.asPlayer());
        Entity casterEntity = data.getCaster().getEntity().getBukkitEntity();
        if (!(casterEntity instanceof LivingEntity)) {
            return SkillResult.INVALID_CONFIG;
        }
        LivingEntity mob = (LivingEntity)casterEntity;
        if (!mob.getEquipment().getItemInMainHand().getType().isAir()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Steal CCCC", new Object[0]);
            return SkillResult.CONDITION_FAILED;
        }
        ItemStack stolenItem = this.stealItem(data, target, (Inventory)player.getInventory(), this.amount.get(data, target));
        if (stolenItem != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Stole item {0}", stolenItem.toString());
            mob.getEquipment().setItemInMainHand(stolenItem);
            mob.getEquipment().setItemInMainHandDropChance(this.dropChance.get(data, target));
            if (this.onStealSkill.isPresent()) {
                SkillMetadata summonData = data.deepClone();
                data.getEntityTargets().clear();
                summonData.setEntityTarget(target);
                summonData.setMetadata("item", stolenItem);
                this.onStealSkill.get().execute(summonData);
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "No stolen it em found", new Object[0]);
        }
        return SkillResult.SUCCESS;
    }

    private ItemStack stealItem(SkillMetadata data, AbstractEntity target, Inventory inventory, int amountToSteal) {
        BukkitItemMatcher matcher = (BukkitItemMatcher)this.item;
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "doing steal", new Object[0]);
        List slots = IntStream.range(0, inventory.getSize()).boxed().collect(Collectors.toList());
        Collections.shuffle(slots);
        Iterator iterator = slots.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ItemStack inventoryItem = inventory.getItem(i);
            if (inventoryItem == null) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Slot {0} is null", i);
                continue;
            }
            if (!matcher.matches(inventoryItem)) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "{0} not match", inventoryItem.toString());
                continue;
            }
            int slotAmount = inventoryItem.getAmount();
            int stolenAmount = Math.min(slotAmount, amountToSteal);
            ItemStack stolenItem = inventoryItem.clone();
            stolenItem.setAmount(stolenAmount);
            int newAmount = slotAmount - stolenAmount;
            if (newAmount <= 0) {
                inventory.setItem(i, null);
            } else {
                inventoryItem.setAmount(newAmount);
            }
            if (target != null && target.isPlayer()) {
                AbstractPlayer player = target.asPlayer();
                player.updateInventory();
                Events.call(new MythicModifiedInventoryEvent(data.getCaster(), BukkitAdapter.adapt(player)));
            }
            return stolenItem;
        }
        return null;
    }
}

