/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@MythicMechanic(author="Seyarada", name="switch", description="Acts as a switch/case")
public class SwitchMechanic
extends SkillMechanic
implements IMetaSkill {
    final Map<String, Skill> caseSkills = new HashMap<String, Skill>();
    boolean uniqueResult;
    PlaceholderString baseCondition;
    Skill defaultSkill;

    public SwitchMechanic(SkillExecutor manager, File file, String mlcLine, MythicLineConfig mlc) {
        super(manager, file, mlcLine, mlc);
        this.uniqueResult = mlc.getBoolean(new String[]{"uniqueresult", "unique", "first"}, true);
        this.baseCondition = mlc.getPlaceholderString("condition", "");
        List<String[]> cases = Arrays.stream(mlc.getString("cases").split("case")).skip(1L).map(s2 -> s2.trim().split("=", 2)).toList();
        this.getManager().queueSecondPass(() -> {
            for (String[] pair : cases) {
                String condition = pair[0];
                String skillString = pair[1];
                Optional<Skill> skill = this.getManager().getSkill(file, this, skillString);
                skill.ifPresent(metaSkill -> {
                    if (metaSkill.isInlineSkill()) {
                        metaSkill.addParent(this);
                    }
                    if (condition.equalsIgnoreCase("default")) {
                        this.defaultSkill = metaSkill;
                    } else {
                        this.caseSkills.put(condition, (Skill)metaSkill);
                    }
                });
            }
        });
    }

    @Override
    public SkillResult cast(SkillMetadata meta) {
        String parsedCondition = this.baseCondition.get(meta);
        boolean hasExecuted = false;
        for (Map.Entry<String, Skill> e : this.caseSkills.entrySet()) {
            String conditionCase = PlaceholderString.of(e.getKey()).get(meta);
            Skill skill = e.getValue();
            String caseCondition = parsedCondition.replace("<case>", conditionCase);
            SkillCondition condition = ((MythicBukkit)this.getPlugin()).getSkillManager().getCondition(caseCondition);
            if (condition instanceof InvalidCondition) continue;
            SkillMetadataImpl data = meta.deeperClone();
            if (condition instanceof ISkillMetaCondition) {
                ISkillMetaCondition metaCondition = (ISkillMetaCondition)((Object)condition);
                if (metaCondition.check(data)) {
                    skill.execute(data);
                    hasExecuted = true;
                }
            } else if (condition.evaluateTargets(data)) {
                skill.execute(data);
                hasExecuted = true;
            }
            if (!hasExecuted || !this.uniqueResult) continue;
            break;
        }
        if (!hasExecuted && this.defaultSkill != null) {
            this.defaultSkill.execute(meta);
        }
        return SkillResult.SUCCESS;
    }
}

