/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="teleport", aliases={"tp"}, description="Teleports to the target location")
public class TeleportMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected PlaceholderDouble spreadH;
    protected PlaceholderDouble spreadV;
    protected boolean preservePitch;
    protected boolean preserveYaw;
    protected boolean unsafe;

    public TeleportMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.spreadH = mlc.getPlaceholderDouble(new String[]{"radius", "r", "spreadh", "sh"}, 0.0, new String[0]);
        this.spreadV = mlc.getPlaceholderDouble(new String[]{"spreadv", "sv"}, 0.0, new String[0]);
        this.preservePitch = mlc.getBoolean(new String[]{"preservepitch", "pp"}, true);
        this.preserveYaw = mlc.getBoolean(new String[]{"preserveyaw", "py"}, true);
        this.unsafe = mlc.getBoolean(new String[]{"unsafe", "us"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        double sH = this.spreadH.get(data);
        double sV = this.spreadV.get(data);
        AbstractLocation teleportLoc = target.clone();
        if (this.preservePitch) {
            teleportLoc.setPitch(data.getCaster().getEntity().getLocation().getPitch());
        }
        if (this.preserveYaw) {
            teleportLoc.setYaw(data.getCaster().getEntity().getLocation().getYaw());
        }
        if (sH > 0.0 || sV > 0.0) {
            SkillCaster skillCaster = data.getCaster();
            if (skillCaster instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)skillCaster;
                teleportLoc = MobExecutor.findSafeSpawnLocation(teleportLoc, sH, sV, am.getType().getMythicEntity().getHeight() + 1, true, !this.unsafe);
            } else {
                teleportLoc = MobExecutor.findSafeSpawnLocation(teleportLoc, sH, sV, 2, true, !this.unsafe);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Teleporting to {0}", teleportLoc.toString());
        data.getCaster().getEntity().teleport(teleportLoc);
        return SkillResult.SUCCESS;
    }
}

