/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.skills.variables.VariableScope;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.io.File;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicMechanic(author="Ashijin", name="variableSet", aliases={"setVariable", "setVar"}, description="Sets a variable on the target entity")
public class VariableSetMechanic
extends VariableMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected PlaceholderString value;
    protected VariableType type;

    public VariableSetMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.value = mlc.getPlaceholderString(new String[]{"value", "val", "v", "amount", "a"}, null, new String[0]);
        String strType = mlc.getString(new String[]{"type", "t"}, VariableType.INTEGER.toString(), new String[0]);
        try {
            this.type = VariableType.valueOf(strType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "'" + strType + "' is not a valid variable type.");
        }
        if (this.value == null) {
            if (this.type == VariableType.FLOAT || this.type == VariableType.INTEGER) {
                this.value = PlaceholderString.of("0");
            } else {
                MythicLogger.errorMechanicConfig(this, mlc, "Variable value must be set.");
            }
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Variable var;
        long expireTime;
        VariableRegistry variables = this.getVariableManager().getRegistry(this.scope, data, target);
        if (variables == null) {
            MythicLogger.errorMechanicConfig(this, this.config, "Failed to get variable registry");
            return SkillResult.INVALID_CONFIG;
        }
        long l = expireTime = this.duration > 1L ? System.currentTimeMillis() + this.duration : this.duration;
        if (this.type == VariableType.INTEGER || this.type == VariableType.FLOAT) {
            String eq = this.value.get((PlaceholderMeta)data, target);
            double amount = new ExpressionBuilder(eq).operator(Operators.operators).functions(Functions.functions).build().evaluate();
            var = Variable.ofType(this.type, (Object)amount, expireTime);
        } else {
            var = Variable.ofType(this.type, (Object)this.value.get((PlaceholderMeta)data, target), expireTime);
        }
        variables.put(this.key.get((PlaceholderMeta)data, target), var);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Variable var;
        long expireTime;
        if (this.scope == VariableScope.TARGET) {
            return SkillResult.INVALID_CONFIG;
        }
        VariableRegistry variables = this.getVariableManager().getRegistry(this.scope, data);
        if (variables == null) {
            MythicLogger.errorMechanicConfig(this, this.config, "Failed to get variable registry");
            return SkillResult.INVALID_CONFIG;
        }
        long l = expireTime = this.duration > 1L ? System.currentTimeMillis() + this.duration : this.duration;
        if (this.type == VariableType.INTEGER || this.type == VariableType.FLOAT) {
            String eq = this.value.get((PlaceholderMeta)data, target);
            double amount = new ExpressionBuilder(eq).operator(Operators.operators).functions(Functions.functions).build().evaluate();
            var = Variable.ofType(this.type, (Object)amount, expireTime);
        } else {
            var = Variable.ofType(this.type, (Object)this.value.get((PlaceholderMeta)data, target), expireTime);
        }
        variables.put(this.key.get((PlaceholderMeta)data, target), var);
        return SkillResult.SUCCESS;
    }
}

