/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IDummySkill;
import io.lumine.mythic.api.skills.IWaitableSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@MythicMechanic(author="Seyarada", name="wait", description="Wait execution to finish before executing the next mechanic")
public class WaitUntilMechanic
extends SkillMechanic
implements IWaitableSkill,
IDummySkill {
    @MythicField(name="conditions", aliases={"cond", "c", "until"}, description="Conditions to check against")
    protected List<SkillCondition> conditions = null;
    protected String conditionsStr;
    @MythicField(name="interval", aliases={"i"}, defValue="1", description="How often to check the conditions")
    protected PlaceholderInt checkInterval;
    @MythicField(name="timeout", aliases={"timeouttime", "tt"}, defValue="200", description="Maximum ticks to wait before executing even if conditions aren't met")
    protected PlaceholderInt timeout;
    @MythicField(name="cancelSkill", aliases={"cancel", "cs"}, defValue="false", description="If the metaskill should be cancelled on timeout instead of executing")
    protected boolean shouldCancelMetaskill;
    @MythicField(name="cancelConditions", aliases={"cc", "unless"}, description="Conditions cancel the wait, if met")
    protected List<SkillCondition> cancelConditions = null;
    protected String cancelConditionsStr;

    public WaitUntilMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.conditionsStr = mlc.getString(new String[]{"conditions", "cond", "c"}, null, new String[0]);
        this.checkInterval = mlc.getPlaceholderInteger(new String[]{"interval", "i"}, 1, new String[0]);
        this.timeout = mlc.getPlaceholderInteger(new String[]{"timeout", "timeouttime", "tt"}, 200, new String[0]);
        this.shouldCancelMetaskill = mlc.getBoolean(new String[]{"cancelSkill", "cancel", "cs"}, false);
        this.cancelConditionsStr = mlc.getString(new String[]{"cancelConditions", "cc", "unless"}, null, new String[0]);
        this.getManager().queueSecondPass(() -> {
            if (this.conditionsStr != null) {
                this.conditions = this.getManager().getConditions(this.conditionsStr);
            }
            if (this.cancelConditionsStr != null) {
                this.cancelConditions = this.getManager().getConditions(this.cancelConditionsStr);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> completableExecution(final SkillMetadata data) {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        final int maxTicks = this.timeout.get(data);
        final int interval = this.checkInterval.get(data);
        new BukkitRunnable(this){
            private int elapsedTicks = 0;
            final /* synthetic */ WaitUntilMechanic this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (maxTicks > 0 && this.elapsedTicks >= maxTicks) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "WaitUntil timed out after {0} ticks", this.elapsedTicks);
                    future.complete(!this.this$0.shouldCancelMetaskill);
                    this.cancel();
                    return;
                }
                if (this.this$0.cancelConditions != null) {
                    for (SkillCondition condition : this.this$0.cancelConditions) {
                        if (!condition.evaluateCaster(data)) continue;
                        future.complete(false);
                        this.cancel();
                        return;
                    }
                }
                boolean allPassed = true;
                if (this.this$0.conditions != null) {
                    for (SkillCondition condition : this.this$0.conditions) {
                        if (condition.evaluateCaster(data)) continue;
                        allPassed = false;
                        break;
                    }
                }
                if (allPassed) {
                    future.complete(true);
                    this.cancel();
                } else {
                    this.elapsedTicks += interval;
                }
            }
        }.runTaskTimer((Plugin)MythicBukkit.inst(), 0L, (long)interval);
        return future;
    }
}

