/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles.bullet;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletableTracker;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class MobBullet
extends ProjectileBullet {
    @MythicField(name="mobType", aliases={"mob", "mm"}, description="The mythicmob to spawn as the bullet type", defValue="SkeletalKnight")
    protected MythicMob bulletMob = null;
    @MythicField(name="bulletSpin", aliases={"bspin"}, description="Makes the bullet spin", defValue="0")
    protected float bulletSpin;
    @MythicField(name="bulletMatchDirection", aliases={"bmd"}, description="Make the bullet face where the projectile is facing", defValue="false")
    protected boolean bulletMatchDirection;
    @MythicField(name="bulletKillable", aliases={"bk"}, description="Allow other entities to damage the projectile bullet", defValue="false")
    protected boolean bulletKillable;

    public MobBullet(ProjectileBulletType type, SkillMechanic projectile, MythicLineConfig config) {
        super(type, projectile, config);
        this.bulletSpin = config.getFloat(new String[]{"bulletspin", "bspin"}, 0.0f);
        this.bulletMatchDirection = config.getBoolean(new String[]{"bulletmatchdirection", "bmd"}, false);
        this.bulletKillable = config.getBoolean(new String[]{"bulletkillable", "bk"}, false);
        this.bulletYOffset = config.getDouble(new String[]{"bulletyoffset", "byoffset", "byo"}, 1.35);
        projectile.getManager().queueSecondPass(() -> {
            String mobType = config.getString(new String[]{"mob", "mobtype", "mm"}, "SkeletalKnight", new String[0]);
            this.bulletMob = this.getPlugin().getMobManager().getMythicMob(mobType).orElseGet(() -> null);
            if (this.bulletMob == null) {
                MythicLogger.errorMechanicConfig(this.getProjectileMechanic(), config, "Invalid bullet mob type specified");
            }
        });
    }

    @Override
    public ProjectileBullet.BulletTracker create(ProjectileBulletableTracker projectile, AbstractEntity target) {
        if (this.bulletMob == null) {
            MythicLogger.errorMechanicConfig(this.getProjectileMechanic(), this.getConfig(), "Invalid bullet mob type specified");
            return null;
        }
        return new MobBulletTracker(projectile, target);
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    public class MobBulletTracker
    extends ProjectileBullet.BulletTracker {
        protected AbstractEntity bullet;

        public MobBulletTracker(ProjectileBulletableTracker projectile, AbstractEntity target) {
            super(MobBullet.this, projectile, target);
            Events.subscribe(PlayerInteractEntityEvent.class).filter(event -> this.bullet != null).filter(event -> event.getRightClicked().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)).bindWith(projectile);
            if (MobBullet.this.bulletKillable) {
                Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> this.bullet != null).filter(event -> event.getEntity().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> projectile.terminate()).bindWith(projectile);
            }
        }

        @Override
        public void spawn(AbstractLocation start) {
            AbstractLocation l = this.getProjectile().getPreviousLocation().clone().subtract(0.0, MobBullet.this.bulletYOffset, 0.0);
            Schedulers.ensureSync(() -> {
                ActiveMob am = MobBullet.this.bulletMob.spawn(l, 1.0, SpawnReason.OTHER, entity -> {
                    entity.setPersistent(false);
                    entity.setTicksLived(Integer.MAX_VALUE);
                    entity.setVelocity(BukkitAdapter.adapt(this.getProjectile().getCurrentVelocity()));
                    if (!MobBullet.this.bulletKillable) {
                        entity.setInvulnerable(true);
                    }
                    if (entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
                        MobBullet.this.getPlugin().getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(BukkitAdapter.adapt(entity));
                        ((ArmorStand)entity).setAI(true);
                        ((ArmorStand)entity).setRemoveWhenFarAway(true);
                    } else {
                        entity.setGravity(false);
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)entity;
                            livingEntity.setRemoveWhenFarAway(true);
                        }
                    }
                });
                if (am == null) {
                    return;
                }
                Entity entity2 = am.getEntity().getBukkitEntity();
                am.setParent(this.getProjectile().getData().getCaster());
                am.setOwner(this.getProjectile().getData().getCaster().getEntity().getUniqueId());
                this.bullet = BukkitAdapter.adapt(entity2);
                Projectile.REAL_BULLET_ENTITIES.add(this.bullet);
                MobBullet.this.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
                if (this.getProjectile().hasTerminated()) {
                    this.bullet.remove();
                }
            });
        }

        @Override
        public void tick(AbstractLocation origin) {
            Projectile projectileMechanic;
            SkillMechanic skillMechanic;
            if (MobBullet.this.bulletKillable && (this.bullet.isDead() || !this.bullet.isValid())) {
                this.getProjectile().terminate();
            }
            double forwardOffset = (skillMechanic = MobBullet.this.getProjectileMechanic()) instanceof Projectile ? ((projectileMechanic = (Projectile)skillMechanic).getTickInterpolation() == 0 ? MobBullet.this.bulletForwardOffset : MobBullet.this.bulletForwardOffset * (double)projectileMechanic.getTickInterpolation()) : MobBullet.this.bulletForwardOffset;
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity().clone().multiply(forwardOffset);
            AbstractLocation ol = this.getProjectile().getPreviousLocation().clone().subtract(0.0, MobBullet.this.bulletYOffset, 0.0).add(currentVelocity);
            if (MobBullet.this.bulletSpin != 0.0f) {
                float newSpin = this.bullet.getLocation().getYaw() + MobBullet.this.bulletSpin;
                ol.setYaw(newSpin);
            }
            Schedulers.ensureSync(() -> {
                if (this.bullet != null) {
                    this.bullet.teleport(ol);
                }
            });
        }

        @Override
        public void despawn() {
            Schedulers.ensureSync(() -> this.bullet.remove());
            Projectile.BULLET_ENTITIES.remove(this.bullet);
        }
    }
}

