/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles.bullet;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.volatilecode.virtual.PacketArmorStand;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplay;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletableTracker;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import org.bukkit.Color;
import org.bukkit.entity.Display;

public class TextDisplayPacketBullet
extends ProjectileBullet {
    @MythicField(name="audience", description="The audience of the message")
    protected SkillAudience audience;
    @MythicField(name="bulletText", aliases={"text"}, description="The text of the bullet", defValue="*")
    protected PlaceholderString bulletText = null;
    @MythicField(name="bulletBillboard", aliases={"billboard"}, description="The billboard mode of the bullet", defValue="CENTER")
    protected Display.Billboard bulletBillboard = Display.Billboard.CENTER;
    @MythicField(name="bulletBrightness", aliases={"bulletBrightnessBlock"}, description="The bullet's brightness")
    protected int bulletBrightnessBlock = -1;
    @MythicField(name="bulletBrightnessSky", description="The bullet's sky light brightness")
    protected int bulletBrightnessSky = -1;
    protected int bulletBrightness = -1;
    @MythicField(name="bulletCullingDistance", aliases={"bulletViewDistance", "bulletViewRange"}, description="The bullet's brightness")
    protected int bulletCullingDistance = 50;
    @MythicField(name="bulletCullingHeight", aliases={"cullHeight"}, description="The bullet's display height")
    protected float bulletCullingHeight = 0.0f;
    @MythicField(name="bulletCullingWidth", aliases={"cullWidth"}, description="The bullet's display width")
    protected float bulletCullingWidth = 0.0f;
    @MythicField(name="bulletScale", description="The bullet's size scale")
    protected PlaceholderString bulletScale;
    @MythicField(name="backgroundColor", aliases={"color"}, description="The background color to use", defValue="1073741824")
    private Color backgroundColor;
    private PacketTextDisplay.PacketTextDisplayBuilder options;

    public TextDisplayPacketBullet(ProjectileBulletType type, SkillMechanic projectile, MythicLineConfig config) {
        super(type, projectile, config);
        this.audience = config.getAudience("audience", "world");
        this.bulletText = config.getPlaceholderString(new String[]{"bulletText", "text"}, "*", new String[0]);
        this.bulletCullingDistance = config.getInteger(new String[]{"bulletCullingDistance", "bulletViewDistance", "bulletViewRange"}, 50);
        this.bulletCullingHeight = config.getFloat(new String[]{"bulletCullingHeight", "cullHeight"}, 0.0f);
        this.bulletCullingWidth = config.getFloat(new String[]{"bulletCullingWidth", "cullWidth"}, 0.0f);
        this.bulletScale = config.getPlaceholderString(new String[]{"bulletscale", "scale"}, "0.5,0.5,0.5", new String[0]);
        AbstractVector bulletScaleStatic = null;
        if (this.bulletScale.isStatic()) {
            try {
                bulletScaleStatic = new AbstractVector(this.bulletScale.get());
            }
            catch (Throwable ex) {
                bulletScaleStatic = new AbstractVector(0.5, 0.5, 0.5);
                MythicLogger.errorMechanic(projectile, "Invalid bullet scale set: " + this.bulletScale.get());
            }
        }
        String strBulletBillboard = config.getString(new String[]{"bulletbillboard", "billboard"}, "CENTER", new String[0]);
        try {
            this.bulletBillboard = Display.Billboard.valueOf((String)strBulletBillboard.toUpperCase());
        }
        catch (Throwable ex) {
            this.bulletBillboard = Display.Billboard.VERTICAL;
            MythicLogger.errorMechanic(projectile, "Invalid bullet billboard mode: " + strBulletBillboard);
        }
        this.bulletBrightnessBlock = config.getInteger(new String[]{"bulletbrightness", "bulletbrightnessblock"}, -1);
        this.bulletBrightnessSky = config.getInteger(new String[]{"bulletbrightnesssky"}, this.bulletBrightnessBlock);
        this.bulletBrightness = this.bulletBrightnessBlock > -1 || this.bulletBrightnessSky > -1 ? this.bulletBrightnessBlock << 4 | this.bulletBrightnessSky << 20 : -1;
        String colorStr = config.getString(new String[]{"backgroundcolor", "color"}, "64,0,0,0", new String[0]);
        try {
            String[] splitStr = colorStr.split(",");
            int a = Integer.parseInt(splitStr[0]);
            int r = Integer.parseInt(splitStr[1]);
            int g2 = Integer.parseInt(splitStr[2]);
            int b = Integer.parseInt(splitStr[3]);
            this.backgroundColor = Color.fromARGB((int)a, (int)r, (int)g2, (int)b);
        }
        catch (Throwable e) {
            this.backgroundColor = Color.fromARGB((int)64, (int)0, (int)0, (int)0);
            MythicLogger.errorMechanic(projectile, "Invalid bullet background color set: " + colorStr);
        }
        this.options = PacketTextDisplay.create().textComponent(Text.parse(this.bulletText.get())).height(Float.valueOf(this.bulletCullingHeight)).width(Float.valueOf(this.bulletCullingWidth)).billboard(this.bulletBillboard).brightness(this.bulletBrightness).lineWidth(200).backgroundColor(this.backgroundColor);
        if (bulletScaleStatic != null) {
            this.options.scale(bulletScaleStatic);
        }
    }

    @Override
    public ProjectileBullet.BulletTracker create(ProjectileBulletableTracker projectile, AbstractEntity target) {
        return new TextBulletTracker(projectile, target);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public class TextBulletTracker
    extends ProjectileBullet.BulletTracker {
        protected PacketArmorStand mount;
        protected PacketTextDisplay bullet;

        public TextBulletTracker(ProjectileBulletableTracker projectile, AbstractEntity target) {
            super(TextDisplayPacketBullet.this, projectile, target);
        }

        @Override
        public void spawn(AbstractLocation start) {
            AbstractLocation l = start.clone();
            this.mount = new PacketArmorStand(l);
            this.bullet = TextDisplayPacketBullet.this.options.build(l);
            AbstractLocation currentLocation = this.getProjectile().getPreviousLocation();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity();
            AbstractVector delta = currentVelocity.clone().normalize().multiply(this.getProjectile().getVelocityMagnitude() / 7.6);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            float pitch = (float)Math.atan2(delta.getY(), len);
            AbstractLocation loc = currentLocation.clone().add(delta);
            float newYaw = (float)Math.toDegrees(-yaw) + 180.0f;
            float newPitch = (float)Math.toDegrees(-pitch);
            loc.setYaw(newYaw);
            loc.setPitch(newPitch);
            Collection<AbstractPlayer> seen = TextDisplayPacketBullet.this.audience.get(this.getProjectile().getData(), this.getTarget());
            this.bullet.setTextComponent(Text.parse(TextDisplayPacketBullet.this.bulletText.get(this.getProjectile().getData())));
            if (!TextDisplayPacketBullet.this.bulletScale.isStatic()) {
                AbstractVector scaleVector = new AbstractVector(TextDisplayPacketBullet.this.bulletScale.get(this.getProjectile().getData()));
                this.bullet.setScale(scaleVector);
            }
            this.mount.getRenderer().setCullingDistance(TextDisplayPacketBullet.this.bulletCullingDistance);
            ((PacketEntityRenderer)this.bullet.getRenderer()).setCullingDistance(TextDisplayPacketBullet.this.bulletCullingDistance);
            ((PacketEntityRenderer)this.bullet.getRenderer()).spawnWithMount(seen, (PacketEntityRenderer)this.mount.getRenderer());
            this.mount.getRenderer().addPassenger((PacketEntityRenderer)this.bullet.getRenderer());
            Schedulers.async().runLater(() -> this.mount.getRenderer().addPassenger((PacketEntityRenderer)this.bullet.getRenderer()), 5L);
        }

        @Override
        public void tick(AbstractLocation origin) {
            Projectile projectileMechanic;
            SkillMechanic skillMechanic;
            if (this.getProjectile().getTimesRan() % 5 == 0) {
                this.mount.getRenderer().updateRenderedPlayers();
                this.bullet.getRenderer().updateRenderedPlayers();
            }
            double forwardOffset = (skillMechanic = TextDisplayPacketBullet.this.getProjectileMechanic()) instanceof Projectile ? ((projectileMechanic = (Projectile)skillMechanic).getTickInterpolation() == 0 ? TextDisplayPacketBullet.this.bulletForwardOffset : TextDisplayPacketBullet.this.bulletForwardOffset * (double)projectileMechanic.getTickInterpolation()) : TextDisplayPacketBullet.this.bulletForwardOffset;
            AbstractLocation currentLocation = this.getProjectile().getPreviousLocation().clone();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity().clone().multiply(forwardOffset);
            AbstractLocation to = currentLocation.clone().add(0.0, TextDisplayPacketBullet.this.bulletYOffset, 0.0);
            AbstractVector delta = currentVelocity;
            to.add(delta);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            float pitch = (float)Math.atan2(delta.getY(), len);
            AbstractLocation loc = to.clone().add(delta);
            float newYaw = (float)Math.toDegrees(-yaw) + 180.0f;
            float newPitch = (float)Math.toDegrees(-pitch);
            loc.setYaw(newYaw);
            loc.setPitch(newPitch);
            this.bullet.setPosition(loc);
            this.bullet.setRotation(newYaw, newPitch);
            this.bullet.update();
            this.mount.teleport(loc);
        }

        @Override
        public void despawn() {
            this.mount.destroy();
            this.bullet.destroy();
        }
    }
}

