/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;

@MythicTargeter(author="Seyarada", name="blockVein", aliases={"vein", "bv"}, description="Targets all blocks in the radius of the inherited target")
public class BlockVeinTargeter
extends ILocationSelector {
    @MythicField(name="blocktype", aliases={"blocktypes", "bt", "t", "material", "materials", "mat", "m", "blocks", "block", "b"}, description="Blocks to add to the Vein", defValue="STONE")
    protected PlaceholderString blockType;
    @MythicField(name="limit", aliases={"l", "max", "m"}, description="Limit of blocks added to the vein", defValue="10")
    protected PlaceholderInt limit;
    @MythicField(name="originMustMatch", aliases={"match"}, description="Check if the origin matches the blocktypes", defValue="true")
    protected boolean originMustMatch;
    List<String> wantedBlockTypes;

    public BlockVeinTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.blockType = mlc.getPlaceholderString(new String[]{"blocktypes", "blocktypes", "bt", "t", "material", "materials", "m", "blocks", "block", "b"}, "STONE", new String[0]);
        this.limit = mlc.getPlaceholderInteger(new String[]{"limit", "l", "max", "m"}, 10, new String[0]);
        this.originMustMatch = mlc.getBoolean(new String[]{"originMustMatch", "match"}, true);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation origin = data.getOrigin();
        this.wantedBlockTypes = List.of(this.blockType.get(data).split(","));
        this.findConnectedBlocks(targets, origin, this.limit.get(data), true);
        return targets;
    }

    private void findConnectedBlocks(Set<AbstractLocation> targets, AbstractLocation origin, int limit, boolean first) {
        Material originBlock;
        if (limit == 0 || targets.size() >= limit) {
            return;
        }
        if (first && this.originMustMatch && !BlockVeinTargeter.blockMatches(originBlock = BukkitAdapter.adapt(origin).getBlock().getType(), this.wantedBlockTypes)) {
            return;
        }
        List<int[]> directions = this.generateRandomizedDirections();
        for (int[] direction : directions) {
            Material material;
            int x = direction[0];
            int y = direction[1];
            int z = direction[2];
            AbstractLocation neighbor = new AbstractLocation(origin.getWorld(), origin.getX() + (double)x, origin.getY() + (double)y, origin.getZ() + (double)z);
            if (targets.contains(neighbor) || !BlockVeinTargeter.blockMatches(material = BukkitAdapter.adapt(neighbor).getBlock().getType(), this.wantedBlockTypes)) continue;
            targets.add(neighbor);
            this.findConnectedBlocks(targets, neighbor, limit - 1, false);
        }
    }

    List<int[]> generateRandomizedDirections() {
        ArrayList<int[]> directions = new ArrayList<int[]>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    directions.add(new int[]{x, y, z});
                }
            }
        }
        Collections.shuffle(directions);
        return directions;
    }
}

