/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.targeters.ILocationTargeter;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.utils.MythicUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

public abstract class ILocationSelector
extends SkillTargeter
implements ILocationTargeter {
    protected PlaceholderDouble xoffset;
    protected PlaceholderDouble yoffset;
    protected PlaceholderDouble zoffset;
    protected PlaceholderDouble forwardOffset;
    protected PlaceholderDouble sideOffset;
    protected PlaceholderDouble rotateX;
    protected PlaceholderDouble rotateY;
    protected PlaceholderDouble rotateZ;
    protected PlaceholderDouble length;
    protected PlaceholderDouble coordinateX;
    protected PlaceholderDouble coordinateY;
    protected PlaceholderDouble coordinateZ;
    protected PlaceholderFloat coordinateYaw;
    protected PlaceholderFloat coordinatePitch;
    protected PlaceholderString blockTypes;
    protected PlaceholderString blockIgnores;
    protected boolean statics = false;
    protected boolean offsets = false;
    protected boolean advOffset = false;
    protected boolean rotated = false;
    protected boolean centered;
    protected boolean faulty;
    private FilterSorter sorter = FilterSorter.NONE;
    private PlaceholderInt skipTargetsUpToIndex;
    private PlaceholderInt limit;

    public ILocationSelector(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.xoffset = mlc.getPlaceholderDouble(new String[]{"xoffset", "xo", "x"}, 0.0, new String[0]);
        this.yoffset = mlc.getPlaceholderDouble(new String[]{"yoffset", "yo", "y"}, 0.0, new String[0]);
        this.zoffset = mlc.getPlaceholderDouble(new String[]{"zoffset", "zo", "z"}, 0.0, new String[0]);
        this.centered = mlc.getBoolean(new String[]{"blockCentered", "centered"}, false);
        this.forwardOffset = mlc.getPlaceholderDouble(new String[]{"forwardoffset", "foffset", "fo"}, 0.0, new String[0]);
        this.sideOffset = mlc.getPlaceholderDouble(new String[]{"sideoffset", "soffset", "so"}, 0.0, new String[0]);
        this.rotateX = mlc.getPlaceholderDouble(new String[]{"rotatex", "rotx"}, 0.0, new String[0]);
        this.rotateY = mlc.getPlaceholderDouble(new String[]{"rotatey", "roty"}, 0.0, new String[0]);
        this.rotateZ = mlc.getPlaceholderDouble(new String[]{"rotatez", "rotz"}, 0.0, new String[0]);
        this.length = mlc.getPlaceholderDouble(new String[]{"length"}, 0.0, new String[0]);
        this.coordinateX = mlc.getPlaceholderDouble(new String[]{"coordinatex", "cx"}, 0.0, new String[0]);
        this.coordinateY = mlc.getPlaceholderDouble(new String[]{"coordinatey", "cy"}, 0.0, new String[0]);
        this.coordinateZ = mlc.getPlaceholderDouble(new String[]{"coordinatez", "cz"}, 0.0, new String[0]);
        this.coordinateYaw = mlc.getPlaceholderFloat(new String[]{"coordinateyaw", "cyaw"}, 0.0f, new String[0]);
        this.coordinatePitch = mlc.getPlaceholderFloat(new String[]{"coordinatepitch", "cpitch"}, 0.0f, new String[0]);
        this.blockTypes = mlc.getPlaceholderString(new String[]{"blocktypes", "blocktype", "bt"}, null, new String[0]);
        this.blockIgnores = mlc.getPlaceholderString(new String[]{"blockignores", "blockignore", "bi"}, null, new String[0]);
        this.faulty = mlc.getBoolean(new String[]{"faulty"}, true);
        if (!(this.xoffset.isStaticallyEqualTo(0.0) && this.yoffset.isStaticallyEqualTo(0.0) && this.zoffset.isStaticallyEqualTo(0.0))) {
            this.offsets = true;
        }
        if (!this.forwardOffset.isStaticallyEqualTo(0.0) || !this.sideOffset.isStaticallyEqualTo(0.0)) {
            this.advOffset = true;
        }
        if (!(this.rotateX.isStaticallyEqualTo(0.0) && this.rotateY.isStaticallyEqualTo(0.0) && this.rotateZ.isStaticallyEqualTo(0.0))) {
            this.rotated = true;
        }
        if (!(this.coordinateX.isStaticallyEqualTo(0.0) && this.coordinateY.isStaticallyEqualTo(0.0) && this.coordinateZ.isStaticallyEqualTo(0.0) && this.coordinateYaw.isStaticallyEqualTo(0.0f) && this.coordinatePitch.isStaticallyEqualTo(0.0f))) {
            this.statics = true;
        }
        this.limit = mlc.getPlaceholderInteger(new String[]{"limit"}, 0, new String[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Setting limit of the target to " + String.valueOf(this.limit), new Object[0]);
        String sort = mlc.getString(new String[]{"sort", "sortby"}, "NONE", new String[0]).toUpperCase();
        try {
            this.sorter = FilterSorter.valueOf(sort);
        }
        catch (Exception ex) {
            MythicLogger.errorTargeterConfig(this, mlc, "'" + sort + "' is not a valid sorter.");
        }
        this.skipTargetsUpToIndex = mlc.getPlaceholderInteger(new String[]{"skipTargetsUpToIndex", "stuti"}, 0, new String[0]);
    }

    @Override
    public abstract Collection<AbstractLocation> getLocations(SkillMetadata var1);

    public void filter(SkillMetadata data) {
        Material mat;
        ArrayList<AbstractLocation> tempTargets;
        if (this.targetConditions != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying target conditions", new Object[0]);
            for (SkillCondition mc : this.targetConditions) {
                if (mc.evaluateTargets(data)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                return;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying location target filters", new Object[0]);
        Collection targets = data.getLocationTargets();
        if (targets == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ No targets to filter?", new Object[0]);
            return;
        }
        if (this.blockIgnores != null) {
            tempTargets = new ArrayList<AbstractLocation>(targets);
            List<String> ignoreList = List.of(this.blockIgnores.get(data).split(","));
            for (AbstractLocation target : tempTargets) {
                mat = BukkitAdapter.adapt(target).getBlock().getType();
                if (!ILocationSelector.blockMatches(mat, ignoreList)) continue;
                targets.remove(target);
            }
        }
        if (this.blockTypes != null) {
            tempTargets = new ArrayList<AbstractLocation>(targets);
            List<String> wantList = List.of(this.blockTypes.get(data).split(","));
            for (AbstractLocation target : tempTargets) {
                mat = BukkitAdapter.adapt(target).getBlock().getType();
                if (ILocationSelector.blockMatches(mat, wantList)) continue;
                targets.remove(target);
            }
        }
        Stream<AbstractLocation> stream = targets.stream();
        int limit = this.limit.get(data);
        int skipTargetsUpToIndex = this.skipTargetsUpToIndex.get(data);
        if (limit > 0 || skipTargetsUpToIndex > 0) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Limit of " + limit + " being checked for with " + this.sorter.name() + " sort being applied.", new Object[0]);
            switch (this.sorter.ordinal()) {
                case 2: {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Sorting from nearest... thanks josh.", new Object[0]);
                    AbstractLocation origin = data.getOrigin();
                    stream = stream.sorted((o1, o2) -> {
                        double d1 = origin.distanceSquared((AbstractLocation)o1);
                        double d2 = origin.distanceSquared((AbstractLocation)o2);
                        return Double.compare(d1, d2);
                    });
                    break;
                }
                case 3: {
                    AbstractLocation origin = data.getOrigin();
                    stream = stream.sorted((o1, o2) -> {
                        double d1 = origin.distanceSquared((AbstractLocation)o1);
                        double d2 = origin.distanceSquared((AbstractLocation)o2);
                        return Double.compare(d2, d1);
                    });
                    break;
                }
                case 1: {
                    stream = stream.collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
                        Collections.shuffle(collected);
                        return collected.stream();
                    }));
                }
            }
        }
        if (skipTargetsUpToIndex > 0) {
            stream = stream.skip(skipTargetsUpToIndex);
        }
        if (limit > 0) {
            stream = stream.limit(limit);
        }
        targets = stream.collect(Collectors.toCollection(ArrayList::new));
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Returning {0} targets", targets.size());
        data.setLocationTargets(targets);
    }

    public AbstractLocation mutate(SkillMetadata data, AbstractLocation location) {
        double len;
        if (this.offsets) {
            location = location.clone().add(this.xoffset.get(data), this.yoffset.get(data), this.zoffset.get(data));
        }
        if (this.advOffset) {
            location = MythicUtil.move(this.faulty, location, this.forwardOffset.get(data), 0.0, this.sideOffset.get(data));
        }
        if ((len = this.length.get(data)) != 0.0) {
            location = location.add(location.getDirection().clone().multiply(len));
        }
        if (this.statics) {
            float cPitch;
            float cYaw;
            double cZ;
            double cY;
            double cX = this.coordinateX.get(data);
            if (cX != 0.0) {
                location.setX(cX);
            }
            if ((cY = this.coordinateY.get(data)) != 0.0) {
                location.setY(cY);
            }
            if ((cZ = this.coordinateZ.get(data)) != 0.0) {
                location.setZ(cZ);
            }
            if ((cYaw = this.coordinateYaw.get(data)) != 0.0f) {
                location.setYaw(cYaw);
            }
            if ((cPitch = this.coordinatePitch.get(data)) != 0.0f) {
                location.setPitch(cPitch);
            }
        }
        if (this.centered) {
            double bX = location.getBlockX();
            double bZ = location.getBlockZ();
            location.setX(bX + 0.5);
            location.setZ(bZ + 0.5);
        }
        return location;
    }

    public static boolean blockMatches(Material mat, List<String> list) {
        block5: for (String wantType : list) {
            wantType = wantType.toUpperCase();
            switch (wantType.charAt(0)) {
                case '#': {
                    if (!mat.toString().contains(wantType.substring(1))) continue block5;
                    return true;
                }
                case '@': {
                    if (!mat.toString().startsWith(wantType.substring(1))) continue block5;
                    return true;
                }
                case '*': {
                    NamespacedKey tagKey = NamespacedKey.minecraft((String)wantType.toLowerCase().substring(1));
                    Tag tag = Bukkit.getTag((String)"blocks", (NamespacedKey)tagKey, Material.class);
                    if (tag == null) {
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ BlockTag '" + String.valueOf(tagKey) + "' does not exist, returning true", new Object[0]);
                        return true;
                    }
                    return tag.isTagged((Keyed)mat);
                }
            }
            if (mat != Material.valueOf((String)wantType)) continue;
            return true;
        }
        return false;
    }

    private static enum FilterSorter {
        NONE,
        RANDOM,
        NEAREST,
        FURTHEST;

    }
}

