/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.function.Predicate;

@MythicTargeter(author="Ashijin", name="livingInCone", aliases={"entitiesInCone", "livingEntitiesInCone", "LEIC", "EIC"}, description="Targets random points in a cone shape")
public class LivingInConeTargeter
extends IEntitySelector {
    protected PlaceholderDouble angle;
    protected PlaceholderDouble range;
    protected PlaceholderDouble rotation;
    protected PlaceholderDouble yOffset;
    private boolean usePitch = false;

    public LivingInConeTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.angle = mlc.getPlaceholderDouble(new String[]{"angle", "a"}, 90.0, new String[0]);
        this.range = mlc.getPlaceholderDouble(new String[]{"range", "r"}, 16.0, new String[0]);
        this.yOffset = mlc.getPlaceholderDouble(new String[]{"yoffset", "yo"}, 0.0, new String[0]);
        this.rotation = mlc.getPlaceholderDouble(new String[]{"rotation", "rot"}, 0.0, new String[0]);
        this.usePitch = mlc.getBoolean(new String[]{"usepitch", "pitch", "p"}, false);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        if (this.usePitch) {
            double angleHalf = this.angle.get(data) / 2.0;
            double rotationOffset = this.rotation.get(data);
            double maxRange = this.range.get(data);
            double maxRangeSq = maxRange * maxRange;
            double cosAngleThreshold = Math.cos(Math.toRadians(angleHalf));
            SkillCaster caster = data.getCaster();
            AbstractLocation casterLocation = caster.getLocation().clone();
            casterLocation.add(0.0, this.yOffset.get(data), 0.0);
            AbstractVector direction = this.getDirectionVector(casterLocation, rotationOffset);
            Predicate<AbstractEntity> entityFilter = entity -> {
                if (entity.getUniqueId().equals(caster.getEntity().getUniqueId())) {
                    return false;
                }
                if (!entity.isLiving()) {
                    return false;
                }
                double distanceSq = casterLocation.distanceSquared(entity.getLocation());
                if (distanceSq > maxRangeSq) {
                    return false;
                }
                AbstractVector toEntity = entity.getLocation().subtract(casterLocation).toVector();
                toEntity.normalize();
                direction.normalize();
                double dotProduct = direction.dot(toEntity);
                return dotProduct >= cosAngleThreshold;
            };
            return casterLocation.getWorld().getEntitiesNearLocation(casterLocation, maxRange, entityFilter);
        }
        double angle = this.angle.get(data) / 2.0;
        double rotation = this.rotation.get(data);
        double radius = this.range.get(data);
        double radiusSq = Math.pow(radius, 2.0);
        AbstractLocation casterLocation = data.getCaster().getLocation();
        AbstractVector dir = data.getCaster().getLocation().getDirection();
        if (rotation > 0.0) {
            dir.rotate((float)rotation);
        }
        dir.setY(0);
        double cos = Math.cos(angle * Math.PI / 180.0);
        double cosSq = cos * cos;
        Predicate<AbstractEntity> entityFilter = ae -> {
            if (ae.getUniqueId().equals(data.getCaster().getEntity().getUniqueId())) {
                return false;
            }
            if (!ae.isLiving()) {
                return false;
            }
            double dist = this.distanceSquared(casterLocation, (AbstractEntity)ae);
            if (dist > radiusSq) {
                return false;
            }
            AbstractVector relative = ae.getLocation().subtract(data.getCaster().getLocation()).toVector();
            relative.setY(0);
            double dot = relative.getX() * dir.getX() + relative.getY() * dir.getY() + relative.getZ() * dir.getZ();
            double value = dot * dot / relative.lengthSquared();
            if (angle < 180.0 && dot > 0.0 && value >= cosSq) {
                return true;
            }
            return angle >= 180.0 && (dot > 0.0 || dot <= cosSq);
        };
        return casterLocation.getWorld().getEntitiesNearLocation(casterLocation, radius, entityFilter);
    }

    private AbstractVector getDirectionVector(AbstractLocation casterLocation, double rotationOffset) {
        float yaw = (float)Math.toRadians((double)casterLocation.getYaw() + rotationOffset);
        float pitch = this.usePitch ? (float)Math.toRadians(casterLocation.getPitch()) : 0.0f;
        double x = -Math.sin(yaw) * Math.cos(pitch);
        double y = -Math.sin(pitch);
        double z = Math.cos(yaw) * Math.cos(pitch);
        return new AbstractVector(x, y, z);
    }
}

