/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.spawners;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitWorld;
import io.lumine.mythic.bukkit.utils.collections.WeightedCollection;
import io.lumine.mythic.bukkit.utils.collections.WeightedEntry;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.numbers.RandomInt;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.spawning.spawners.SpawnerManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.World;

public class MythicSpawner
implements Cloneable,
PropertyHolder {
    private static final StringProp GROUP = Property.String(Scope.CONFIG, "SpawnerGroup");
    private static final StringProp MOB_TYPE = Property.String(Scope.CONFIG, "MobName");
    private static final StringProp WORLD = Property.String(Scope.CONFIG, "World", "world");
    private static final IntProp POS_X = Property.Int(Scope.CONFIG, "X", 0);
    private static final IntProp POS_Y = Property.Int(Scope.CONFIG, "Y", 0);
    private static final IntProp POS_Z = Property.Int(Scope.CONFIG, "Z", 0);
    private static final DoubleProp YAW = Property.Double(Scope.CONFIG, "Yaw", 0.0);
    private static final DoubleProp PITCH = Property.Double(Scope.CONFIG, "Pitch", 0.0);
    private static final DoubleProp SPAWN_RADIUS_H = Property.Double(Scope.CONFIG, "Radius", 0.0);
    private static final DoubleProp SPAWN_RADIUS_V = Property.Double(Scope.CONFIG, "RadiusY", 0.0);
    private static final BooleanProp USE_TIMER = Property.Boolean(Scope.CONFIG, "UseTimer", true);
    private static final StringProp MAX_MOBS = Property.String(Scope.CONFIG, "MaxMobs", "1");
    private static final StringProp MOB_LEVEL = Property.String(Scope.CONFIG, "MobLevel", "0");
    private static final IntProp MOBS_PER_SPAWN = Property.Int(Scope.CONFIG, "MobsPerSpawn", 1);
    private static final IntProp COOLDOWN = Property.Int(Scope.CONFIG, "Cooldown", 0);
    private static final IntProp COOLDOWN_TIMER = Property.Int(Scope.CONFIG, "CooldownTimer", 0);
    private static final IntProp WARMUP = Property.Int(Scope.CONFIG, "Warmup", 0);
    private static final IntProp WARMUP_TIMER = Property.Int(Scope.CONFIG, "WarmupTimer", 0);
    private static final DoubleProp ACTIVATION_RANGE = Property.Double(Scope.CONFIG, "ActivationRange", 32.0);
    private static final DoubleProp SCALING_RANGE = Property.Double(Scope.CONFIG, "ScalingRange", 32.0);
    private static final DoubleProp LEASH_RANGE = Property.Double(Scope.CONFIG, "LeashRange", 32.0);
    private static final BooleanProp LEASH_HEAL = Property.Boolean(Scope.CONFIG, "HealOnLeash", true);
    private static final BooleanProp LEASH_RESET_THREAT = Property.Boolean(Scope.CONFIG, "ResetThreatOnLeash", true);
    private static final BooleanProp BREAKABLE = Property.Boolean(Scope.CONFIG, "Breakable", false);
    private static final BooleanProp CHECK_FOR_PLAYERS = Property.Boolean(Scope.CONFIG, "CheckForPlayers", true);
    private static final BooleanProp SHOW_FLAMES = Property.Boolean(Scope.CONFIG, "ShowFlames", false);
    private static final StringListProp CONDITIONS_ACTIVATE = Property.StringList(Scope.CONFIG, "Conditions");
    private static final StringListProp CONDITIONS_TARGET = Property.StringList(Scope.CONFIG, "SpawnConditions");
    private static final IntProp ACTIVE_MOBS = Property.Int(Scope.CONFIG, "ActiveMobs", 0);
    private final MythicBukkit plugin;
    private final SpawnerManager manager;
    private boolean active = true;
    private boolean ready = true;
    private File file;
    private String name;
    private String group;
    private String strMobTypes;
    private AbstractLocation location;
    private String world;
    private int blockX;
    private int blockY;
    private int blockZ;
    private double yaw;
    private double pitch;
    private boolean useTimer = true;
    private long spawnCooldownMillis = 0L;
    private long spawnCooldownTimer = 0L;
    private long spawnWarmupMillis = 4L;
    private long spawnWarmupTimer = 0L;
    private double spawnRadius = 0.0;
    private double spawnRadiusY = 0.0;
    private PlaceholderInt maxMobs = PlaceholderInt.of("1");
    private int mobsPerSpawn = 1;
    private RandomInt mobLevel = new RandomInt(1);
    private boolean showFlames = false;
    private boolean breakable = false;
    private boolean checkForPlayers = true;
    private double activationRange = 32.0;
    private double scalingRange = 25.0;
    private double leashRange = 32.0;
    private boolean healOnLeash = false;
    private boolean leashResetsThreat = false;
    private Collection<SkillCondition> conditions = Lists.newArrayList();
    private Collection<SkillCondition> conditionsTarget = Lists.newArrayList();
    protected int cachedActiveMobs = 0;
    private Collection<UUID> mobs = Collections.newSetFromMap(new ConcurrentHashMap());
    private ReentrantLock mobsLock = new ReentrantLock();
    private transient boolean save;
    private transient WeightedCollection<WeightedEntry<String>> mobTypes = new WeightedCollection();
    private transient int leashTimer = 0;
    private transient int internalCooldown = 8;
    private transient int mobHeight = 0;

    public MythicSpawner(SpawnerManager manager, String name, AbstractLocation location, String mobName) {
        MythicMob mm4;
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.name = name;
        this.file = new File(manager.getSpawnerFolder(), name + ".yml");
        this.save = !((MythicBukkit)manager.getPlugin()).getConfiguration().isSpawnersDisableSaving();
        this.strMobTypes = mobName;
        if (!this.setType(this.strMobTypes)) {
            MythicLogger.error("Error enabling spawner '{0}' - MobType '{1}' is invalid! Spawner cannot initialize. Disabling.", this.name, this.strMobTypes);
        }
        this.mobHeight = (mm4 = MythicBukkit.inst().getMobManager().getMythicMob(this.strMobTypes).orElseGet(() -> null)) != null && mm4.getMythicEntity() != null ? mm4.getMythicEntity().getHeight() : 2;
        this.location = location;
        this.world = location.getWorld().getName();
        this.blockX = location.getBlockX();
        this.blockY = location.getBlockY();
        this.blockZ = location.getBlockZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.spawnRadius = 0.0;
        if (this.location == null) {
            MythicLogger.error("Location data for spawner '{0}' is invalid! Spawner cannot be attached to world. Disabling.", this.name);
            this.Disable();
        }
        this.spawnCooldownTimer = System.currentTimeMillis();
        this.spawnWarmupTimer = System.currentTimeMillis();
        this.save();
    }

    public MythicSpawner(SpawnerManager manager, File file, String name) {
        SkillCondition condition;
        AbstractWorld w;
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.file = file;
        this.name = name;
        this.save = !((MythicBukkit)manager.getPlugin()).getConfiguration().isSpawnersDisableSaving();
        this.group = (String)GROUP.fget((Object)file, this);
        this.strMobTypes = (String)MOB_TYPE.fget((Object)file, this);
        this.setType(this.strMobTypes);
        for (WeightedEntry<String> weighted : this.mobTypes.getView()) {
            int mobHeight;
            Optional<MythicMob> mob = this.getPlugin().getMobManager().getMythicMob(weighted.getValue());
            if (mob.isEmpty() || (mobHeight = mob.get().getMythicEntity().getHeight()) <= this.mobHeight) continue;
            this.mobHeight = mobHeight;
        }
        this.world = (String)WORLD.fget((Object)file, this);
        this.blockX = (Integer)POS_X.fget((Object)file, this);
        this.blockY = (Integer)POS_Y.fget((Object)file, this);
        this.blockZ = (Integer)POS_Z.fget((Object)file, this);
        this.yaw = (Double)YAW.fget((Object)file, this);
        this.pitch = (Double)PITCH.fget((Object)file, this);
        try {
            w = new BukkitWorld(this.world);
        }
        catch (IllegalArgumentException ex) {
            w = BukkitAdapter.adapt((World)Bukkit.getWorlds().get(0));
        }
        this.location = new AbstractLocation(w, (double)this.blockX, (double)this.blockY, (double)this.blockZ);
        this.spawnRadius = (Double)SPAWN_RADIUS_H.fget((Object)file, this);
        this.spawnRadiusY = (Double)SPAWN_RADIUS_V.fget((Object)file, this);
        this.useTimer = (Boolean)USE_TIMER.fget((Object)file, this);
        this.maxMobs = PlaceholderInt.of((String)MAX_MOBS.fget((Object)file, this));
        this.mobsPerSpawn = (Integer)MOBS_PER_SPAWN.fget((Object)file, this);
        this.mobLevel = new RandomInt((String)MOB_LEVEL.fget((Object)file, this));
        this.spawnCooldownMillis = TimeUnit.SECONDS.toMillis(((Integer)COOLDOWN.fget((Object)file, this)).intValue());
        this.setRemainingCooldownSeconds(((Integer)COOLDOWN_TIMER.fget((Object)file, this)).intValue());
        this.spawnWarmupMillis = TimeUnit.SECONDS.toMillis(((Integer)WARMUP.fget((Object)file, this)).intValue());
        this.setRemainingWarmupSeconds(((Integer)WARMUP_TIMER.fget((Object)file, this)).intValue());
        this.showFlames = (Boolean)SHOW_FLAMES.fget((Object)file, this);
        this.activationRange = (Double)ACTIVATION_RANGE.fget((Object)file, this);
        this.scalingRange = (Double)SCALING_RANGE.fget((Object)file, this);
        this.leashRange = (Double)LEASH_RANGE.fget((Object)file, this);
        this.healOnLeash = (Boolean)LEASH_HEAL.fget((Object)file, this);
        this.leashResetsThreat = (Boolean)LEASH_RESET_THREAT.fget((Object)file, this);
        String mobLevel = (String)MOB_LEVEL.fget((Object)file, this);
        this.breakable = (Boolean)BREAKABLE.fget((Object)file, this);
        this.checkForPlayers = (Boolean)CHECK_FOR_PLAYERS.fget((Object)file, this);
        this.cachedActiveMobs = (Integer)ACTIVE_MOBS.fget((Object)file, this);
        for (String line : (List)CONDITIONS_ACTIVATE.fget((Object)file, this)) {
            condition = this.getPlugin().getSkillManager().getCondition(line);
            if (condition == null) continue;
            this.conditions.add(condition);
        }
        for (String line : (List)CONDITIONS_TARGET.fget((Object)file, this)) {
            condition = this.getPlugin().getSkillManager().getCondition(line);
            if (condition == null) continue;
            this.conditionsTarget.add(condition);
        }
        if (this.spawnRadius < 0.0) {
            this.spawnRadius = 0.0;
        }
        if (this.spawnRadiusY < 1.0) {
            this.spawnRadiusY = 1.0;
        }
        if (this.getRemainingWarmupSeconds() > 0 || this.getRemainingCooldownSeconds() > 0) {
            this.ready = false;
        }
    }

    public void unloadSpawner() {
        this.mobsLock.lock();
        try {
            this.mobs.removeIf(uuid -> {
                Optional<ActiveMob> maybeMob = MythicBukkit.inst().getMobManager().getActiveMob((UUID)uuid);
                if (maybeMob.isPresent()) {
                    ActiveMob am = maybeMob.get();
                    if (am.getType().getDespawnMode().getDespawnsOnUnload().booleanValue()) {
                        if (!am.isDead() && am.getEntity() != null && am.getEntity().isValid()) {
                            ++this.cachedActiveMobs;
                            am.despawn();
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            });
        }
        finally {
            this.mobsLock.unlock();
        }
        this.internalCooldown = 10;
    }

    public void saveSpawnerData() {
        if (!this.save || this.file == null || this == null) {
            return;
        }
        int mobCount = this.getNumberOfCachedMobs();
        int cd2 = this.getRemainingCooldownSeconds();
        int wu = this.getRemainingWarmupSeconds();
        if (cd2 > 0) {
            COOLDOWN_TIMER.fset((Object)this.file, this, Integer.valueOf(cd2));
        }
        if (wu > 0) {
            WARMUP_TIMER.fset((Object)this.file, this, Integer.valueOf(wu));
        }
        if (mobCount > 0) {
            ACTIVE_MOBS.fset((Object)this.file, this, Integer.valueOf(mobCount));
        }
    }

    public void save() {
        if (!this.save) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Spawner saving is disabled - skipping saving.", new Object[0]);
            return;
        }
        if (this.getInternalName() == null) {
            throw new IllegalStateException("Spawner Internal Name cannot be null");
        }
        this.mobsLock.lock();
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "SPAWNER SAVE CALLED", new Object[0]);
        try {
            MOB_TYPE.fsetStaged((Object)this.file, this, this.strMobTypes);
            GROUP.fsetStaged((Object)this.file, this, this.group);
            WORLD.fsetStaged((Object)this.file, this, this.world);
            POS_X.fsetStaged((Object)this.file, this, Integer.valueOf(this.blockX));
            POS_Y.fsetStaged((Object)this.file, this, Integer.valueOf(this.blockY));
            POS_Z.fsetStaged((Object)this.file, this, Integer.valueOf(this.blockZ));
            YAW.fsetStaged((Object)this.file, this, Double.valueOf(this.yaw));
            PITCH.fsetStaged((Object)this.file, this, Double.valueOf(this.pitch));
            SPAWN_RADIUS_H.fsetStaged((Object)this.file, this, Double.valueOf(this.spawnRadius));
            SPAWN_RADIUS_V.fsetStaged((Object)this.file, this, Double.valueOf(this.spawnRadiusY));
            USE_TIMER.fsetStaged((Object)this.file, this, Boolean.valueOf(this.useTimer));
            MAX_MOBS.fsetStaged((Object)this.file, this, this.maxMobs.serialize());
            MOB_LEVEL.fsetStaged((Object)this.file, this, this.mobLevel.toString());
            MOBS_PER_SPAWN.fsetStaged((Object)this.file, this, Integer.valueOf(this.mobsPerSpawn));
            COOLDOWN.fset((Object)this.file, this, Integer.valueOf(this.getCooldownSeconds()));
            WARMUP.fset((Object)this.file, this, Integer.valueOf(this.getWarmupSeconds()));
            ACTIVATION_RANGE.fsetStaged((Object)this.file, this, Double.valueOf(this.activationRange));
            SCALING_RANGE.fsetStaged((Object)this.file, this, Double.valueOf(this.scalingRange));
            LEASH_RANGE.fsetStaged((Object)this.file, this, Double.valueOf(this.leashRange));
            LEASH_HEAL.fsetStaged((Object)this.file, this, Boolean.valueOf(this.healOnLeash));
            LEASH_RESET_THREAT.fsetStaged((Object)this.file, this, Boolean.valueOf(this.leashResetsThreat));
            BREAKABLE.fsetStaged((Object)this.file, this, Boolean.valueOf(this.breakable));
            CHECK_FOR_PLAYERS.fsetStaged((Object)this.file, this, Boolean.valueOf(this.checkForPlayers));
            SHOW_FLAMES.fsetStaged((Object)this.file, this, Boolean.valueOf(this.showFlames));
            CONDITIONS_ACTIVATE.fsetStaged((Object)this.file, this, this.conditions.stream().map(condition -> condition.getLine()).toList());
            CONDITIONS_TARGET.fset((Object)this.file, this, this.conditionsTarget.stream().map(condition -> condition.getLine()).toList());
        }
        finally {
            this.mobsLock.unlock();
        }
    }

    private File getFile() {
        return new File(this.manager.getSpawnerFolder(), this.name + ".yml");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.file = this.getFile();
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
        if (this.save) {
            GROUP.fset((Object)this.file, this, group);
        }
    }

    public String getTypeName() {
        return this.strMobTypes;
    }

    public boolean setType(String type) {
        this.mobTypes.clear();
        String[] split = type.split(",");
        try {
            for (String s2 : split) {
                double weight;
                String mobType;
                if (s2.contains("%")) {
                    split2 = s2.split("%");
                    mobType = split2[1];
                    weight = Double.valueOf(split2[0]) / 100.0;
                } else if (s2.contains(" ")) {
                    split2 = s2.split(" ");
                    mobType = split2[0];
                    weight = Double.valueOf(split2[1]);
                } else {
                    mobType = s2;
                    weight = 1.0;
                }
                this.mobTypes.add(new WeightedEntry<String>(mobType, weight));
            }
        }
        catch (Exception ex) {
            MythicLogger.handleMinorError(ex);
            return false;
        }
        this.strMobTypes = type;
        if (this.save) {
            MOB_TYPE.fset((Object)this.file, this, this.strMobTypes);
        }
        return true;
    }

    public void setType(MythicMob type) {
        this.mobTypes.clear();
        this.mobTypes.add(new WeightedEntry<String>(type.getInternalName(), 1.0));
        if (this.save) {
            MOB_TYPE.fset((Object)this.file, this, type.getInternalName());
        }
    }

    public void setTypes(Collection<MythicMob> types) {
        this.mobTypes.clear();
        StringBuilder sb = new StringBuilder();
        for (MythicMob mm4 : types) {
            this.mobTypes.add(new WeightedEntry<String>(mm4.getInternalName(), 1.0));
            sb.append(mm4.getInternalName());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        this.strMobTypes = sb.toString();
        if (this.save) {
            MOB_TYPE.fset((Object)this.file, this, this.strMobTypes);
        }
    }

    public void setTypes(WeightedCollection types) {
        this.mobTypes = types;
    }

    public void setYaw(double yaw) {
        this.location.setYaw((float)yaw);
        if (this.save) {
            YAW.fset((Object)this.file, this, Double.valueOf(yaw));
        }
    }

    public void setPitch(double yaw) {
        this.location.setPitch((float)yaw);
        if (this.save) {
            PITCH.fset((Object)this.file, this, Double.valueOf(this.pitch));
        }
    }

    public void setLocation(AbstractLocation location) {
        this.location = location;
        this.blockX = location.getBlockX();
        this.blockY = location.getBlockY();
        this.blockZ = location.getBlockZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.world = location.getWorld().getName();
        if (this.save) {
            WORLD.fset((Object)this.file, this, this.world);
            POS_X.fset((Object)this.file, this, Integer.valueOf(this.blockX));
            POS_Y.fset((Object)this.file, this, Integer.valueOf(this.blockY));
            POS_Z.fset((Object)this.file, this, Integer.valueOf(this.blockZ));
            YAW.fset((Object)this.file, this, Double.valueOf(this.yaw));
            PITCH.fset((Object)this.file, this, Double.valueOf(this.pitch));
        }
    }

    public String getWorldName() {
        return this.world;
    }

    public void setWorld(String worldName) {
        this.world = worldName;
    }

    public void setOnCooldown() {
        this.spawnCooldownTimer = System.currentTimeMillis();
    }

    public boolean isOnCooldown() {
        return this.spawnCooldownMillis + this.spawnCooldownTimer - System.currentTimeMillis() > 0L;
    }

    public int getCooldownSeconds() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.spawnCooldownMillis);
    }

    public void setCooldownSeconds(int cooldown) {
        this.spawnCooldownMillis = TimeUnit.SECONDS.toMillis(cooldown);
        if (this.save) {
            COOLDOWN.fset((Object)this.file, this, Integer.valueOf(cooldown));
        }
    }

    public int getRemainingCooldownSeconds() {
        if (this.isOnCooldown()) {
            return (int)Math.abs(TimeUnit.MILLISECONDS.toSeconds(this.spawnCooldownMillis + this.spawnCooldownTimer - System.currentTimeMillis()));
        }
        return 0;
    }

    public void setRemainingCooldownSeconds(long seconds) {
        this.spawnCooldownTimer = System.currentTimeMillis() - this.spawnCooldownMillis + TimeUnit.SECONDS.toMillis(seconds);
    }

    public void setOnWarmup() {
        this.spawnWarmupTimer = System.currentTimeMillis();
    }

    public boolean isOnWarmup() {
        return this.spawnWarmupMillis + this.spawnWarmupTimer - System.currentTimeMillis() > 0L;
    }

    public int getWarmupSeconds() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.spawnWarmupMillis);
    }

    public void setWarmupSeconds(int warmup) {
        this.spawnWarmupMillis = TimeUnit.SECONDS.toMillis(warmup);
        if (this.save) {
            WARMUP.fset((Object)this.file, this, Integer.valueOf(warmup));
        }
    }

    public int getRemainingWarmupSeconds() {
        if (this.isOnWarmup()) {
            return (int)Math.abs(TimeUnit.MILLISECONDS.toSeconds(this.spawnWarmupMillis + this.spawnWarmupTimer - System.currentTimeMillis()));
        }
        return 0;
    }

    public void setRemainingWarmupSeconds(long seconds) {
        this.spawnWarmupTimer = System.currentTimeMillis() - this.spawnWarmupMillis + TimeUnit.SECONDS.toMillis(seconds);
    }

    public boolean getUseTimer() {
        return this.useTimer;
    }

    public void setUseTimer(boolean bool) {
        this.useTimer = bool;
        if (this.save) {
            USE_TIMER.fset((Object)this.file, this, Boolean.valueOf(bool));
        }
    }

    public int getInternalCooldown() {
        return this.internalCooldown;
    }

    public void setInternalCooldown(int ic) {
        this.internalCooldown = ic;
    }

    public void tickSpawnerClock() {
        --this.internalCooldown;
        boolean spawn = true;
        if (this.isOnCooldown() || this.isOnWarmup()) {
            spawn = false;
            this.ready = false;
        } else if (!this.useTimer) {
            spawn = false;
        }
        if (!this.active) {
            return;
        }
        if (this.internalCooldown <= 1) {
            if (!(this.location != null && Bukkit.getWorld((String)this.world) != null || this.reattachToWorld())) {
                this.internalCooldown = 8;
                return;
            }
            if (!this.location.isLoaded()) {
                this.internalCooldown = 5;
                return;
            }
            if (this.checkForPlayers && !SpawnerManager.playerWithinSpawnerRange((int)this.activationRange, this.location)) {
                this.internalCooldown = 4;
                return;
            }
            if (this.maxMobs.get(this) <= this.getNumberOfMobs()) {
                this.cleanMobList();
                if (this.isOnWarmup()) {
                    return;
                }
            }
        } else if (this.internalCooldown > 1) {
            if (this.leashRange > 0.0 && this.getNumberOfMobs() > 0 && this.leashTimer-- <= 0) {
                this.Leash();
                this.leashTimer = 2;
            }
            return;
        }
        if (this.leashRange > 0.0 && this.leashRange > 0.0 && this.leashTimer-- <= 0) {
            this.Leash();
            this.leashTimer = 2;
        }
        if (this.showFlames) {
            BukkitAdapter.adapt(this.location).getWorld().playEffect(BukkitAdapter.adapt(this.location), Effect.MOBSPAWNER_FLAMES, 0);
        }
        if (this.cachedActiveMobs > 0) {
            while (this.cachedActiveMobs > 0) {
                this.Spawn();
                --this.cachedActiveMobs;
            }
            return;
        }
        if (this.maxMobs.get(this) <= this.getNumberOfMobs()) {
            return;
        }
        if (!spawn || !this.useTimer || this.getPlugin().getConfiguration().isDebugMode()) {
            return;
        }
        for (SkillCondition condition : this.conditions) {
            if (condition.evaluateSpawner(this, this.getLocation())) continue;
            return;
        }
        Collection<ActiveMob> spawns = this.Spawn();
        for (ActiveMob am : spawns) {
            SkillMetadata data = MythicBukkit.inst().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.READY, am, null, null, false);
            this.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
        }
    }

    public void ActivateSpawner() {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Activating spawner {0}", this.getInternalName());
        if (this.location.getWorld() == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Spawner world is unloaded.", new Object[0]);
            return;
        }
        if (this.getPlugin().getConfiguration().getDebugLevel() > 0 || this.showFlames) {
            BukkitAdapter.adapt(this.location).getWorld().playEffect(BukkitAdapter.adapt(this.location), Effect.MOBSPAWNER_FLAMES, 0);
        }
        if (!this.active || this.isOnCooldown() || this.isOnWarmup()) {
            return;
        }
        if (this.maxMobs.get(this) <= this.getNumberOfMobs()) {
            if (this.cleanMobList()) {
                if (this.spawnWarmupMillis > 0L) {
                    this.setOnWarmup();
                    return;
                }
            } else {
                return;
            }
        }
        for (SkillCondition condition : this.conditions) {
            if (condition.evaluateSpawner(this, this.getLocation())) continue;
            return;
        }
        Collection<ActiveMob> spawns = this.Spawn();
        for (ActiveMob am : spawns) {
            SkillMetadata data = this.getPlugin().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.READY, am, null, null, false);
            this.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
        }
    }

    public boolean checkSpawnConditions(AbstractLocation spawnLocation) {
        for (SkillCondition condition : this.conditionsTarget) {
            if (condition.evaluateSpawner(this, spawnLocation)) continue;
            return false;
        }
        return true;
    }

    private void registerMob(ActiveMob mob) {
        this.mobsLock.lock();
        try {
            this.mobs.add(mob.getUniqueId());
        }
        finally {
            this.mobsLock.unlock();
        }
    }

    private void unregisterMob(ActiveMob mob) {
        this.mobsLock.lock();
        try {
            this.mobs.remove(mob.getUniqueId());
        }
        finally {
            this.mobsLock.unlock();
        }
    }

    public Collection<UUID> getAssociatedMobs() {
        ArrayList mobs = Lists.newArrayList();
        this.mobsLock.lock();
        try {
            mobs.addAll(this.mobs);
        }
        finally {
            this.mobsLock.unlock();
        }
        return mobs;
    }

    public void setAssociatedMobs(Collection<UUID> collection) {
        this.mobsLock.lock();
        try {
            this.mobs = collection;
        }
        finally {
            this.mobsLock.unlock();
        }
    }

    public Collection<ActiveMob> Spawn() {
        if (!this.active) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Spawner " + this.name + " Spawn() called. Spawning mobs...", new Object[0]);
        if (this.cachedActiveMobs == 0) {
            this.setOnCooldown();
        }
        AbstractLocation baseLoc = new AbstractLocation(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + 1.0, this.location.getZ() + 0.5, (float)this.yaw, (float)this.pitch);
        boolean good = false;
        int j = 25;
        ArrayList<ActiveMob> mobs = new ArrayList<ActiveMob>();
        block2: for (int i = this.mobsPerSpawn; i > 0 && this.maxMobs.get(this) > this.getNumberOfMobs(); --i) {
            ActiveMob am;
            Object spawningLocation;
            block16: {
                spawningLocation = null;
                if (this.spawnRadius > 0.0 || this.spawnRadiusY > 1.0) {
                    AbstractLocation loc;
                    j = 11;
                    block3: while (true) {
                        if (--j == 0) {
                            spawningLocation = this.location.clone().add(0.0, 1.0, 0.0);
                            for (SkillCondition condition : this.conditionsTarget) {
                                if (condition.evaluateSpawner(this, (AbstractLocation)spawningLocation)) continue;
                                continue block2;
                            }
                            break block16;
                        }
                        int nx = (int)((double)this.location.getBlockX() - this.spawnRadius + (double)Numbers.randomInt((int)(this.spawnRadius * 2.0)));
                        int nz = (int)((double)this.location.getBlockZ() - this.spawnRadius + (double)Numbers.randomInt((int)(this.spawnRadius * 2.0)));
                        int ny = this.spawnRadiusY > 0.0 ? (int)((double)this.location.getBlockY() - this.spawnRadiusY + (double)Numbers.randomInt((int)(this.spawnRadiusY * 2.0))) + 1 : this.location.getBlockY() + 1;
                        loc = new AbstractLocation(this.location.getWorld(), nx, ny, nz, (float)this.yaw, (float)this.pitch);
                        for (int k = 0; k < this.mobHeight; ++k) {
                            AbstractLocation check = new AbstractLocation(this.location.getWorld(), nx, ny + k, nz, (float)this.yaw, (float)this.pitch);
                            if (BukkitAdapter.adapt(check).getBlock().getType().isSolid()) continue block3;
                        }
                        for (SkillCondition condition : this.conditionsTarget) {
                            if (condition.evaluateSpawner(this, loc)) continue;
                            continue block3;
                        }
                        break;
                    }
                    spawningLocation = loc;
                } else {
                    spawningLocation = new AbstractLocation(this.location.getWorld(), this.location.getBlockX(), this.location.getBlockY() + 1, this.location.getBlockZ(), (float)this.yaw, (float)this.pitch);
                    for (SkillCondition condition : this.conditionsTarget) {
                        if (condition.evaluateSpawner(this, (AbstractLocation)spawningLocation)) continue;
                        continue block2;
                    }
                }
            }
            if (spawningLocation == null) {
                spawningLocation = this.location.clone().add(0.0, 1.0, 0.0);
            }
            try {
                String nextType = this.mobTypes.get().getValue();
                am = MythicBukkit.inst().getMobManager().spawnMob(nextType, ((AbstractLocation)spawningLocation).add(0.5, 0.0, 0.5), SpawnReason.SPAWNER, this.mobLevel.get(), this);
            }
            catch (Error | Exception ex) {
                am = null;
                MythicLogger.errorGenericConfig("Failed to spawn mob for Spawner '" + this.name + "'. Enable debugging for more info.");
                this.setRemainingCooldownSeconds(5L);
                MythicLogger.handleMinorError(ex);
                return mobs;
            }
            if (am == null) {
                MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "-- Spawner " + this.name + " failed to spawn mob: SpawnMythicMob returned null.", new Object[0]);
                return mobs;
            }
            if (!am.getType().getDespawnMode().getSavesToDisk().booleanValue()) {
                am.getEntity().setSavesToDisk(false);
            }
            this.registerMob(am);
            mobs.add(am);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "-- Spawner spawned mob(s). Number of mobs tied to spawner now: {0}", this.getNumberOfMobs());
        return mobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Leash() {
        if (this.leashRange < 1.0) {
            return;
        }
        this.mobsLock.lock();
        try {
            for (UUID uuid : this.mobs) {
                Optional<ActiveMob> maybeMob = MythicBukkit.inst().getMobManager().getActiveMob(uuid);
                if (!maybeMob.isPresent() || maybeMob.get().getEntity() == null) continue;
                ActiveMob am = maybeMob.get();
                if (am.getLocation().getWorld().equals(this.location.getWorld())) {
                    if (!(this.location.distanceSquared(am.getEntity().getLocation()) > Numbers.square(this.leashRange))) continue;
                    if (am.getEntity().getVehicle() != null) {
                        AbstractEntity l = am.getEntity();
                        while (l.getVehicle() != null) {
                            if (this.healOnLeash && l.isLiving()) {
                                l.setHealth(l.getMaxHealth());
                            }
                            if (this.leashResetsThreat) {
                                MythicBukkit.inst().getMobManager().getMythicMobInstance(l).resetTarget();
                            }
                            l = l.getVehicle();
                        }
                    }
                    this.doLeash(am);
                    continue;
                }
                this.doLeash(am);
            }
        }
        finally {
            this.mobsLock.unlock();
        }
    }

    public void doLeash(ActiveMob am) {
        AbstractLocation spawnLocation = this.location.clone().add(0.5, 1.0, 0.5);
        am.getEntity().teleport(spawnLocation);
        if (this.healOnLeash && am.getEntity().isLiving()) {
            am.getEntity().setHealth(am.getEntity().getMaxHealth());
        }
        if (this.leashResetsThreat) {
            am.resetTarget();
        }
    }

    private boolean cleanMobList() {
        this.mobsLock.lock();
        try {
            boolean bl = this.mobs.removeIf(uuid -> {
                if (!MythicBukkit.inst().getMobManager().isActiveMob((UUID)uuid)) {
                    return true;
                }
                ActiveMob am = MythicBukkit.inst().getMobManager().getActiveMob((UUID)uuid).get();
                if (am.isDead()) {
                    if (this.getNumberOfMobs() >= this.maxMobs.get(this)) {
                        this.setOnWarmup();
                    }
                    return true;
                }
                return false;
            });
            return bl;
        }
        finally {
            this.mobsLock.unlock();
        }
    }

    public boolean trackMob(ActiveMob am) {
        if (am.getDespawnMode().getDespawnWithoutNearbyPlayers().booleanValue() && this.mobs.size() >= this.maxMobs.get(this)) {
            return false;
        }
        this.registerMob(am);
        return true;
    }

    public void markMobDespawned(ActiveMob am) {
        this.unregisterMob(am);
    }

    public void markMobDead(ActiveMob am) {
        this.mobsLock.lock();
        try {
            if (this.mobs.contains(am.getUniqueId())) {
                if (this.getNumberOfMobs() >= this.maxMobs.get(this)) {
                    this.setOnWarmup();
                }
                this.mobs.remove(am.getUniqueId());
            }
        }
        finally {
            this.mobsLock.unlock();
        }
    }

    public boolean reattachToWorld() {
        if (Bukkit.getWorld((String)this.world) == null) {
            return false;
        }
        this.location = new AbstractLocation(BukkitAdapter.adapt(Bukkit.getWorld((String)this.world)), (double)this.blockX, (double)this.blockY, (double)this.blockZ);
        if (this.location == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Spawner {0} has an invalid location and could not be reattached to world. Perhaps the world is unloaded?", this.name);
            return false;
        }
        return true;
    }

    public String getInternalName() {
        return this.name;
    }

    public int getNumberOfMobs() {
        return this.mobs.size() + this.cachedActiveMobs;
    }

    public void Disable() {
        this.active = false;
    }

    public void Enable() {
        this.active = true;
    }

    public double distanceTo(AbstractLocation abstractLocation) {
        return abstractLocation.distance(this.location);
    }

    public MythicSpawner clone() throws CloneNotSupportedException {
        return (MythicSpawner)super.clone();
    }

    public void resetTimers() {
        this.spawnWarmupTimer = System.currentTimeMillis() - this.spawnWarmupMillis;
        this.spawnCooldownTimer = System.currentTimeMillis() - this.spawnCooldownMillis;
    }

    public int getChunkX() {
        return this.blockX >> 4;
    }

    public int getChunkZ() {
        return this.blockZ >> 4;
    }

    public String getChunkString() {
        return this.world + "-" + this.getChunkX() + "-" + this.getChunkZ();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getNumberOfCachedMobs() {
        return this.cachedActiveMobs;
    }

    @Override
    public String getPropertyNode() {
        return this.name;
    }

    public void setSpawnRadius(double opt) {
        this.spawnRadius = opt;
        if (this.save) {
            SPAWN_RADIUS_H.fset((Object)this.file, this, Double.valueOf(opt));
        }
    }

    public void setSpawnRadiusY(double opt) {
        this.spawnRadiusY = opt;
        if (this.save) {
            SPAWN_RADIUS_V.fset((Object)this.file, this, Double.valueOf(opt));
        }
    }

    public void setMaxMobs(PlaceholderInt opt) {
        this.maxMobs = opt;
        if (this.save) {
            MAX_MOBS.fset((Object)this.file, this, opt.serialize());
        }
    }

    public void setMobsPerSpawn(int opt) {
        this.mobsPerSpawn = opt;
        if (this.save) {
            MOBS_PER_SPAWN.fset((Object)this.file, this, Integer.valueOf(opt));
        }
    }

    public void setMobLevel(RandomInt opt) {
        this.mobLevel = opt;
        if (this.save) {
            MOB_LEVEL.fset((Object)this.file, this, opt.toString());
        }
    }

    public void setShowFlames(boolean opt) {
        this.showFlames = opt;
        if (this.save) {
            SHOW_FLAMES.fset((Object)this.file, this, Boolean.valueOf(opt));
        }
    }

    public void setBreakable(boolean opt) {
        this.breakable = opt;
        if (this.save) {
            BREAKABLE.fset((Object)this.file, this, Boolean.valueOf(opt));
        }
    }

    public void setCheckForPlayers(boolean opt) {
        this.checkForPlayers = opt;
        if (this.save) {
            CHECK_FOR_PLAYERS.fset((Object)this.file, this, Boolean.valueOf(opt));
        }
    }

    public void setActivationRange(double opt) {
        this.activationRange = opt;
        if (this.save) {
            ACTIVATION_RANGE.fset((Object)this.file, this, Double.valueOf(opt));
        }
    }

    public void setScalingRange(double opt) {
        this.scalingRange = opt;
        if (this.save) {
            SCALING_RANGE.fset((Object)this.file, this, Double.valueOf(opt));
        }
    }

    public void setLeashRange(double opt) {
        this.leashRange = opt;
        if (this.save) {
            LEASH_RANGE.fset((Object)this.file, this, Double.valueOf(opt));
        }
    }

    public void setHealOnLeash(boolean opt) {
        this.healOnLeash = opt;
        if (this.save) {
            LEASH_HEAL.fset((Object)this.file, this, Boolean.valueOf(opt));
        }
    }

    public void setLeashResetsThreat(boolean opt) {
        this.leashResetsThreat = opt;
        if (this.save) {
            LEASH_RESET_THREAT.fset((Object)this.file, this, Boolean.valueOf(opt));
        }
    }

    public boolean addCondition(String line) {
        SkillCondition condition = ((MythicBukkit)this.manager.getPlugin()).getSkillManager().getCondition(line);
        if (condition == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "The condition " + line + " does not exist!", new Object[0]);
            return false;
        }
        this.conditions.add(condition);
        if (this.save) {
            this.saveConditions();
        }
        return true;
    }

    public boolean removeCondition(String line) {
        this.conditions.removeIf(condition -> condition.getLine().toLowerCase().startsWith(line.toLowerCase()));
        if (this.save) {
            this.saveConditions();
        }
        return true;
    }

    private void saveConditions() {
        CONDITIONS_ACTIVATE.fset((Object)this.file, this, this.conditions.stream().map(condition -> condition.getLine()).toList());
    }

    public boolean addTargetCondition(String line) {
        SkillCondition condition = ((MythicBukkit)this.manager.getPlugin()).getSkillManager().getCondition(line);
        if (condition == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "The condition " + line + " does not exist!", new Object[0]);
            return false;
        }
        this.conditionsTarget.add(condition);
        if (this.save) {
            this.saveTargetConditions();
        }
        return true;
    }

    public boolean removeTargetCondition(String line) {
        this.conditionsTarget.removeIf(condition -> condition.getLine().toLowerCase().startsWith(line.toLowerCase()));
        if (this.save) {
            this.saveTargetConditions();
        }
        return true;
    }

    private void saveTargetConditions() {
        CONDITIONS_TARGET.fset((Object)this.file, this, this.conditionsTarget.stream().map(condition -> condition.getLine()).toList());
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public SpawnerManager getManager() {
        return this.manager;
    }

    public AbstractLocation getLocation() {
        return this.location;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockY() {
        return this.blockY;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    public void setBlockX(int blockX) {
        this.blockX = blockX;
    }

    public void setBlockY(int blockY) {
        this.blockY = blockY;
    }

    public void setBlockZ(int blockZ) {
        this.blockZ = blockZ;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getSpawnRadius() {
        return this.spawnRadius;
    }

    public double getSpawnRadiusY() {
        return this.spawnRadiusY;
    }

    public PlaceholderInt getMaxMobs() {
        return this.maxMobs;
    }

    public int getMobsPerSpawn() {
        return this.mobsPerSpawn;
    }

    public RandomInt getMobLevel() {
        return this.mobLevel;
    }

    public boolean isShowFlames() {
        return this.showFlames;
    }

    public boolean isBreakable() {
        return this.breakable;
    }

    public boolean isCheckForPlayers() {
        return this.checkForPlayers;
    }

    public double getActivationRange() {
        return this.activationRange;
    }

    public double getScalingRange() {
        return this.scalingRange;
    }

    public double getLeashRange() {
        return this.leashRange;
    }

    public boolean isHealOnLeash() {
        return this.healOnLeash;
    }

    public boolean isLeashResetsThreat() {
        return this.leashResetsThreat;
    }

    public Collection<SkillCondition> getConditions() {
        return this.conditions;
    }

    public Collection<SkillCondition> getConditionsTarget() {
        return this.conditionsTarget;
    }

    public void setSave(boolean save) {
        this.save = save;
    }
}

