/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.utils;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class MythicUtil {
    public static final float DEGTORAD = (float)Math.PI / 180;
    public static final float RADTODEG = 57.29578f;

    public static boolean matchNumber(String s2, double i) {
        if (s2 == null) {
            return false;
        }
        try {
            s2 = s2.replace(" ", "");
            if (s2.contains("=")) {
                double d = Double.parseDouble(s2.substring(1));
                if (i == d) {
                    return true;
                }
            } else if (s2.contains(">")) {
                double d = Double.parseDouble(s2.substring(1));
                if (i > d) {
                    return true;
                }
            } else if (s2.contains("<")) {
                double d = Double.parseDouble(s2.substring(1));
                if (i < d) {
                    return true;
                }
            } else if (s2.contains("to")) {
                String[] split = s2.split("to");
                double d1 = Double.parseDouble(split[0]);
                double d2 = Double.parseDouble(split[1]);
                if (i >= d1 && i <= d2) {
                    return true;
                }
            } else if (s2.contains("-")) {
                String[] split = s2.split("-");
                double d1 = Double.parseDouble(split[0]);
                double d2 = Double.parseDouble(split[1]);
                if (i >= d1 && i <= d2) {
                    return true;
                }
            } else {
                double d = Double.parseDouble(s2);
                if (i == d) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Object getPrivateField(String fieldName, Class clazz, Object object) {
        Object o = null;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            o = field.get(object);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return o;
    }

    public static void setPrivateField(String fieldName, Class clazz, Object object, Object value) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static LivingEntity getTargetedEntity(Player player) {
        BlockIterator bi;
        List ne;
        int range = 32;
        if (Bukkit.isPrimaryThread()) {
            ne = player.getNearbyEntities((double)range, (double)range, (double)range);
        } else {
            try {
                ne = (List)Promise.supplyingSync(() -> player.getNearbyEntities((double)range, (double)range, (double)range)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (Entity en : ne) {
            if (!(en instanceof LivingEntity)) continue;
            entities.add((LivingEntity)en);
        }
        LivingEntity target = null;
        try {
            bi = new BlockIterator((LivingEntity)player, range);
        }
        catch (IllegalStateException e) {
            return null;
        }
        while (bi.hasNext()) {
            Block b = bi.next();
            int bx = b.getX();
            int by = b.getY();
            int bz = b.getZ();
            Material material = b.getType();
            if (material != Material.BARRIER && (material.isOccluding() || material.isSolid())) break;
            for (LivingEntity e : entities) {
                Location l = e.getLocation();
                double ex = l.getX();
                double ey = l.getY();
                double ez = l.getZ();
                if (!((double)bx - 0.75 <= ex) || !(ex <= (double)bx + 1.75) || !((double)bz - 0.75 <= ez) || !(ez <= (double)bz + 1.75) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                target = e;
                if (target != null && target instanceof Player && ((Player)target).getGameMode() == GameMode.CREATIVE) {
                    target = null;
                    continue;
                }
                return target;
            }
        }
        return null;
    }

    public static void rotateVector(Vector v, float degrees2) {
        double rad = Math.toRadians(degrees2);
        double sin = Math.sin(rad);
        double cos = Math.cos(rad);
        double x = v.getX() * cos - v.getZ() * sin;
        double z = v.getX() * sin + v.getZ() * cos;
        v.setX(x);
        v.setZ(z);
    }

    public static Double calculateLaunchAngle(Location from, Location to, double v, double elevation, double g2) {
        double check;
        Vector vector = from.clone().subtract(to).toVector();
        Double distance = Math.sqrt(Math.pow(vector.getX(), 2.0) + Math.pow(vector.getZ(), 2.0));
        double v2 = Math.pow(v, 2.0);
        double v4 = Math.pow(v, 4.0);
        if (v4 < (check = g2 * (g2 * Math.pow(distance, 2.0) + 2.0 * elevation * v2))) {
            return null;
        }
        return Math.atan((v2 - Math.sqrt(v4 - check)) / (g2 * distance));
    }

    public static double calculateHangtime(double launchAngle, double v, double elev, double g2) {
        double a = v * Math.sin(launchAngle);
        double b = -2.0 * g2 * elev;
        if (Math.pow(a, 2.0) + b < 0.0) {
            return 0.0;
        }
        return (a + Math.sqrt(Math.pow(a, 2.0) + b)) / g2;
    }

    public static Vector normalizeVector(Vector victor) {
        double mag = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getY(), 2.0) + Math.pow(victor.getZ(), 2.0));
        if (mag != 0.0) {
            return victor.multiply(1.0 / mag);
        }
        return victor.multiply(0);
    }

    public static Location moveBukkit(Location loc, Vector offset) {
        return MythicUtil.moveBukkit(loc, offset.getX(), offset.getY(), offset.getZ());
    }

    public static Location moveBukkit(Location loc, double dx, double dy, double dz) {
        Vector off = MythicUtil.rotateBukkit(loc.getYaw(), loc.getPitch(), dx, dy, dz);
        double x = loc.getX() + off.getX();
        double y = loc.getY() + off.getY();
        double z = loc.getZ() + off.getZ();
        return new Location(loc.getWorld(), x, y, z, loc.getYaw(), loc.getPitch());
    }

    public static Vector rotateBukkit(float yaw, float pitch, Vector value) {
        return MythicUtil.rotateBukkit(yaw, pitch, value.getX(), value.getY(), value.getZ());
    }

    public static Vector rotateBukkit(float yaw, float pitch, double x, double y, double z) {
        return new Vector(x, y, z).rotateAroundX((double)(pitch * ((float)Math.PI / 180))).rotateAroundY((double)(yaw * ((float)Math.PI / 180)));
    }

    public static AbstractLocation move(AbstractLocation loc, AbstractVector offset) {
        return MythicUtil.move(loc, offset.getX(), offset.getY(), offset.getZ());
    }

    public static AbstractLocation move(AbstractLocation loc, double dx, double dy, double dz) {
        AbstractVector off = MythicUtil.rotate(loc.getYaw(), loc.getPitch(), dx, dy, dz);
        double x = loc.getX() + off.getX();
        double y = loc.getY() + off.getY();
        double z = loc.getZ() + off.getZ();
        return new AbstractLocation(loc.getWorld(), x, y, z, loc.getYaw(), loc.getPitch());
    }

    public static AbstractVector rotate(float yaw, float pitch, AbstractVector value) {
        return MythicUtil.rotate(yaw, pitch, value.getX(), value.getY(), value.getZ());
    }

    public static AbstractVector rotate(float yaw, float pitch, double x, double y, double z) {
        return new AbstractVector(-z, y, -x).rotateAroundX(pitch * ((float)Math.PI / 180)).rotateAroundY(-yaw * ((float)Math.PI / 180));
    }

    @Deprecated
    public static AbstractLocation move(boolean faulty, AbstractLocation loc, double dx, double dy, double dz) {
        return faulty ? MythicUtil.faultyMove(loc, dx, dy, dz) : MythicUtil.move(loc, dx, dy, dz);
    }

    @Deprecated
    private static AbstractLocation faultyMove(AbstractLocation loc, double dx, double dy, double dz) {
        AbstractVector off = MythicUtil.faultyRotate(loc.getYaw(), loc.getPitch(), dx, dy, dz);
        double x = loc.getX() + off.getX();
        double y = loc.getY() + off.getY();
        double z = loc.getZ() + off.getZ();
        return new AbstractLocation(loc.getWorld(), x, y, z, loc.getYaw(), loc.getPitch());
    }

    @Deprecated
    private static AbstractVector faultyRotate(float yaw, float pitch, double x, double y, double z) {
        float angle = yaw * ((float)Math.PI / 180);
        double sinyaw = Math.sin(angle);
        double cosyaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinpitch = Math.sin(angle);
        double cospitch = Math.cos(angle);
        double newx = 0.0;
        double newy = 0.0;
        double newz = 0.0;
        newz -= x * cosyaw;
        newz -= y * sinyaw * sinpitch;
        newx += x * sinyaw;
        newx -= y * cosyaw * sinpitch;
        newy += y * cospitch;
        return new AbstractVector(newx -= z * cosyaw * cospitch, newy -= z * sinpitch, newz -= z * sinyaw * cospitch);
    }

    public static UUID getUUIDFromString(String s2) {
        String md5 = MythicUtil.getMD5(s2);
        String uuid = md5.substring(0, 8) + "-" + md5.substring(8, 12) + "-" + md5.substring(12, 16) + "-" + md5.substring(16, 20) + "-" + md5.substring(20);
        return UUID.fromString(uuid);
    }

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            Object hashtext = number.toString(16);
            while (((String)hashtext).length() < 32) {
                hashtext = "0" + (String)hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] wrapString(String text, int maxLineLength) {
        String[] lines;
        StringBuilder result = new StringBuilder();
        text = text.replace("\\n", "\n");
        for (String line : lines = text.split("\n", -1)) {
            StringBuilder lineBuilder = new StringBuilder();
            String[] words = line.split(" ", -1);
            int currentLength = 0;
            for (String word : words) {
                if (currentLength + word.length() > maxLineLength) {
                    if (lineBuilder.length() > 0) {
                        result.append(lineBuilder.toString().trim()).append("\n");
                        lineBuilder = new StringBuilder();
                    }
                    currentLength = 0;
                }
                lineBuilder.append(word).append(" ");
                currentLength += word.length() + 1;
            }
            if (lineBuilder.length() <= 0) continue;
            result.append(lineBuilder.toString().trim());
            if (line.equals(lines[lines.length - 1])) continue;
            result.append("\n");
        }
        return result.toString().split("\n");
    }

    public static List<String> splitIgnoringParentheses(String input) {
        ArrayList<String> splitList = new ArrayList<String>();
        int openParentheses = 0;
        StringBuilder segment = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (c == '(') {
                ++openParentheses;
            } else if (c == ')') {
                --openParentheses;
            }
            if (c == ' ' && openParentheses == 0) {
                splitList.add(segment.toString());
                segment.setLength(0);
                continue;
            }
            segment.append(c);
        }
        if (segment.length() > 0) {
            splitList.add(segment.toString());
        }
        return splitList;
    }
}

