/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.utils.annotations;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.core.logging.MythicLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.bukkit.plugin.java.JavaPlugin;

public class AnnotationUtil {
    public static ClassLoader classLoader = AnnotationUtil.class.getClassLoader();

    public static <T extends Annotation> Collection<Class<?>> getAnnotatedClasses(JavaPlugin plugin, String path, Class<T> clazz) {
        ArrayList classesToReturn;
        block19: {
            String filename = null;
            try {
                filename = URLDecoder.decode(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                try {
                    filename = URLDecoder.decode(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.ISO_8859_1.toString());
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
            }
            if (filename == null) {
                throw new IllegalStateException("Failed to load jar entries");
            }
            classesToReturn = Lists.newArrayList();
            try {
                JarInputStream jarFile = new JarInputStream(new FileInputStream(filename));
                block14: while (true) {
                    while (true) {
                        JarEntry jarEntry;
                        if ((jarEntry = jarFile.getNextJarEntry()) == null) {
                            break block19;
                        }
                        if (!jarEntry.getName().endsWith(".class")) continue;
                        String s1 = jarEntry.getName();
                        String cn1 = s1.substring(0, s1.length() - 6).replace("/", ".");
                        try {
                            if (!cn1.startsWith(path)) continue block14;
                            AbstractMap.SimpleEntry<T, Class<?>> entry = AnnotationUtil.getClazz(cn1, clazz);
                            if (entry.getKey() == null) {
                                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Annotation not found for {0}", cn1);
                                continue;
                            }
                            classesToReturn.add(entry.getValue());
                            continue block14;
                        }
                        catch (Throwable ex) {
                            Log.info("Failed to parse class {0}", cn1);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return classesToReturn;
    }

    private static <T extends Annotation> AbstractMap.SimpleEntry<T, Class<?>> getClazz(String cn1, Class<T> clazz) throws ClassNotFoundException {
        Class<?> c1 = null;
        try {
            c1 = Class.forName(cn1, false, classLoader);
        }
        catch (Throwable e) {
            return new AbstractMap.SimpleEntry<Object, Object>(null, null);
        }
        return new AbstractMap.SimpleEntry(c1.getAnnotation(clazz), c1);
    }
}

