/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R3;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileEntityHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.glow.GlowColor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.lumine.mythic.core.volatilecode.v1_19_R3.VolatileCompoundTag;
import io.lumine.mythic.core.volatilecode.v1_19_R3.VolatileDamageSource;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class VolatileEntityHandlerImpl
implements VolatileEntityHandler {
    private static final AtomicInteger ENTITY_COUNTER = (AtomicInteger)Reflector.getValue(net.minecraft.world.entity.Entity.class, "d");
    private static final String ENTITY_DIMENSIONS = "be";
    private static final String ENTITY_EYE_HEIGHT = "bf";
    private static final String DATA_SHARED_FLAGS_ID = "an";
    private static final String ATTRIBUTES = "b";
    private static final Reflector<AttributeMapBase> refAttributeMap = new Reflector<AttributeMapBase>(AttributeMapBase.class, "b");
    private static Reflector<net.minecraft.world.entity.Entity> refEntity = new Reflector<net.minecraft.world.entity.Entity>(net.minecraft.world.entity.Entity.class, "be", "bf", "an");
    private static final DataWatcherObject<Byte> SHARED_FLAGS = new DataWatcherObject(0, DataWatcherRegistry.a);

    public VolatileEntityHandlerImpl(VolatileCodeHandler handler) {
    }

    @Override
    public void initTeams(AbstractPlayer player) {
        for (GlowColor color : GlowColor.values()) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(color.teamName());
            buf.writeByte(0);
            buf.a((IChatBaseComponent)IChatBaseComponent.b((String)color.teamName()));
            buf.writeByte(3);
            buf.a("always");
            buf.a("always");
            buf.a((Enum)color);
            buf.a((IChatBaseComponent)IChatBaseComponent.h());
            buf.a((IChatBaseComponent)IChatBaseComponent.h());
            buf.a(List.of(), PacketDataSerializer::a);
            PacketPlayOutScoreboardTeam teamPacket = new PacketPlayOutScoreboardTeam(buf);
            ((CraftPlayer)BukkitAdapter.adapt((AbstractPlayer)player)).getHandle().b.a((Packet)teamPacket);
        }
    }

    @Override
    public void setGlowColor(AbstractEntity target, @NotNull GlowColor color, AbstractPlayer player) {
        PacketDataSerializer teamBuf = new PacketDataSerializer(Unpooled.buffer());
        teamBuf.a(color.teamName());
        teamBuf.writeByte(3);
        if (target.isPlayer()) {
            teamBuf.a(List.of(target.asPlayer().getName()), PacketDataSerializer::a);
        } else {
            teamBuf.a(List.of(target.getUniqueId().toString()), PacketDataSerializer::a);
        }
        PacketPlayOutScoreboardTeam teamsPacket = new PacketPlayOutScoreboardTeam(teamBuf);
        ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a((Packet)teamsPacket);
    }

    @Override
    public void setGlowing(AbstractEntity target, boolean glowing, AbstractPlayer receiver) {
        net.minecraft.world.entity.Entity entity = ((CraftEntity)target.getBukkitEntity()).getHandle();
        int previous = entity.aj().d() ? 0 : (Byte)entity.aj().a(SHARED_FLAGS);
        byte b2 = (byte)(glowing ? previous | 0x40 : previous);
        PacketPlayOutEntityMetadata glowPacket = new PacketPlayOutEntityMetadata(target.getEntityId(), List.of(DataWatcher.b.a(SHARED_FLAGS, (Object)b2)));
        ((CraftPlayer)receiver.getBukkitEntity()).getHandle().b.a((Packet)glowPacket);
    }

    @Override
    public int getNextEntityId() {
        return ENTITY_COUNTER == null ? 0 : ENTITY_COUNTER.incrementAndGet();
    }

    @Override
    public void setCustomName(AbstractEntity entity, String name) {
        net.minecraft.world.entity.Entity le = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        le.b(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(Text.parse(name)))));
    }

    @Override
    public void registerAttribute(AbstractEntity entity, Attribute attribute) {
        EntityLiving livingEntity = ((CraftLivingEntity)entity.getBukkitEntity()).getHandle();
        AttributeMapBase attributeMap = livingEntity.eI();
        Map attributes = (Map)refAttributeMap.get(attributeMap, ATTRIBUTES);
        AttributeBase nmsAttribute = CraftAttributeMap.toMinecraft((Attribute)attribute);
        AttributeModifiable attributeInstance = new AttributeModifiable(nmsAttribute, AttributeModifiable::a);
        attributes.put(nmsAttribute, attributeInstance);
    }

    @Override
    public void stopUsingItem(AbstractEntity entity) {
        EntityLiving living = ((CraftLivingEntity)entity.getBukkitEntity()).getHandle();
        living.fj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doDamage(DamageMetadata data, AbstractEntity aTarget) {
        SkillCaster caster = data.getDamager();
        double damage = data.getAmount();
        DamageSource reason = this.getDamageSource(data);
        if (aTarget == null) {
            return false;
        }
        if (!aTarget.isDamageable()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Damage cancelled: target is not damageable", new Object[0]);
            return false;
        }
        caster.setUsingDamageSkill(true);
        caster.getEntity().setMetadata("doing-skill-damage", true);
        aTarget.setMetadata("skill-damage", data);
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            am.setLastDamageSkillAmount(damage);
        }
        EntityLiving target = ((CraftLivingEntity)aTarget.getBukkitEntity()).getHandle();
        AttributeModifier mod = new AttributeModifier(UUID.randomUUID(), "mythic$kbresist", 1.0, AttributeModifier.Operation.ADD_NUMBER);
        boolean res = false;
        try {
            if (data.getPreventsKnockback().booleanValue()) {
                ((CraftLivingEntity)aTarget.getBukkitEntity()).getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).addModifier(mod);
            }
            res = target.a(reason, (float)damage);
        }
        finally {
            if (data.getPreventsImmunity().booleanValue()) {
                aTarget.setNoDamageTicks(0);
            }
            ((CraftLivingEntity)aTarget.getBukkitEntity()).getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).removeModifier(mod);
            caster.getEntity().removeMetadata("doing-skill-damage");
            caster.setUsingDamageSkill(false);
            aTarget.removeMetadata("skill-damage");
        }
        return res;
    }

    private DamageSource getDamageSource(DamageMetadata data) {
        net.minecraft.world.entity.Entity source = ((CraftEntity)data.getDamager().getEntity().getBukkitEntity()).getHandle();
        DamageSources damageSources = source.Y().af();
        DamageSource src = damageSources.n();
        switch (data.getDamageCause()) {
            case CONTACT: {
                src = damageSources.j();
                break;
            }
            case ENTITY_ATTACK: {
                EntityLiving living;
                if (source instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)source;
                    src = damageSources.a(player);
                    break;
                }
                src = damageSources.b(source instanceof EntityLiving ? (living = (EntityLiving)source) : null);
                break;
            }
            case ENTITY_SWEEP_ATTACK: {
                if (src == damageSources.n()) break;
                src = src.sweep();
                break;
            }
            case PROJECTILE: {
                Projectile projectile;
                CraftEntity living = source.getBukkitEntity();
                src = damageSources.b(source, living instanceof Projectile && (projectile = (Projectile)living).getShooter() instanceof Entity ? ((CraftEntity)((Projectile)source.getBukkitEntity()).getShooter()).getHandle() : null);
                break;
            }
            case SUFFOCATION: {
                src = damageSources.f();
                break;
            }
            case FALL: {
                src = damageSources.k();
                break;
            }
            case FIRE: {
                src = damageSources.a();
                break;
            }
            case FIRE_TICK: {
                src = damageSources.c();
                break;
            }
            case MELTING: {
                src = damageSources.melting;
                break;
            }
            case LAVA: {
                src = damageSources.d();
                break;
            }
            case DROWNING: {
                src = damageSources.h();
                break;
            }
            case BLOCK_EXPLOSION: {
                if (source instanceof EntityTNTPrimed) {
                    ProjectileSource projectileSource;
                    EntityTNTPrimed tntPrimed = (EntityTNTPrimed)source;
                    if (tntPrimed.projectileSource != null && (projectileSource = tntPrimed.projectileSource) instanceof net.minecraft.world.entity.Entity) {
                        net.minecraft.world.entity.Entity projectileEntity = (net.minecraft.world.entity.Entity)projectileSource;
                        src = damageSources.d((net.minecraft.world.entity.Entity)tntPrimed, projectileEntity);
                        break;
                    }
                    src = damageSources.d((net.minecraft.world.entity.Entity)tntPrimed, null);
                    break;
                }
                src = damageSources.d(source, source);
                break;
            }
            case ENTITY_EXPLOSION: {
                src = damageSources.d(source, source);
                break;
            }
            case VOID: {
                src = damageSources.m();
                break;
            }
            case LIGHTNING: {
                src = damageSources.b();
                break;
            }
            case SUICIDE: {
                break;
            }
            case STARVATION: {
                src = damageSources.i();
                break;
            }
            case POISON: {
                src = damageSources.poison;
                break;
            }
            case MAGIC: {
                src = damageSources.o();
                break;
            }
            case WITHER: {
                src = damageSources.p();
                break;
            }
            case FALLING_BLOCK: {
                src = damageSources.a(source);
                break;
            }
            case THORNS: {
                src = damageSources.d(source);
                break;
            }
            case DRAGON_BREATH: {
                src = damageSources.q();
                break;
            }
            case FLY_INTO_WALL: {
                src = damageSources.l();
                break;
            }
            case HOT_FLOOR: {
                src = damageSources.e();
                break;
            }
            case CRAMMING: {
                src = damageSources.g();
                break;
            }
            case DRYOUT: {
                src = damageSources.r();
                break;
            }
            case FREEZE: {
                src = damageSources.t();
                break;
            }
            case SONIC_BOOM: {
                src = damageSources.e(source);
            }
        }
        VolatileDamageSource returnSource = VolatileDamageSource.of(src);
        if (data.getIgnoresArmor().booleanValue()) {
            returnSource.ignoreArmor(true);
        }
        if (data.getIgnoreEnchantments().booleanValue()) {
            returnSource.ignoreEnchantments(true);
        }
        returnSource.ignoreShield(data.getBoolean("ignore_shield"));
        returnSource.damagesHelmet(data.getBoolean("damages_helmet"));
        returnSource.ignoreCooldown(data.getPreventsImmunity());
        returnSource.ignoreEffects(data.getBoolean("ignore_effects"));
        returnSource.noAnger(data.getBoolean("no_anger"));
        returnSource.ignoreResistance(data.getBoolean("ignore_resistance"));
        return returnSource;
    }

    @Override
    public float getEntityAbsorptionHearts(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return 0.0f;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        return el.fb();
    }

    @Override
    public void setEntityAbsorptionHearts(AbstractEntity entity, float value) {
        if (!entity.isLiving()) {
            return;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        el.x(value);
    }

    @Override
    public void setLocation(AbstractEntity entity, AbstractLocation location) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        net.minecraft.world.entity.Entity e = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        e.a(x, y, z, yaw, pitch);
        if (entity.isPlayer()) {
            this.playerConnectionTeleport(entity, x, y, z, yaw, pitch, noRotation, noGravity);
        }
        if (e.H instanceof WorldServer) {
            // empty if block
        }
    }

    @Override
    public void setPlayerRotation(AbstractPlayer entity, float yaw, float pitch) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<RelativeMovement> set = new HashSet<RelativeMovement>();
        set.add(RelativeMovement.a);
        set.add(RelativeMovement.b);
        set.add(RelativeMovement.c);
        set.add(RelativeMovement.e);
        set.add(RelativeMovement.d);
        me.b.a((Packet)new PacketPlayOutPosition(0.0, 0.0, 0.0, yaw, pitch, set, 0));
    }

    private void playerConnectionTeleport(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<RelativeMovement> set = new HashSet<RelativeMovement>();
        boolean dismountVehicle = false;
        if (noRotation) {
            pitch = 0.0f;
            yaw = 0.0f;
            set.add(RelativeMovement.e);
            set.add(RelativeMovement.d);
        }
        if (noGravity) {
            set.add(RelativeMovement.b);
            y = 0.0;
        }
        me.b.a((Packet)new PacketPlayOutPosition(x, y, z, yaw, pitch, set, 0));
    }

    @Override
    public boolean isEntityInMotion(AbstractEntity entity, boolean exact) {
        if (entity.isLiving()) {
            EntityLiving e = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
            Vec3D position = e.de();
            if (exact) {
                if (e.I != position.a() || e.J != position.b() || e.K != position.c()) {
                    return true;
                }
            } else {
                int x = Numbers.floor(e.I);
                int y = Numbers.floor(e.J);
                int z = Numbers.floor(e.K);
                int pX = Numbers.floor(position.a());
                int pY = Numbers.floor(position.b());
                int pZ = Numbers.floor(position.c());
                if (x != pX || y != pY || z != pZ) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public AbstractVector getEntityMotion(AbstractEntity entity) {
        if (entity.isLiving()) {
            EntityLiving e = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
            Vec3D position = e.de();
            double x = position.a() - e.I;
            double y = position.b() - e.J;
            double z = position.c() - e.K;
            return new AbstractVector(x, y, z);
        }
        return new AbstractVector(0, 0, 0);
    }

    @Override
    public void setHitBox(AbstractEntity target, double width, double height) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity ent = ((CraftEntity)entity).getHandle();
        AxisAlignedBB bb = new AxisAlignedBB(ent.dl() - width / 2.0, ent.dn(), ent.dr() - width / 2.0, ent.dl() + width / 2.0, ent.dn() + height, ent.dr() + width / 2.0);
        ent.a(bb);
        refEntity.set(ent, ENTITY_DIMENSIONS, new EntitySize((float)width, (float)height, true));
        refEntity.set(ent, ENTITY_EYE_HEIGHT, Float.valueOf((float)(height * 0.8)));
    }

    @Override
    public void setItemPosition(AbstractEntity target, AbstractLocation ol) {
        Entity entity = BukkitAdapter.adapt(target);
        if (entity instanceof Item) {
            Item item = (Item)entity;
            EntityItem ei = (EntityItem)((CraftItem)item).getHandle();
            ei.h(ol.getX(), ol.getY(), ol.getZ());
        }
    }

    @Override
    public void sendEntityTeleportPacket(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        PacketPlayOutEntityTeleport tp = new PacketPlayOutEntityTeleport(me);
        entity.getLocation().getWorld().getNearbyEntities(entity.getLocation(), 32.0, 32.0, 32.0).forEach(e -> {
            if (e instanceof Player) {
                ((CraftPlayer)e).getHandle().b.a((Packet)tp);
            }
        });
    }

    @Override
    public void setEntityRotation(AbstractEntity target, float pitch, float yaw) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        me.f(yaw);
        me.r(yaw);
        me.s(yaw);
        me.e(pitch);
    }

    @Override
    public void setArmorStandNoGravity(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        if (entity.getType() == EntityType.ARMOR_STAND) {
            EntityArmorStand as = (EntityArmorStand)((CraftEntity)entity).getHandle();
            as.e(true);
        }
    }

    @Override
    public void sendGameStateChange(AbstractPlayer target, int state, int skybox) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutGameStateChange packet = new PacketPlayOutGameStateChange(new PacketPlayOutGameStateChange.a(state), (float)skybox);
        ((CraftPlayer)player).getHandle().b.a((Packet)packet);
    }

    @Override
    public void forcePlayCredits(AbstractPlayer target, float f) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.b.a((Packet)new PacketPlayOutGameStateChange(new PacketPlayOutGameStateChange.a(4), f));
    }

    @Override
    public void forceCloseWindow(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.b.a((Packet)new PacketPlayOutCloseWindow(0));
    }

    @Override
    public void setPlayerWorldBorder(AbstractPlayer target, AbstractLocation center, int radius) {
        WorldBorder border;
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        if (radius == -1) {
            border = ep.x().p_();
        } else {
            border = new WorldBorder();
            border.world = ep.x().p_().world;
            border.c(center.getX(), center.getZ());
            border.a((double)radius);
            border.c(1);
        }
        ep.b.a((Packet)new ClientboundSetBorderCenterPacket(border));
        ep.b.a((Packet)new ClientboundSetBorderWarningDistancePacket(border));
        ep.b.a((Packet)new ClientboundSetBorderSizePacket(border));
    }

    @Override
    public void sendPlayerFakeInventoryItem(AbstractPlayer target, ItemStack stack, int slot) {
        if (slot < 9) {
            slot += 36;
        }
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy((ItemStack)stack);
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(0, 0, slot, item);
        entityPlayer.b.a((Packet)packet);
    }

    public void hideEntityModel(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        DataWatcher w = me.aj();
        w.b(new DataWatcherObject(0, DataWatcherRegistry.a), (Object)32);
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(me.af(), w.c());
    }

    @Override
    public void playTotemEffect(AbstractPlayer target, int model) {
        this.sendPlayerFakeInventoryItem(target, ItemFactory.of(Material.TOTEM_OF_UNDYING).model(model).build(), 45);
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        PacketPlayOutEntityStatus packet = new PacketPlayOutEntityStatus((net.minecraft.world.entity.Entity)me, 35);
        me.b.a((Packet)packet);
        player.stopSound(Sound.ITEM_TOTEM_USE, SoundCategory.MASTER);
        Schedulers.async().runLater(() -> this.sendPlayerFakeInventoryItem(target, player.getInventory().getItemInOffHand(), 45), 1L);
    }

    @Override
    public void setEntitySpawnReason(AbstractEntity target, CreatureSpawnEvent.SpawnReason reason) {
        Entity entity = BukkitAdapter.adapt(target);
        World world = BukkitAdapter.adapt(target.getWorld());
        net.minecraft.world.entity.Entity entityHandle = ((CraftEntity)entity).getHandle();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        worldHandle.addFreshEntity(entityHandle, reason);
    }

    @Override
    public void playFreezeEffect(AbstractPlayer target, int ticks) {
        Player player = (Player)target.getBukkitEntity();
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.j(ticks);
        me.b.a((Packet)new PacketPlayOutEntityMetadata(me.af(), me.aj().c()));
    }

    @Override
    public void playEntityAnimation(AbstractEntity target, byte effect, Collection<AbstractPlayer> audience) {
        net.minecraft.world.entity.Entity e = ((CraftEntity)target.getBukkitEntity()).getHandle();
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation(e, (int)effect);
        for (AbstractPlayer entity : audience) {
            if (!entity.isPlayer()) continue;
            Player player = (Player)entity.getBukkitEntity();
            EntityPlayer me = ((CraftPlayer)player).getHandle();
            me.b.a((Packet)packet);
        }
    }

    @Override
    public double getPassengerRidingOffset(AbstractEntity entity) {
        Entity bukkitEntity = entity.getBukkitEntity();
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        return nmsEntity.bv();
    }

    @Override
    public Collection<AbstractPlayer> getTrackedPlayers(AbstractEntity entity) {
        Entity bukkitEntity = entity.getBukkitEntity();
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        WorldServer level = (WorldServer)nmsEntity.Y();
        Int2ObjectMap map = level.k().a.L;
        PlayerChunkMap.EntityTracker tracker = (PlayerChunkMap.EntityTracker)map.get(nmsEntity.af());
        if (tracker == null) {
            return Collections.emptyList();
        }
        ArrayList players = Lists.newArrayList();
        for (ServerPlayerConnection nmsPlayer : tracker.f) {
            players.add(BukkitAdapter.adapt((Player)nmsPlayer.f().getBukkitEntity()));
        }
        return players;
    }

    @Override
    public boolean isUsingSpyglass(AbstractPlayer player) {
        Entity bukkitPlayer = player.getBukkitEntity();
        CraftPlayer craftPlayer = (CraftPlayer)bukkitPlayer;
        EntityPlayer nmsPlayer = craftPlayer.getHandle();
        return nmsPlayer.gh();
    }

    @Override
    public void spawnFakeLightning(AbstractLocation target, double radius) {
        Location location = BukkitAdapter.adapt(target);
        World world = location.getWorld();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        EntityLightning entitylightning = (EntityLightning)EntityTypes.ai.a((net.minecraft.world.level.World)worldHandle);
        entitylightning.a(Vec3D.b((BaseBlockPosition)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        entitylightning.a(true);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entitylightning);
        double distanceSquared = radius * radius;
        Schedulers.async().run(() -> {
            for (Player player : location.getWorld().getPlayers()) {
                if (!(location.distanceSquared(player.getLocation()) <= distanceSquared)) continue;
                ((CraftPlayer)player).getHandle().b.a((Packet)spawnItem);
                player.playSound(location, "entity.lightning_bolt.impact", 1.0f, 1.0f);
                player.playSound(location, "entity.lightning_bolt.thunder", 10000.0f, 63.0f);
            }
        });
    }

    @Override
    public AbstractEntity addNBTData(AbstractEntity entity, String key, Tag value) {
        CompoundTag compound = this.getNBTData(entity).createBuilder().put(key, value).build();
        this.setNBTData(entity, compound);
        return entity;
    }

    @Override
    public CompoundTag getNBTData(AbstractEntity entity) {
        Entity bukkitEntity = entity.getBukkitEntity();
        NBTTagCompound compound = new NBTTagCompound();
        return VolatileCompoundTag.fromNMSTag(compound);
    }

    @Override
    public AbstractEntity setNBTData(AbstractEntity entity, CompoundTag compoundTag) {
        Entity bukkitEntity = entity.getBukkitEntity();
        return entity;
    }

    @Override
    public void sendActionBarMessageToPlayer(AbstractPlayer target, String message) {
        Player player = BukkitAdapter.adapt(target);
    }
}

