/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.worlds;

import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.serialization.WrappedJsonFile;
import io.lumine.mythic.core.SerializingComponent;
import io.lumine.mythic.core.worlds.WorldData;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WorldManager
extends SerializingComponent {
    protected Map<String, WrappedJsonFile<WorldData>> worldData;

    public WorldManager(MythicBukkit core) {
        super(core);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.worldData = new ConcurrentHashMap<String, WrappedJsonFile<WorldData>>();
        for (File file : this.getModuleFiles("worlds")) {
            if (!file.getName().endsWith(".json")) continue;
            try {
                String worldName = file.getName().split("\\.")[0];
                WrappedJsonFile<WorldData> loaded = this.loadFile(file, WorldData.class);
                if (loaded == null) continue;
                this.worldData.put(worldName, loaded);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void unload() {
        this.worldData.forEach((uuid, file) -> {
            if (file == null) {
                return;
            }
            ((WorldData)file.get()).getVariables().unload();
            file.save();
        });
    }

    public WorldData getWorldData(AbstractWorld world) {
        if (!this.worldData.containsKey(world.getName())) {
            WrappedJsonFile<WorldData> f = new WrappedJsonFile<WorldData>(this, new File(this.getBasedir(), "worlds/" + world.getName() + ".json"), new WorldData(world));
            this.worldData.put(world.getName(), f);
        }
        return this.worldData.get(world.getName()).get();
    }

    public void saveAll() {
        this.worldData.forEach((uuid, file) -> {
            if (file == null || file.get() == null) {
                return;
            }
            ((WorldData)file.get()).getVariables().clean();
            file.save();
        });
    }
}

