/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.structurevoidtoggle.behaviors;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.structurevoidtoggle.behaviors.ShapeInterface;
import com.telepathicgrunt.structurevoidtoggle.mixin.StructureVoidBlockAccessor;
import com.telepathicgrunt.structurevoidtoggle.mixin.client.LevelRendererAccessor;
import java.util.HashMap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ToggleBehavior {
    public static STRUCTURE_BLOCK_MODE MODE = STRUCTURE_BLOCK_MODE.DEFAULT;
    public static boolean VISIBLE = true;
    public static boolean FORCED_RENDERING = false;
    public static boolean FORCED_NON_REPLACEABLE = false;
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_TOGGLE = new KeyMapping("key.structure_void", 96, "key.categories.structure_void_toggle");
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_RENDER_TOGGLE = new KeyMapping("key.structure_void_render", 260, "key.categories.structure_void_toggle");
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_FORCED_RENDER_TOGGLE = new KeyMapping("key.forced_render", 261, "key.categories.structure_void_toggle");
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_NON_REPLACING_TOGGLE = new KeyMapping("key.non_replacing", 266, "key.categories.structure_void_toggle");

    public static void toggle(int key) {
        if (KEY_BIND_STRUCTURE_VOID_TOGGLE.m_90857_()) {
            ToggleBehavior.toggleHitbox();
        }
        if (KEY_BIND_STRUCTURE_VOID_RENDER_TOGGLE.m_90857_()) {
            ToggleBehavior.toggleRender();
        }
        if (KEY_BIND_STRUCTURE_VOID_FORCED_RENDER_TOGGLE.m_90857_()) {
            ToggleBehavior.toggleForcedRender();
        }
        if (KEY_BIND_STRUCTURE_VOID_NON_REPLACING_TOGGLE.m_90857_()) {
            ToggleBehavior.toggleNonReplaceable();
        }
    }

    private static void toggleHitbox() {
        MODE = MODE.next();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        switch (MODE) {
            case DEFAULT: {
                player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.default_hitbox"), true);
                StructureVoidBlockAccessor.setSHAPE(Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                ((ShapeInterface)Blocks.f_50375_).setShape(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)Blocks.f_152480_).setShape(Block.m_49796_((double)-2.0, (double)-2.0, (double)-2.0, (double)-1.0, (double)-1.0, (double)-1.0));
                break;
            }
            case NO_HITBOX: {
                player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.no_hitbox"), true);
                StructureVoidBlockAccessor.setSHAPE(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                ((ShapeInterface)Blocks.f_50375_).setShape(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                ((ShapeInterface)Blocks.f_152480_).setShape(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                break;
            }
            case SMALL_HITBOX: {
                player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.small_hitbox"), true);
                StructureVoidBlockAccessor.setSHAPE(Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                ((ShapeInterface)Blocks.f_50375_).setShape(Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                ((ShapeInterface)Blocks.f_152480_).setShape(Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                break;
            }
            case FULL_HITBOX: {
                player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.full_hitbox"), true);
                StructureVoidBlockAccessor.setSHAPE(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)Blocks.f_50375_).setShape(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)Blocks.f_152480_).setShape(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                break;
            }
        }
    }

    private static void toggleRender() {
        VISIBLE = !VISIBLE;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (VISIBLE) {
            player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.structure_block_visible"), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.structure_block_invisible"), true);
        }
    }

    private static void toggleForcedRender() {
        FORCED_RENDERING = !FORCED_RENDERING;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (FORCED_RENDERING) {
            player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.invisible_blocks_forced_render"), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.invisible_blocks_disabled_forced_render"), true);
        }
    }

    private static void toggleNonReplaceable() {
        FORCED_NON_REPLACEABLE = !FORCED_NON_REPLACEABLE;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (FORCED_NON_REPLACEABLE) {
            player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.invisible_blocks_non_replaceable"), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"system.structure_void_toggle.invisible_blocks_replaceable"), true);
        }
    }

    public static void forceRenderInvisibleBlocks(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS && FORCED_RENDERING) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Level level = player.m_9236_();
            float drawRadius = MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX ? 0.4f : 0.05f;
            float minCorner = 0.5f - drawRadius;
            float maxCorner = 0.5f + drawRadius;
            Vector4f vector4fMin = new Vector4f(minCorner, minCorner, minCorner, 1.0f);
            Vector4f vector4fMax = new Vector4f(maxCorner, maxCorner, maxCorner, 1.0f);
            int radius = 40;
            Vec3 cameraPos = event.getCamera().m_90583_();
            BlockPos centerPos = BlockPos.m_274446_((Position)cameraPos);
            HashMap<ChunkPos, Boolean> chunkAllowedMap = new HashMap<ChunkPos, Boolean>();
            BlockPos.MutableBlockPos worldSpot = new BlockPos.MutableBlockPos();
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            Tesselator tesselator = Tesselator.m_85913_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            if (MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX) {
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            } else {
                bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            }
            int radiusSq = radius * radius;
            for (int x = -radius; x <= radius; ++x) {
                block1: for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        boolean flag4;
                        int distSq = x * x + y * y + z * z;
                        if (distSq > radiusSq) continue;
                        worldSpot.m_122178_(centerPos.m_123341_() + x, centerPos.m_123342_() + y, centerPos.m_123343_() + z);
                        ChunkPos chunkPos = new ChunkPos((BlockPos)worldSpot);
                        boolean isValidChunk = chunkAllowedMap.computeIfAbsent(chunkPos, c -> {
                            for (LevelChunkSection levelChunkSection : level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_7103_()) {
                                if (!levelChunkSection.m_63019_().m_63109_(b -> b.m_60713_(Blocks.f_50454_) || b.m_60713_(Blocks.f_50375_) || b.m_60713_(Blocks.f_152480_))) continue;
                                return true;
                            }
                            return false;
                        });
                        if (!isValidChunk) {
                            z = ((worldSpot.m_123343_() >> 4) + 1 << 4) - 1 - centerPos.m_123343_();
                            continue block1;
                        }
                        if (!((LevelRendererAccessor)event.getLevelRenderer()).getCullingFrustum().m_113029_(new AABB((double)((float)worldSpot.m_123341_() + minCorner), (double)((float)worldSpot.m_123342_() + minCorner), (double)((float)worldSpot.m_123343_() + minCorner), (double)((float)worldSpot.m_123341_() + maxCorner), (double)((float)worldSpot.m_123342_() + maxCorner), (double)((float)worldSpot.m_123343_() + maxCorner)))) continue;
                        BlockState blockstate = level.m_8055_((BlockPos)worldSpot);
                        boolean flag1 = blockstate.m_60713_(Blocks.f_50454_);
                        boolean flag2 = blockstate.m_60713_(Blocks.f_50375_);
                        boolean flag3 = blockstate.m_60713_(Blocks.f_152480_);
                        boolean bl = flag4 = flag1 || flag2 || flag3;
                        if (!flag4) continue;
                        int red = 255;
                        int green = 255;
                        int blue = 255;
                        int alpha = 255;
                        if (flag1) {
                            green = 190;
                            blue = 190;
                        } else if (flag2) {
                            green = 0;
                            blue = 0;
                        } else if (flag3) {
                            blue = 0;
                        }
                        if (MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX) {
                            float distanceMult = Math.max(1.0f - (float)distSq * 6.0f / (float)radiusSq, 0.5f);
                            ToggleBehavior.renderQuadBox(bufferbuilder, poseStack.m_85850_().m_252922_(), vector4fMin.x() + (float)worldSpot.m_123341_(), vector4fMin.y() + (float)worldSpot.m_123342_(), vector4fMin.z() + (float)worldSpot.m_123343_(), vector4fMax.x() + (float)worldSpot.m_123341_(), vector4fMax.y() + (float)worldSpot.m_123342_(), vector4fMax.z() + (float)worldSpot.m_123343_(), (int)((float)red * distanceMult), (int)((float)green * distanceMult), (int)((float)blue * distanceMult), alpha);
                            continue;
                        }
                        ToggleBehavior.renderLineBox(bufferbuilder, poseStack.m_85850_().m_252922_(), vector4fMin.x() + (float)worldSpot.m_123341_(), vector4fMin.y() + (float)worldSpot.m_123342_(), vector4fMin.z() + (float)worldSpot.m_123343_(), vector4fMax.x() + (float)worldSpot.m_123341_(), vector4fMax.y() + (float)worldSpot.m_123342_(), vector4fMax.z() + (float)worldSpot.m_123343_(), red, green, blue, alpha);
                    }
                }
            }
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
    }

    private static void renderQuadBox(BufferBuilder builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue, int alpha) {
        builder.m_252986_(pose, maxX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void renderLineBox(BufferBuilder builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue, int alpha) {
        builder.m_252986_(pose, minX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, minX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_252986_(pose, minX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, minY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, minZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, maxX, maxY, maxZ).m_6122_(red, green, blue, alpha).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static enum STRUCTURE_BLOCK_MODE {
        DEFAULT,
        NO_HITBOX,
        SMALL_HITBOX,
        FULL_HITBOX;


        public STRUCTURE_BLOCK_MODE next() {
            if (this.ordinal() + 1 == STRUCTURE_BLOCK_MODE.values().length) {
                return STRUCTURE_BLOCK_MODE.values()[0];
            }
            return STRUCTURE_BLOCK_MODE.values()[this.ordinal() + 1];
        }
    }
}

