/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.entrypoint;

import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.entrypoint.EntrypointContainer;
import dev.yumi.mc.core.api.entrypoint.EntrypointException;
import dev.yumi.mc.core.impl.entrypoint.EntrypointCandidate;
import dev.yumi.mc.core.impl.entrypoint.EntrypointStorage;
import dev.yumi.mc.core.impl.mod.ExtendedModContainer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class CommonEntrypointStorage
implements EntrypointStorage {
    private final Map<String, List<Entry>> entrypoints = new HashMap<String, List<Entry>>();

    public CommonEntrypointStorage(List<ExtendedModContainer> mods) {
        HashMap<String, Map> collectingEntrypoints = new HashMap<String, Map>();
        for (ExtendedModContainer mod : mods) {
            for (Map.Entry<String, List<EntrypointCandidate>> entry : mod.getEntrypoints().entrySet()) {
                Map storage = collectingEntrypoints.computeIfAbsent(entry.getKey(), k -> new HashMap());
                for (EntrypointCandidate candidate : entry.getValue()) {
                    storage.put(candidate.value(), new Entry(mod, candidate));
                }
            }
        }
        collectingEntrypoints.forEach((key, entries) -> this.entrypoints.put((String)key, entries.values().stream().toList()));
    }

    @Override
    public <T> List<EntrypointContainer<T>> getEntrypoints(String key, Class<T> type) {
        ArrayList<EntrypointContainer<T>> containers = new ArrayList<EntrypointContainer<T>>();
        List entrypoints = this.entrypoints.getOrDefault(key, List.of());
        EntrypointException error = null;
        for (Entry entry : entrypoints) {
            try {
                containers.add(new EntrypointContainer<T>(entry.mod, entry.resolve(key, type)));
            }
            catch (IllegalArgumentException e) {
                EntrypointException newError = new EntrypointException(key, entry.mod.id(), e);
                if (error == null) {
                    error = newError;
                    continue;
                }
                error.addSuppressed(newError);
            }
        }
        if (error != null) {
            throw error;
        }
        return containers;
    }

    private record Entry(ModContainer mod, EntrypointCandidate entrypoint) {
        public <T> T resolve(String key, Class<T> type) {
            MethodHandle handle;
            Class<?> c;
            String value = this.entrypoint.value();
            String[] methodSplit = value.split("::");
            if (methodSplit.length >= 3) {
                throw new IllegalArgumentException("Invalid handle format: " + value);
            }
            try {
                c = Class.forName(methodSplit[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            if (methodSplit.length == 1) {
                if (type.isAssignableFrom(c)) {
                    try {
                        return (T)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                throw new IllegalArgumentException("Class " + c.getName() + " cannot be cast to " + type.getName() + "!");
            }
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (Method m : c.getDeclaredMethods()) {
                if (!m.getName().equals(methodSplit[1])) continue;
                methodList.add(m);
            }
            try {
                Field field = c.getDeclaredField(methodSplit[1]);
                Class<?> fType = field.getType();
                if ((field.getModifiers() & 8) == 0) {
                    throw new IllegalArgumentException("Field " + value + " must be static!");
                }
                if (!methodList.isEmpty()) {
                    throw new IllegalArgumentException("Ambiguous " + value + " - refers to both field and method!");
                }
                if (!type.isAssignableFrom(fType)) {
                    throw new IllegalArgumentException("Field " + value + " cannot be cast to " + type.getName() + "!");
                }
                return (T)field.get(null);
            }
            catch (NoSuchFieldException field) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Field " + value + " cannot be accessed!", e);
            }
            if (!type.isInterface()) {
                throw new IllegalArgumentException("Cannot proxy method " + value + " to non-interface type " + type.getName() + "!");
            }
            if (methodList.isEmpty()) {
                throw new IllegalArgumentException("Could not find " + value + "!");
            }
            if (methodList.size() >= 2) {
                throw new IllegalArgumentException("Found multiple method entries of name " + value + "!");
            }
            Method targetMethod = (Method)methodList.get(0);
            Object object = null;
            if ((targetMethod.getModifiers() & 8) == 0) {
                try {
                    object = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            try {
                handle = MethodHandles.lookup().unreflect(targetMethod);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
            if (object != null) {
                handle = handle.bindTo(object);
            }
            try {
                return MethodHandleProxies.asInterfaceInstance(type, handle);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

