/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.mod;

import com.mojang.logging.LogUtils;
import dev.yumi.mc.core.api.metadata.ManifestCustomValue;
import dev.yumi.mc.core.impl.entrypoint.EntrypointCandidate;
import dev.yumi.mc.core.impl.mod.ExtendedModContainer;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
abstract class AbstractModContainer
implements ExtendedModContainer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, List<EntrypointCandidate>> entrypoints = new HashMap<String, List<EntrypointCandidate>>();
    private final ManifestCustomValue.ObjectValue customProperties;

    protected AbstractModContainer(ManifestCustomValue.ObjectValue customProperties) {
        this.customProperties = customProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readEntrypoints() {
        Object map;
        ManifestCustomValue<?> value = this.customProperties.get("yumi:entrypoints");
        if (value == null) {
            return;
        }
        if (!(value instanceof ManifestCustomValue.ObjectValue)) {
            LOGGER.warn("Yumi-managed entrypoints for mod {} cannot be read: `yumi:entrypoints` custom value is not an object.", (Object)this.id());
            return;
        }
        ManifestCustomValue.ObjectValue objectValue = (ManifestCustomValue.ObjectValue)value;
        try {
            Object object;
            map = object = objectValue.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        map.forEach(this::readEntrypoints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readEntrypoints(String key, ManifestCustomValue<?> data) {
        if (!(data instanceof ManifestCustomValue.ArrayValue)) {
            EntrypointCandidate entrypoint = this.readEntrypoint(key, data);
            if (entrypoint == null) return;
            this.entrypoints.put(key, List.of(entrypoint));
            return;
        }
        ManifestCustomValue.ArrayValue arrayValue = (ManifestCustomValue.ArrayValue)data;
        try {
            Object object;
            Object rawEntrypoints = object = arrayValue.value();
            this.entrypoints.put(key, rawEntrypoints.stream().map(entry -> this.readEntrypoint(key, (ManifestCustomValue<?>)entry)).filter(Objects::nonNull).toList());
            return;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EntrypointCandidate readEntrypoint(String key, ManifestCustomValue<?> data) {
        ManifestCustomValue<?> manifestCustomValue = data;
        Objects.requireNonNull(manifestCustomValue);
        ManifestCustomValue<?> manifestCustomValue2 = manifestCustomValue;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ManifestCustomValue.ObjectValue.class, ManifestCustomValue.StringValue.class}, manifestCustomValue2, n)) {
            case 0: {
                String string;
                ManifestCustomValue.ObjectValue object = (ManifestCustomValue.ObjectValue)manifestCustomValue2;
                ManifestCustomValue<?> value = object.get("value");
                if (value == null) {
                    LOGGER.warn("Yumi-managed entrypoint {} for mod {} is missing `value` entry in object.", (Object)key, (Object)this.id());
                    return null;
                }
                if (!(value instanceof ManifestCustomValue.StringValue)) {
                    LOGGER.warn("Yumi-managed entrypoint {} for mod {} has a non-string `value` entry.", (Object)key, (Object)this.id());
                    return null;
                }
                ManifestCustomValue.StringValue stringValue = (ManifestCustomValue.StringValue)value;
                try {
                    String string2;
                    string = string2 = stringValue.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                EntrypointCandidate entrypointCandidate = new EntrypointCandidate(string);
                return entrypointCandidate;
            }
            case 1: {
                EntrypointCandidate entrypointCandidate;
                ManifestCustomValue.StringValue stringValue = (ManifestCustomValue.StringValue)manifestCustomValue2;
                {
                    String string;
                    String string3 = string = stringValue.value();
                    entrypointCandidate = new EntrypointCandidate(string3);
                    return entrypointCandidate;
                }
            }
        }
        LOGGER.warn("Yumi-managed entrypoint {} of mod {} is not valid.", (Object)key, (Object)this.id());
        return null;
    }

    @Override
    public ManifestCustomValue.ObjectValue getCustomProperties() {
        return this.customProperties;
    }

    @Override
    public Map<String, List<EntrypointCandidate>> getEntrypoints() {
        return this.entrypoints;
    }
}

