/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.mod;

import com.electronwill.nightconfig.core.Config;
import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.metadata.ManifestCustomValue;
import dev.yumi.mc.core.impl.mod.AbstractModContainer;
import dev.yumi.mc.core.impl.mod.ExtendedModContainer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class NeoModContainer
extends AbstractModContainer {
    private final IModInfo modInfo;

    public NeoModContainer(IModInfo modInfo) {
        super(NeoModContainer.mapObjectCustomValue(modInfo.getModProperties()));
        this.modInfo = modInfo;
        this.readEntrypoints();
    }

    @Override
    @NotNull
    public String id() {
        return this.modInfo.getModId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.modInfo.getDisplayName();
    }

    @Override
    @NotNull
    public String getVersionString() {
        return this.modInfo.getVersion().toString();
    }

    @Override
    @NotNull
    public Optional<Path> findPath(String first, String ... more) {
        String[] pathParts = new String[more.length + 1];
        pathParts[0] = first;
        System.arraycopy(more, 0, pathParts, 1, more.length);
        Path path = this.modInfo.getOwningFile().getFile().findResource(pathParts);
        if (path == null) {
            return Optional.empty();
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(path);
    }

    @Override
    @NotNull
    public Optional<ModContainer> getContainingMod() {
        return Optional.empty();
    }

    @Override
    public @Unmodifiable Collection<ModContainer> getContainedMods() {
        return List.of();
    }

    @Override
    public @Unmodifiable Collection<String> getProvidedIds() {
        return List.of();
    }

    public static void init(List<ExtendedModContainer> mods) {
        LoadingModList.get().getMods().forEach(mod -> mods.add(new NeoModContainer((IModInfo)mod)));
    }

    private static ManifestCustomValue<?> mapCustomValue(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Config.class, Map.class, List.class, String.class, Number.class, Boolean.class}, (Object)object2, n)) {
            case 0 -> {
                Config object = (Config)object2;
                yield NeoModContainer.mapObjectCustomValue(object.valueMap());
            }
            case 1 -> {
                Map map = (Map)object2;
                yield NeoModContainer.mapObjectCustomValue(map);
            }
            case 2 -> {
                List list = (List)object2;
                yield new ManifestCustomValue.ArrayValue(list.stream().map(NeoModContainer::mapCustomValue).toList());
            }
            case 3 -> {
                String string = (String)object2;
                yield new ManifestCustomValue.StringValue(string);
            }
            case 4 -> {
                Number number = (Number)object2;
                yield new ManifestCustomValue.NumberValue(number);
            }
            case 5 -> {
                Boolean bool = (Boolean)object2;
                yield new ManifestCustomValue.BooleanValue(bool);
            }
            default -> null;
        };
    }

    private static ManifestCustomValue.ObjectValue mapObjectCustomValue(Map<String, Object> value) {
        record Entry(String key, ManifestCustomValue<?> value) {
        }
        Map<String, ManifestCustomValue> map = value.entrySet().stream().map(entry -> new Entry((String)entry.getKey(), NeoModContainer.mapCustomValue(entry.getValue()))).filter(entry -> entry.value != null).collect(Collectors.toMap(Entry::key, Entry::value));
        return new ManifestCustomValue.ObjectValue(Collections.unmodifiableMap(map));
    }
}

