/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.option;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceBooleanOption;
import dev.lambdaurora.spruceui.option.SpruceCheckboxBooleanOption;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleInputOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleOption;
import dev.lambdaurora.spruceui.option.SpruceFloatInputOption;
import dev.lambdaurora.spruceui.option.SpruceIntegerInputOption;
import dev.lambdaurora.spruceui.option.SpruceToggleBooleanOption;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.tooltip.Tooltipable;
import dev.lambdaurora.spruceui.util.Nameable;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public abstract class SpruceOption
implements Nameable,
Tooltipable {
    public final String key;
    private TooltipData tooltip = TooltipData.EMPTY;

    public SpruceOption(String key) {
        Objects.requireNonNull(key, "Cannot create an option without a key.");
        this.key = key;
    }

    @Override
    public String getName() {
        return class_1074.method_4662((String)this.key, (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public TooltipData getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(@NotNull TooltipData tooltip) {
        Objects.requireNonNull(tooltip, "Tooltip cannot be null, the absence of a tooltip is represented by TooltipData.EMPTY.");
        this.tooltip = tooltip;
    }

    public class_2561 getPrefix() {
        return class_2561.method_43471((String)this.key);
    }

    public class_2561 getDisplayText(class_2561 value) {
        return class_2561.method_43469((String)"spruceui.options.generic", (Object[])new Object[]{this.getPrefix(), value});
    }

    public abstract SpruceWidget createWidget(Position var1, int var2);

    public static SpruceBooleanOption.Builder booleanBuilder(String key, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return new SpruceBooleanOption.Builder(key, getter, setter);
    }

    public static SpruceCheckboxBooleanOption.Builder checkboxBuilder(String key, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return new SpruceCheckboxBooleanOption.Builder(key, getter, setter);
    }

    public static SpruceCyclingOption.Builder cyclingBuilder(String key, Consumer<Integer> setter, Function<SpruceCyclingOption, class_2561> messageProvider) {
        return new SpruceCyclingOption.Builder(key, setter, messageProvider);
    }

    public static SpruceDoubleOption.Builder doubleBuilder(String key, double min, double max, float step, Supplier<Double> getter, Consumer<Double> setter, Function<SpruceDoubleOption, class_2561> displayStringGetter) {
        return new SpruceDoubleOption.Builder(key, min, max, step, getter, setter, displayStringGetter);
    }

    public static SpruceDoubleInputOption.Builder doubleInputBuilder(String key, Supplier<Double> getter, Consumer<Double> setter) {
        return new SpruceDoubleInputOption.Builder(key, getter, setter);
    }

    public static SpruceFloatInputOption.Builder floatInputBuilder(String key, Supplier<Float> getter, Consumer<Float> setter) {
        return new SpruceFloatInputOption.Builder(key, getter, setter);
    }

    public static SpruceIntegerInputOption.Builder intInputBuilder(String key, Supplier<Integer> getter, Consumer<Integer> setter) {
        return new SpruceIntegerInputOption.Builder(key, getter, setter);
    }

    public static SpruceToggleBooleanOption.Builder toggleBuilder(String key, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return new SpruceToggleBooleanOption.Builder(key, getter, setter);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends SpruceOption> {
        protected final String key;
        protected TooltipData tooltip = TooltipData.EMPTY;

        public Builder(String key) {
            this.key = key;
        }

        public B tooltip(@NotNull class_2561 tooltip) {
            return this.tooltip(new TooltipData(new TooltipData.TextEntry(tooltip)));
        }

        public B tooltip(@NotNull TooltipData tooltip) {
            this.tooltip = tooltip;
            return this.self();
        }

        protected abstract B self();

        public abstract T build();
    }
}

