/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.container;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.navigation.NavigationEvent;
import dev.lambdaurora.spruceui.navigation.NavigationUtils;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceEntryListWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8027;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpruceOptionListWidget
extends SpruceEntryListWidget<OptionEntry> {
    private int lastIndex = 0;

    public SpruceOptionListWidget(Position position, int width, int height) {
        super(position, width, height, 4, OptionEntry.class);
    }

    public int addSingleOptionEntry(SpruceOption option) {
        return this.addEntry(OptionEntry.create(this, option, false));
    }

    public int addSmallSingleOptionEntry(SpruceOption option) {
        return this.addEntry(OptionEntry.create(this, option, true));
    }

    public void addOptionEntry(SpruceOption firstOption, @Nullable SpruceOption secondOption) {
        this.addEntry(OptionEntry.create(this, firstOption, secondOption));
    }

    public void addAll(SpruceOption[] options) {
        for (int i = 0; i < options.length; i += 2) {
            this.addOptionEntry(options[i], i < options.length - 1 ? options[i + 1] : null);
        }
    }

    @Override
    public void method_37020(class_6382 builder) {
        this.children().stream().filter(AbstractSpruceWidget::isMouseHovered).findFirst().ifPresentOrElse(hoveredEntry -> {
            hoveredEntry.method_37020(builder.method_37031());
            this.appendPositionNarrations(builder, hoveredEntry);
        }, () -> {
            OptionEntry focusedEntry = (OptionEntry)this.getFocused();
            if (focusedEntry != null) {
                focusedEntry.method_37020(builder.method_37031());
                this.appendPositionNarrations(builder, focusedEntry);
            }
        });
        builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
    }

    public static class OptionEntry
    extends SpruceEntryListWidget.Entry
    implements SpruceParentWidget<SpruceWidget> {
        private final List<SpruceWidget> children = new ArrayList<SpruceWidget>();
        private final SpruceOptionListWidget parent;
        @Nullable
        private SpruceWidget focused;
        private boolean dragging;

        private OptionEntry(SpruceOptionListWidget parent) {
            this.parent = parent;
        }

        public static OptionEntry create(SpruceOptionListWidget parent, SpruceOption option, boolean small) {
            OptionEntry entry = new OptionEntry(parent);
            entry.children.add(option.createWidget(Position.of(entry, entry.getWidth() / 2 - (small ? 75 : 155), 2), small ? 150 : 310));
            return entry;
        }

        public static OptionEntry create(SpruceOptionListWidget parent, SpruceOption firstOption, @Nullable SpruceOption secondOption) {
            OptionEntry entry = new OptionEntry(parent);
            entry.children.add(firstOption.createWidget(Position.of(entry, entry.getWidth() / 2 - 155, 2), 150));
            if (secondOption != null) {
                entry.children.add(secondOption.createWidget(Position.of(entry, entry.getWidth() / 2 - 155 + 160, 2), 150));
            }
            return entry;
        }

        @Override
        public int getWidth() {
            return this.parent.getWidth() - this.parent.getBorder().getThickness() * 2;
        }

        @Override
        public int getHeight() {
            return this.children.stream().mapToInt(SpruceWidget::getHeight).reduce(Integer::max).orElse(0) + 4;
        }

        @Override
        public List<SpruceWidget> children() {
            return this.children;
        }

        @Override
        @Nullable
        public SpruceWidget getFocused() {
            return this.focused;
        }

        @Override
        public void setFocused(@Nullable SpruceWidget focused) {
            if (this.focused == focused) {
                return;
            }
            if (this.focused != null) {
                this.focused.method_25365(false);
            }
            this.focused = focused;
        }

        @Override
        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (!focused) {
                this.setFocused(null);
            }
        }

        @Override
        protected boolean onMouseClick(@NotNull class_11909 event, boolean doubleClick) {
            SpruceWidget element;
            Iterator it = this.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!(element = (SpruceWidget)it.next()).method_25402(event, doubleClick));
            this.setFocused(element);
            if (event.method_74245() == 0) {
                this.dragging = true;
            }
            return true;
        }

        @Override
        protected boolean onMouseRelease(@NotNull class_11909 event) {
            this.dragging = false;
            return this.hoveredElement(event.comp_4798(), event.comp_4799()).filter(element -> element.method_25406(event)).isPresent();
        }

        @Override
        protected boolean onMouseDrag(@NotNull class_11909 event, double deltaX, double deltaY) {
            return this.getFocused() != null && this.dragging && event.method_74245() == 0 && this.getFocused().method_25403(event, deltaX, deltaY);
        }

        @Override
        protected boolean onKeyPress(@NotNull class_11908 event) {
            return this.focused != null && this.focused.method_25404(event);
        }

        @Override
        protected boolean onKeyRelease(@NotNull class_11908 event) {
            return this.focused != null && this.focused.method_16803(event);
        }

        @Override
        protected boolean onCharTyped(@NotNull class_11905 event) {
            return this.focused != null && this.focused.method_25400(event);
        }

        @Override
        protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.forEach(widget -> widget.render(graphics, mouseX, mouseY, delta));
        }

        @Override
        public void method_37020(class_6382 builder) {
            SpruceWidget focused = this.getFocused();
            if (focused != null) {
                focused.method_37020(builder);
            }
        }

        @Override
        public boolean onNavigation(@NotNull NavigationEvent event) {
            if (this.requiresCursor()) {
                return false;
            }
            if (!event.tab() && event.direction().method_48237() == class_8027.field_41823) {
                if (this.method_25370()) {
                    this.setFocused(null);
                    return false;
                }
                int lastIndex = this.parent.lastIndex;
                if (lastIndex >= this.children.size()) {
                    lastIndex = this.children.size() - 1;
                }
                if (!this.children.get(lastIndex).onNavigation(event)) {
                    return false;
                }
                this.setFocused(this.children.get(lastIndex));
                return true;
            }
            boolean result = NavigationUtils.tryNavigate(event, this.children, this.focused, this::setFocused, true);
            if (result) {
                this.method_25365(true);
                if (event.direction().method_48237() == class_8027.field_41822 && this.getFocused() != null) {
                    this.parent.lastIndex = this.children.indexOf(this.getFocused());
                }
            }
            return result;
        }
    }
}

