/*
 * Decompiled with CFR 0.152.
 */
package net.axay.fabrik.compose.color;

import androidx.compose.runtime.internal.StabilityInferred;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.calculate.DifferenceKt;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBInt;
import com.github.ajalt.colormath.transform.InterpolateKt;
import com.github.ajalt.colormath.transform.PremultiplyKt;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.axay.fabrik.compose.mixin.MaterialColorAccessor;
import net.minecraft.class_3620;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R&\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b0\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b0\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0015\u001a\u00020\u0014*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lnet/axay/fabrik/compose/color/MaterialColorUtils;", "", "Lcom/github/ajalt/colormath/Color;", "color", "", "toMaterialColorId", "(Lcom/github/ajalt/colormath/Color;)B", "", "Lkotlin/Pair;", "Lcom/github/ajalt/colormath/model/LAB;", "materialColorIds", "[Lkotlin/Pair;", "materialColorIdsNoWhite", "Lcom/github/ajalt/colormath/model/RGB;", "white", "Lcom/github/ajalt/colormath/model/RGB;", "whiteMaterialColorId", "B", "getWhiteMaterialColorId", "()B", "", "isNearlyWhite", "(Lcom/github/ajalt/colormath/Color;)Z", "<init>", "()V", "fabrikmc-compose"})
@StabilityInferred(parameters=0)
public final class MaterialColorUtils {
    @NotNull
    public static final MaterialColorUtils INSTANCE;
    @NotNull
    private static final RGB white;
    private static final byte whiteMaterialColorId;
    @NotNull
    private static final Pair<LAB, Byte>[] materialColorIds;
    @NotNull
    private static final Pair<LAB, Byte>[] materialColorIdsNoWhite;
    public static final int $stable;

    private MaterialColorUtils() {
    }

    public final byte getWhiteMaterialColorId() {
        return whiteMaterialColorId;
    }

    public final byte toMaterialColorId(@NotNull Color color) {
        Pair<LAB, Byte> pair;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Color $this$toMaterialColorId_u24lambda_u2d6 = color;
        boolean bl = false;
        Color color2 = $this$toMaterialColorId_u24lambda_u2d6.getAlpha() < 1.0f ? InterpolateKt.interpolate$default((Color)((Color)white), (Color)$this$toMaterialColorId_u24lambda_u2d6, (Number)Float.valueOf($this$toMaterialColorId_u24lambda_u2d6.getAlpha()), (boolean)false, null, (int)12, null) : $this$toMaterialColorId_u24lambda_u2d6;
        Color interpolatedColor = color2;
        if (this.isNearlyWhite(interpolatedColor)) {
            return whiteMaterialColorId;
        }
        Object[] $this$minByOrNull$iv = materialColorIdsNoWhite;
        boolean $i$f$minByOrNull = false;
        if ($this$minByOrNull$iv.length == 0) {
            pair = null;
        } else {
            Object minElem$iv = $this$minByOrNull$iv[0];
            int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$minByOrNull$iv);
            if (lastIndex$iv == 0) {
                pair = minElem$iv;
            } else {
                Pair<LAB, Byte> it = minElem$iv;
                boolean bl2 = false;
                float minValue$iv = DifferenceKt.differenceCIE2000((Color)((Color)it.getFirst()), (Color)interpolatedColor);
                int i$iv = 1;
                if (i$iv <= lastIndex$iv) {
                    while (true) {
                        Object e$iv;
                        Object it2 = e$iv = $this$minByOrNull$iv[i$iv];
                        $i$a$-minByOrNull-MaterialColorUtils$toMaterialColorId$1 = false;
                        float v$iv = DifferenceKt.differenceCIE2000((Color)((Color)it2.getFirst()), (Color)interpolatedColor);
                        if (Float.compare(minValue$iv, v$iv) > 0) {
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        }
                        if (i$iv == lastIndex$iv) break;
                        ++i$iv;
                    }
                }
                pair = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(pair);
        return ((Number)pair.getSecond()).byteValue();
    }

    private final boolean isNearlyWhite(Color $this$isNearlyWhite) {
        return DifferenceKt.differenceCIE2000((Color)$this$isNearlyWhite, (Color)((Color)white)) <= 2.5f;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv;
        ArrayList arrayList;
        INSTANCE = new MaterialColorUtils();
        white = RGBColorSpace.DefaultImpls.invoke$default((RGBColorSpace)((RGBColorSpace)RGB.Companion), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f, (int)8, null);
        whiteMaterialColorId = (byte)(class_3620.field_16022.field_16021 * 4 + 2);
        ArrayList $this$materialColorIds_u24lambda_u2d4 = arrayList = new ArrayList();
        boolean bl = false;
        class_3620[] class_3620Array = MaterialColorAccessor.getMaterialColors();
        Intrinsics.checkNotNullExpressionValue((Object)class_3620Array, (String)"getMaterialColors()");
        Object[] $this$filter$iv = class_3620Array;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            class_3620 it = (class_3620)element$iv$iv;
            boolean bl2 = false;
            if (!(it != null && it.field_16011 != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3620 materialColor = (class_3620)element$iv;
            boolean bl3 = false;
            int n = 4;
            for (int i = 0; i < n; ++i) {
                int n2;
                int it = i;
                boolean bl4 = false;
                switch (it) {
                    case 0: {
                        n2 = 180;
                        break;
                    }
                    case 1: {
                        n2 = 220;
                        break;
                    }
                    case 2: {
                        n2 = 255;
                        break;
                    }
                    case 3: {
                        n2 = 135;
                        break;
                    }
                    default: {
                        String msg$iv = "Unsupported color shade: " + it + " - Will use alpha of 255 as a fallback";
                        boolean $i$f$logWarning = false;
                        LogUtils.getLogger().warn(String.valueOf(msg$iv));
                        n2 = 255;
                    }
                }
                int alphaFromId = n2;
                RGB $this$materialColorIds_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = RGBInt.toSRGB-impl((int)RGBInt.constructor-impl((int)UInt.constructor-impl((int)materialColor.field_16011)));
                boolean bl5 = false;
                LAB realColor = ((RGB)PremultiplyKt.multiplyAlpha((Color)((Color)RGB.Companion.invoke($this$materialColorIds_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.getR(), $this$materialColorIds_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.getG(), $this$materialColorIds_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.getB(), (float)alphaFromId / 255.0f)))).toLAB();
                ((Collection)$this$materialColorIds_u24lambda_u2d4).add(TuplesKt.to((Object)realColor, (Object)((byte)(materialColor.field_16021 * 4 + it))));
            }
        }
        Object $this$toTypedArray$iv = (Pair<LAB, Byte>[])arrayList;
        boolean $i$f$toTypedArray = false;
        Pair<LAB, Byte>[] thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        Pair<LAB, Byte>[] $this$filterNot$iv = materialColorIds = pairArray;
        boolean $i$f$filterNot = false;
        thisCollection$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        int n = ((void)$this$filterNotTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterNotTo$iv$iv[i];
            boolean bl6 = false;
            if (((Number)it.getSecond()).byteValue() == INSTANCE.getWhiteMaterialColorId()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$toTypedArray$iv = (List)class_3620Array;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray2 = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        materialColorIdsNoWhite = pairArray2;
        $stable = 8;
    }
}

