/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.configured;

import com.mrcrayfish.configured.api.IConfigProvider;
import com.mrcrayfish.configured.api.IModConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.ModContainer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.configured.ForgeConfig;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeConfigProvider
implements IConfigProvider {
    public Set<IModConfig> getConfigurationsForMod(ModContainer container) {
        HashSet<IModConfig> configs = new HashSet<IModConfig>();
        ForgeConfigProvider.addForgeConfigSetToMap(container, ModConfig.Type.CLIENT, configs::add);
        ForgeConfigProvider.addForgeConfigSetToMap(container, ModConfig.Type.COMMON, configs::add);
        ForgeConfigProvider.addForgeConfigSetToMap(container, ModConfig.Type.SERVER, configs::add);
        return configs;
    }

    private static void addForgeConfigSetToMap(ModContainer container, ModConfig.Type type, Consumer<IModConfig> consumer) {
        Set<ModConfig> configSet = ForgeConfigProvider.getForgeConfigSets().get((Object)type);
        Set<IModConfig> filteredConfigSets = configSet.stream().filter(config -> config.getModId().equals(container.getMetadata().getId()) && config.getSpec() instanceof ForgeConfigSpec).map(ForgeConfig::new).collect(Collectors.toSet());
        filteredConfigSets.forEach(consumer);
    }

    private static Map<ModConfig.Type, Set<ModConfig>> getForgeConfigSets() {
        return ConfigTracker.INSTANCE.configSets();
    }
}

