/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy.server;

import java.nio.file.Path;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.mixin.accessor.LevelResourceAccessor;

public class ServerLifecycleHooks {
    private static final class_5218 SERVERCONFIG = LevelResourceAccessor.create("serverconfig");

    private static Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.method_27050(SERVERCONFIG);
        FileUtils.getOrCreateDirectory(serverConfig, "server config directory");
        return serverConfig;
    }

    public static void handleServerAboutToStart(MinecraftServer server) {
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
    }

    public static void handleServerStopped(MinecraftServer server) {
        ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
    }
}

