/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import mc.craig.software.angels.client.models.entity.HeadPlacement;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import mc.craig.software.angels.utils.DateChecker;
import mc.craig.software.angels.utils.Pair;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;

public class ModelClassicAngel
extends ListModel<WeepingAngel>
implements IAngelModel,
ArmedModel {
    private final ResourceLocation TEXTURE = new ResourceLocation("weeping_angels", "textures/entities/a_dizzle/angel_classic.png");
    private final ResourceLocation TEXTURE_ANGRY = new ResourceLocation("weeping_angels", "textures/entities/a_dizzle/angel_classic_angry.png");
    private final ResourceLocation TEXTURE_ANGRY_XMAS = new ResourceLocation("weeping_angels", "textures/entities/a_dizzle/angel_classic_angry_xmas.png");
    private final ResourceLocation TEXTURE_XMAS = new ResourceLocation("weeping_angels", "textures/entities/a_dizzle/angel_classic_xmas.png");
    private final ModelPart leftfoot;
    private final ModelPart rightfoot;
    private final ModelPart leftwing1;
    private final ModelPart leftwing2;
    private final ModelPart leftwing3;
    private final ModelPart leftwing4;
    private final ModelPart rightwing1;
    private final ModelPart rightwing2;
    private final ModelPart rightwing3;
    private final ModelPart rightwing4;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private WeepingAngelPose weepingAngelPose = WeepingAngelPose.ANGRY;
    private boolean showHurt = false;
    private Pair<ModelPart, Vector3d> headData;

    public ModelClassicAngel(ModelPart root) {
        this.leftfoot = root.m_171324_("leftfoot");
        this.rightfoot = root.m_171324_("rightfoot");
        this.leftwing1 = root.m_171324_("leftwing1");
        this.leftwing2 = root.m_171324_("leftwing2");
        this.leftwing3 = root.m_171324_("leftwing3");
        this.leftwing4 = root.m_171324_("leftwing4");
        this.rightwing1 = root.m_171324_("rightwing1");
        this.rightwing2 = root.m_171324_("rightwing2");
        this.rightwing3 = root.m_171324_("rightwing3");
        this.rightwing4 = root.m_171324_("rightwing4");
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightarm = root.m_171324_("rightarm");
        this.leftarm = root.m_171324_("leftarm");
        this.rightleg = root.m_171324_("rightleg");
        this.leftleg = root.m_171324_("leftleg");
    }

    public static LayerDefinition getModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition leftfoot = partdefinition.m_171599_("leftfoot", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.0f, 7.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightfoot = partdefinition.m_171599_("rightfoot", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, 7.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftwing1 = partdefinition.m_171599_("leftwing1", CubeListBuilder.m_171558_().m_171514_(40, 25).m_171488_(-0.5f, -1.0f, 1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2094f, (float)0.6109f, (float)0.0f));
        PartDefinition leftwing2 = partdefinition.m_171599_("leftwing2", CubeListBuilder.m_171558_().m_171514_(46, 19).m_171488_(-0.5f, -2.0f, 3.0f, 1.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2094f, (float)0.6109f, (float)0.0175f));
        PartDefinition leftwing3 = partdefinition.m_171599_("leftwing3", CubeListBuilder.m_171558_().m_171514_(58, 12).m_171488_(-0.5f, -2.0f, 5.0f, 1.0f, 18.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2094f, (float)0.6109f, (float)0.0f));
        PartDefinition leftwing4 = partdefinition.m_171599_("leftwing4", CubeListBuilder.m_171558_().m_171514_(52, 16).m_171488_(-0.5f, 0.0f, 7.0f, 1.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2094f, (float)0.6109f, (float)0.0f));
        PartDefinition rightwing1 = partdefinition.m_171599_("rightwing1", CubeListBuilder.m_171558_().m_171514_(40, 25).m_171488_(-0.5f, -1.0f, 1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)1.0f, (float)1.0f, (float)0.2094f, (float)-0.6109f, (float)0.0f));
        PartDefinition rightwing2 = partdefinition.m_171599_("rightwing2", CubeListBuilder.m_171558_().m_171514_(46, 19).m_171488_(-0.5f, -2.0f, 3.0f, 1.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)1.0f, (float)1.0f, (float)0.2094f, (float)-0.6109f, (float)0.0f));
        PartDefinition rightwing3 = partdefinition.m_171599_("rightwing3", CubeListBuilder.m_171558_().m_171514_(58, 12).m_171488_(-0.5f, -2.0f, 5.0f, 1.0f, 18.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)1.0f, (float)1.0f, (float)0.2094f, (float)-0.6109f, (float)0.0f));
        PartDefinition rightwing4 = partdefinition.m_171599_("rightwing4", CubeListBuilder.m_171558_().m_171514_(52, 16).m_171488_(-0.5f, 0.0f, 7.0f, 1.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)1.0f, (float)1.0f, (float)0.2094f, (float)-0.6109f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2443f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = partdefinition.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-5.0f, (float)0.0f, (float)0.0f, (float)-1.7453f, (float)-0.5585f, (float)0.0f));
        PartDefinition leftarm = partdefinition.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171488_(-1.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)0.0f, (float)0.0f, (float)-1.7453f, (float)0.5585f, (float)0.0f));
        PartDefinition rightleg = partdefinition.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = partdefinition.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @Override
    public WeepingAngelPose getAngelPose() {
        return this.weepingAngelPose;
    }

    @Override
    public void setAngelPose(WeepingAngelPose angelPose) {
        this.weepingAngelPose = angelPose;
    }

    @Override
    public Pair<ModelPart, Vector3d> getHeadData(HeadPlacement placement) {
        if (placement == HeadPlacement.SANTA) {
            return null;
        }
        if (this.headData == null) {
            this.headData = new Pair<ModelPart, Vector3d>(this.head, new Vector3d(0.0, 0.0, 0.0));
        }
        return this.headData;
    }

    @Override
    public Iterable<ModelPart> wings(PoseStack pose) {
        return ImmutableList.of((Object)this.leftwing1, (Object)this.leftwing2, (Object)this.leftwing3, (Object)this.leftwing4, (Object)this.rightwing1, (Object)this.rightwing2, (Object)this.rightwing3, (Object)this.rightwing4);
    }

    public void setupAnim(WeepingAngel weepingAngel, float v, float v1, float v2, float v3, float v4) {
        WeepingAngelPose pose = this.getAngelPose();
        if (weepingAngel != null) {
            pose = WeepingAngelPose.getPose(weepingAngel.getAngelPose());
        }
        boolean isAngry = pose.getEmotion() == WeepingAngelPose.Emotion.ANGRY;
        float angleX = isAngry ? 20.0f : 10.0f;
        float angleY = isAngry ? 60.0f : 30.0f;
        float angleZ = 5.0f;
        this.head.f_104203_ = (float)Math.toRadians(0.0);
        this.head.f_104204_ = (float)Math.toRadians(0.0);
        this.head.f_104205_ = (float)Math.toRadians(0.0);
        this.leftwing4.f_104203_ = this.leftwing1.f_104203_ = (float)Math.toRadians(angleX);
        this.leftwing3.f_104203_ = this.leftwing1.f_104203_;
        this.leftwing2.f_104203_ = this.leftwing1.f_104203_;
        this.rightwing1.f_104203_ = this.leftwing1.f_104203_;
        this.rightwing4.f_104203_ = this.leftwing1.f_104203_;
        this.rightwing3.f_104203_ = this.leftwing1.f_104203_;
        this.rightwing2.f_104203_ = this.leftwing1.f_104203_;
        this.rightwing4.f_104204_ = this.rightwing1.f_104204_ = (float)Math.toRadians(-angleY);
        this.rightwing3.f_104204_ = this.rightwing1.f_104204_;
        this.rightwing2.f_104204_ = this.rightwing1.f_104204_;
        this.leftwing4.f_104204_ = this.leftwing1.f_104204_ = (float)Math.toRadians(angleY);
        this.leftwing3.f_104204_ = this.leftwing1.f_104204_;
        this.leftwing2.f_104204_ = this.leftwing1.f_104204_;
        this.rightwing4.f_104205_ = this.rightwing1.f_104205_ = (float)Math.toRadians(angleZ);
        this.rightwing3.f_104205_ = this.rightwing1.f_104205_;
        this.rightwing2.f_104205_ = this.rightwing1.f_104205_;
        this.leftwing4.f_104205_ = this.leftwing1.f_104205_ = (float)Math.toRadians(-angleZ);
        this.leftwing3.f_104205_ = this.leftwing1.f_104205_;
        this.leftwing2.f_104205_ = this.leftwing1.f_104205_;
        if (pose == WeepingAngelPose.FURIOUS) {
            this.rightarm.f_104205_ = 0.0f;
            this.leftarm.f_104205_ = 0.0f;
            this.rightarm.f_104204_ = -0.1f;
            this.leftarm.f_104204_ = 0.1f;
            this.rightarm.f_104203_ = -1.570796f;
            this.leftarm.f_104203_ = -1.570796f;
            return;
        }
        if (pose == WeepingAngelPose.APPROACH) {
            this.rightarm.f_104203_ = -1.04533f;
            this.rightarm.f_104204_ = -0.55851f;
            this.rightarm.f_104205_ = 0.0f;
            this.leftarm.f_104203_ = -1.04533f;
            this.leftarm.f_104204_ = 0.55851f;
            this.leftarm.f_104205_ = 0.0f;
            return;
        }
        if (pose == WeepingAngelPose.ANGRY) {
            this.rightarm.f_104203_ = (float)Math.toRadians(-95.0);
            this.rightarm.f_104204_ = (float)Math.toRadians(37.5);
            this.rightarm.f_104205_ = (float)Math.toRadians(40.0);
            this.leftarm.f_104203_ = (float)Math.toRadians(-95.0);
            this.leftarm.f_104204_ = (float)Math.toRadians(-37.5);
            this.leftarm.f_104205_ = (float)Math.toRadians(-40.0);
            return;
        }
        if (pose == WeepingAngelPose.IDLE || pose == WeepingAngelPose.HIDING) {
            this.rightarm.f_104203_ = -1.74533f;
            this.rightarm.f_104204_ = -0.55851f;
            this.rightarm.f_104205_ = 0.0f;
            this.leftarm.f_104203_ = -1.74533f;
            this.leftarm.f_104204_ = 0.55851f;
            this.leftarm.f_104205_ = 0.0f;
            return;
        }
        if (pose == WeepingAngelPose.SHY) {
            this.rightarm.f_104203_ = (float)Math.toRadians(-90.0);
            this.rightarm.f_104204_ = (float)Math.toRadians(-1.5);
            this.rightarm.f_104205_ = (float)Math.toRadians(-20.0);
            this.leftarm.f_104203_ = (float)Math.toRadians(-120.0);
            this.leftarm.f_104204_ = (float)Math.toRadians(-36.0);
            this.leftarm.f_104205_ = (float)Math.toRadians(10.0);
            this.head.f_104203_ = (float)Math.toRadians(20.0);
            this.head.f_104204_ = (float)Math.toRadians(-40.0);
            this.head.f_104205_ = (float)Math.toRadians(-20.0);
            return;
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.leftfoot.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightfoot.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leftwing1.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leftwing2.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leftwing3.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leftwing4.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightwing1.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightwing2.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightwing3.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightwing4.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.head.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.body.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightarm.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leftarm.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightleg.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leftleg.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.leftfoot, (Object)this.rightfoot, (Object)this.leftwing1, (Object)this.leftwing2, (Object)this.leftwing3, (Object)this.leftwing4, (Object)this.rightwing1, (Object)this.rightwing2, (Object)this.rightwing3, (Object)this.rightwing4, (Object)this.head, (Object)this.body, (Object[])new ModelPart[]{this.rightarm, this.leftarm, this.rightleg, this.leftleg});
    }

    @Override
    public boolean toggleHurt(boolean hurtShow) {
        return this.showHurt;
    }

    @Override
    public ResourceLocation generateTex(WeepingAngelPose pose, AbstractVariant angelVariants) {
        if (!DateChecker.isXmas()) {
            return pose.getEmotion() == WeepingAngelPose.Emotion.ANGRY ? this.TEXTURE_ANGRY : this.TEXTURE;
        }
        return pose.getEmotion() == WeepingAngelPose.Emotion.ANGRY ? this.TEXTURE_ANGRY_XMAS : this.TEXTURE_XMAS;
    }

    @Override
    public ResourceLocation getTextureForPose(Object angel, WeepingAngelPose pose) {
        return this.generateTex(pose, (AbstractVariant)((Object)AngelTypes.NORMAL.get()));
    }

    protected ModelPart getArm(HumanoidArm handSide) {
        return handSide == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm handSide, PoseStack matrixStack) {
        ModelPart hand = this.getArm(handSide);
        boolean wasVisible = hand.f_104207_;
        hand.f_104207_ = true;
        hand.m_104299_(matrixStack);
        hand.f_104207_ = wasVisible;
    }
}

