/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import mc.craig.software.angels.client.models.entity.HeadPlacement;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.blockentities.PlinthBlockEntity;
import mc.craig.software.angels.common.blockentities.StatueBlockEntity;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.utils.Pair;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;

public class ModelDoctorAngel
extends EntityModel<WeepingAngel>
implements IAngelModel,
HeadedModel,
ArmedModel {
    public static final ResourceLocation IDLE = new ResourceLocation("weeping_angels", "textures/entities/disaster/doctor/doctor_angel_idle.png");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart Legs;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private WeepingAngelPose weepingAngelPose = WeepingAngelPose.ANGRY;
    private boolean showHurt = false;
    private Pair<ModelPart, Vector3d> headData;

    public ModelDoctorAngel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leftArm = root.m_171324_("leftArm");
        this.rightArm = root.m_171324_("rightArm");
        this.Legs = root.m_171324_("Legs");
        this.leftWing = root.m_171324_("leftWing");
        this.rightWing = root.m_171324_("rightWing");
    }

    public static LayerDefinition getModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(72, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(56, 17).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 17).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)).m_171514_(41, 0).m_171488_(-5.0f, 8.5f, -2.5f, 10.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(24, 59).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 35).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(10, 59).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 35).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition Legs = partdefinition.m_171599_("Legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)9.25f, (float)0.0f));
        PartDefinition LLeg = Legs.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 50).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)2.75f, (float)0.0f));
        PartDefinition RLeg = Legs.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(67, 50).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)2.0f, (float)2.75f, (float)0.0f));
        PartDefinition leftWing = partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(0, 101).m_171488_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(6, 83).m_171488_(-1.0f, -8.9f, 5.0f, 2.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(18, 83).m_171488_(-1.0f, -6.9f, 3.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(8, 33).m_171488_(-1.0f, -10.9f, 6.0f, 2.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-1.0f, -10.0f, 9.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(38, 59).m_171488_(-1.0f, -8.0f, 11.0f, 2.0f, 17.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)5.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightWing = partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(10, 101).m_171488_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(12, 83).m_171488_(-1.0f, -8.9f, 5.0f, 2.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(26, 83).m_171488_(-1.0f, -6.9f, 3.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(18, 33).m_171488_(-1.0f, -10.0f, 9.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 83).m_171488_(-1.0f, -8.0f, 11.0f, 2.0f, 17.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 59).m_171488_(-1.0f, -10.9f, 6.0f, 2.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)5.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public WeepingAngelPose getWeepingAngelPose() {
        return this.weepingAngelPose;
    }

    public void setWeepingAngelPose(WeepingAngelPose weepingAngelPose) {
        this.weepingAngelPose = weepingAngelPose;
    }

    public void setupAnim(WeepingAngel weepingAngel, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        WeepingAngelPose pose = this.weepingAngelPose;
        if (weepingAngel != null) {
            pose = WeepingAngelPose.getPose(weepingAngel.getAngelPose());
        }
        boolean isAngry = pose.getEmotion() == WeepingAngelPose.Emotion.ANGRY || pose.getEmotion() == WeepingAngelPose.Emotion.SCREAM;
        float angleX = isAngry ? 20.0f : 0.0f;
        float angleY = isAngry ? 60.0f : 45.0f;
        float angleZ = 0.0f;
        if (pose.getEmotion() == WeepingAngelPose.Emotion.SCREAM) {
            angleY += 10.0f;
            angleX -= 10.0f;
        }
        this.head.f_104203_ = (float)Math.toRadians(0.0);
        this.head.f_104204_ = (float)Math.toRadians(0.0);
        this.head.f_104205_ = (float)Math.toRadians(0.0);
        this.rightWing.f_104203_ = (float)Math.toRadians(angleX);
        this.rightWing.f_104204_ = (float)Math.toRadians(angleY);
        this.rightWing.f_104205_ = (float)Math.toRadians(angleZ);
        this.leftWing.f_104203_ = (float)Math.toRadians(angleX);
        this.leftWing.f_104204_ = (float)Math.toRadians(-angleY);
        this.leftWing.f_104205_ = (float)Math.toRadians(angleZ);
        if (pose == WeepingAngelPose.FURIOUS) {
            this.rightArm.f_104203_ = (float)Math.toRadians(-115.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104205_ = (float)Math.toRadians(0.0);
            this.leftArm.f_104203_ = (float)Math.toRadians(-55.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(0.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(0.0);
            this.head.f_104203_ = (float)Math.toRadians(17.5);
            this.head.f_104204_ = (float)Math.toRadians(0.0);
            this.head.f_104205_ = (float)Math.toRadians(-10.0);
            return;
        }
        if (pose == WeepingAngelPose.ANGRY) {
            this.rightArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(-20.0);
            this.rightArm.f_104205_ = (float)Math.toRadians(30.0);
            this.leftArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(25.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(-17.5);
            this.head.f_104203_ = (float)Math.toRadians(0.0);
            this.head.f_104204_ = (float)Math.toRadians(-12.5);
            this.head.f_104205_ = (float)Math.toRadians(0.0);
            return;
        }
        if (pose == WeepingAngelPose.HIDING) {
            this.head.f_104203_ = (float)Math.toRadians(20.0);
            this.head.f_104204_ = (float)Math.toRadians(0.0);
            this.head.f_104205_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104203_ = (float)Math.toRadians(-105.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(20.0);
            this.rightArm.f_104205_ = (float)Math.toRadians(12.5);
            this.leftArm.f_104203_ = (float)Math.toRadians(-105.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(-20.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(-12.5);
            return;
        }
        if (pose == WeepingAngelPose.APPROACH) {
            this.rightArm.f_104203_ = -1.04533f;
            this.rightArm.f_104204_ = -0.55851f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = -1.04533f;
            this.leftArm.f_104204_ = 0.55851f;
            this.leftArm.f_104205_ = 0.0f;
            return;
        }
        if (pose == WeepingAngelPose.IDLE) {
            this.head.f_104203_ = (float)Math.toRadians(0.0);
            this.head.f_104204_ = (float)Math.toRadians(0.0);
            this.head.f_104205_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104203_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104205_ = (float)Math.toRadians(-7.5);
            this.leftArm.f_104203_ = (float)Math.toRadians(0.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(0.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(7.5);
            return;
        }
        if (pose == WeepingAngelPose.SHY) {
            this.rightArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(-1.5);
            this.rightArm.f_104205_ = (float)Math.toRadians(-20.0);
            this.leftArm.f_104203_ = (float)Math.toRadians(-120.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(-36.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(10.0);
            this.head.f_104203_ = (float)Math.toRadians(20.0);
            this.head.f_104204_ = (float)Math.toRadians(-40.0);
            this.head.f_104205_ = (float)Math.toRadians(-20.0);
            return;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.leftArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.rightArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.Legs.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.leftWing.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.rightWing.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    @Override
    public boolean toggleHurt(boolean hurtShow) {
        this.showHurt = hurtShow;
        return this.showHurt;
    }

    @Override
    public ResourceLocation generateTex(WeepingAngelPose pose, AbstractVariant abstractVariant) {
        return IDLE;
    }

    @Override
    public ResourceLocation getTextureForPose(Object angel, WeepingAngelPose pose) {
        if (angel instanceof WeepingAngel) {
            WeepingAngel weepingAngel = (WeepingAngel)((Object)angel);
            return this.generateTex(pose, weepingAngel.getVariant());
        }
        if (angel instanceof StatueBlockEntity) {
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)angel;
            return this.generateTex(statueBlockEntity.getPose(), statueBlockEntity.getAngelVarients());
        }
        if (angel instanceof PlinthBlockEntity) {
            PlinthBlockEntity plinthBlockEntity = (PlinthBlockEntity)angel;
            return this.generateTex(plinthBlockEntity.getPose(), plinthBlockEntity.getVariant());
        }
        return IDLE;
    }

    @Override
    public WeepingAngelPose getAngelPose() {
        return this.weepingAngelPose;
    }

    @Override
    public void setAngelPose(WeepingAngelPose angelPose) {
        this.weepingAngelPose = angelPose;
    }

    @Override
    public Pair<ModelPart, Vector3d> getHeadData(HeadPlacement placement) {
        if (this.headData == null) {
            this.headData = new Pair<ModelPart, Vector3d>(this.head, new Vector3d(0.0, 0.0, 0.0));
        }
        return this.headData;
    }

    @Override
    public Iterable<ModelPart> wings(PoseStack pose) {
        return ImmutableList.of((Object)this.leftWing, (Object)this.rightWing);
    }

    public void m_6002_(HumanoidArm p_102108_, PoseStack p_102109_) {
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

