/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.poses;

import java.util.Random;

public enum WeepingAngelPose {
    ANGRY(Emotion.ANGRY),
    FURIOUS(Emotion.ANGRY),
    SHY,
    HIDING,
    APPROACH(Emotion.SCREAM),
    IDLE;

    private final Emotion emotion;

    private WeepingAngelPose(Emotion emotion) {
        this.emotion = emotion;
    }

    private WeepingAngelPose() {
        this.emotion = Emotion.IDLE;
    }

    public static WeepingAngelPose getRandomPose(Random random) {
        int pick = random.nextInt(WeepingAngelPose.values().length);
        return WeepingAngelPose.values()[pick];
    }

    public static WeepingAngelPose getPose(String name) {
        for (WeepingAngelPose pose : WeepingAngelPose.values()) {
            if (!pose.name().equalsIgnoreCase(name)) continue;
            return pose;
        }
        return HIDING;
    }

    public static WeepingAngelPose next(WeepingAngelPose type) {
        int index = type.ordinal();
        int nextIndex = index + 1;
        WeepingAngelPose[] angels = WeepingAngelPose.values();
        return angels[nextIndex %= angels.length];
    }

    public Emotion getEmotion() {
        return this.emotion;
    }

    public static enum Emotion {
        SCREAM,
        IDLE,
        ANGRY;

    }
}

