/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.renders.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import mc.craig.software.angels.client.models.entity.WAModels;
import mc.craig.software.angels.common.blockentities.CoffinBlockEntity;
import mc.craig.software.angels.common.blocks.CoffinBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CoffinRenderer
implements BlockEntityRenderer<CoffinBlockEntity>,
BlockEntityRendererProvider<CoffinBlockEntity> {
    private static ModelPart coffinModel;
    private static ModelPart coffinModelPTB;
    private static Skeleton skeletonEntity;

    public CoffinRenderer(BlockEntityRendererProvider.Context context) {
        coffinModel = context.m_173582_(WAModels.COFFIN);
        coffinModelPTB = context.m_173582_(WAModels.POLICE_BOX);
    }

    public void render(CoffinBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (skeletonEntity == null) {
            skeletonEntity = new Skeleton(EntityType.f_20524_, (Level)Minecraft.m_91087_().f_91073_);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        BlockState blockstate = tileEntityIn.m_58900_();
        float rotation = 22.5f * (float)((Integer)blockstate.m_61143_((Property)CoffinBlock.ROTATION)).intValue();
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        if (!((Boolean)tileEntityIn.m_58900_().m_61143_((Property)CoffinBlock.UPRIGHT)).booleanValue()) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        } else {
            matrixStack.m_85837_(0.0, -1.0, 0.0);
        }
        this.renderSkeleton(tileEntityIn, matrixStack, bufferIn, combinedLightIn);
        ResourceLocation texture = this.getTexture(tileEntityIn.getCoffin());
        if (!tileEntityIn.getCoffin().isPoliceBox()) {
            CoffinRenderer.coffinModel.m_171324_((String)"door").f_104204_ = -(tileEntityIn.getOpenAmount() * 1.0471976f);
            coffinModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)texture)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            matrixStack.m_85837_(0.0, 0.5, 0.0);
            matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
            coffinModelPTB.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texture)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, tileEntityIn.getAlpha());
        }
        matrixStack.m_85849_();
    }

    private void renderSkeleton(CoffinBlockEntity tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn) {
        if (tileEntityIn.hasSkeleton()) {
            matrixStack.m_85836_();
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
            matrixStack.m_85837_(0.0, 1.5, 0.0);
            EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)skeletonEntity);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-180.0f));
            renderer.m_7392_((Entity)skeletonEntity, 0.0f, 0.0f, matrixStack, bufferIn, combinedLightIn);
            matrixStack.m_85849_();
        }
    }

    public ResourceLocation getTexture(CoffinBlockEntity.Coffin coffin) {
        return new ResourceLocation("weeping_angels", "textures/tiles/coffin/" + coffin.name().toLowerCase() + ".png");
    }

    public BlockEntityRenderer<CoffinBlockEntity> m_173570_(BlockEntityRendererProvider.Context context) {
        return new CoffinRenderer(context);
    }

    static {
        skeletonEntity = null;
    }
}

