/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.renders.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.models.entity.WAModels;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.blockentities.SnowAngelBlockEntity;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.utils.ClientUtil;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class SnowAngelRenderer
implements BlockEntityRenderer<SnowAngelBlockEntity>,
BlockEntityRendererProvider<SnowAngelBlockEntity> {
    private final ModelPart armModel;
    private final ModelPart bodyModel;
    private final ModelPart headModel;
    private final ModelPart wingsModel;

    public SnowAngelRenderer(BlockEntityRendererProvider.Context context) {
        this.armModel = context.m_173582_(WAModels.SNOW_ANGEL_ARM);
        this.bodyModel = context.m_173582_(WAModels.SNOW_ANGEL_BODY);
        this.headModel = context.m_173582_(WAModels.SNOW_ANGEL_HEAD);
        this.wingsModel = context.m_173582_(WAModels.SNOW_ANGEL_WING);
    }

    public static ResourceLocation getTexture(SnowAngelBlockEntity snowAngelBlockEntity) {
        IAngelModel iAngelModel = (IAngelModel)ClientUtil.getModelForAngel(AngelType.DISASTER_MC);
        return iAngelModel.generateTex(WeepingAngelPose.APPROACH, snowAngelBlockEntity.getVariant());
    }

    public void render(SnowAngelBlockEntity snowAngelBlockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.m_85836_();
        switch (snowAngelBlockEntity.getSnowAngelStage()) {
            case ARM: {
                matrixStack.m_85837_(0.5, (double)-1.1f, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_((float)snowAngelBlockEntity.getRotation()));
                this.armModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)SnowAngelRenderer.getTexture(snowAngelBlockEntity))), combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case HEAD: {
                matrixStack.m_85837_(0.5, (double)1.6f, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_((float)snowAngelBlockEntity.getRotation()));
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                this.headModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)SnowAngelRenderer.getTexture(snowAngelBlockEntity))), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case BODY: {
                matrixStack.m_85837_(0.5, (double)1.7f, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_((float)snowAngelBlockEntity.getRotation()));
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                this.bodyModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)SnowAngelRenderer.getTexture(snowAngelBlockEntity))), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case WINGS: {
                matrixStack.m_85837_(0.5, 1.5, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_((float)snowAngelBlockEntity.getRotation()));
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                this.wingsModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)SnowAngelRenderer.getTexture(snowAngelBlockEntity))), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        matrixStack.m_85849_();
    }

    public BlockEntityRenderer<SnowAngelBlockEntity> m_173570_(BlockEntityRendererProvider.Context p_173571_) {
        return new SnowAngelRenderer(p_173571_);
    }
}

