/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.renders.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.models.entity.SantaHat;
import mc.craig.software.angels.client.models.entity.WAModels;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.client.renders.entities.SeasonalLayer;
import mc.craig.software.angels.common.blockentities.StatueBlockEntity;
import mc.craig.software.angels.common.blocks.StatueBlock;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.utils.ClientUtil;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StatueRender
implements BlockEntityRenderer<StatueBlockEntity>,
BlockEntityRendererProvider<StatueBlockEntity> {
    private final SantaHat<Entity> model;

    public StatueRender(BlockEntityRendererProvider.Context p_173571_) {
        this.model = new SantaHat(p_173571_.m_173582_(WAModels.SANTA_HAT));
    }

    public void render(StatueBlockEntity statueBlockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        BlockState blockstate = statueBlockEntity.m_58900_();
        float rotation = 22.5f * (float)((Integer)blockstate.m_61143_((Property)StatueBlock.ROTATION)).intValue();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        EntityModel<WeepingAngel> angel = ClientUtil.getModelForAngel(statueBlockEntity.getAngelType());
        ResourceLocation texture = DefaultPlayerSkin.m_118626_();
        WeepingAngelPose pose = statueBlockEntity.getPose();
        if (angel instanceof IAngelModel) {
            IAngelModel angelModel = (IAngelModel)angel;
            angelModel.setAngelPose(pose);
            angelModel.toggleHurt(true);
            texture = angelModel.getTextureForPose(statueBlockEntity, pose);
            angel.m_6973_(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            matrixStack.m_85836_();
            SeasonalLayer.santaHat(matrixStack, bufferIn, combinedLightIn, this.model, angel, statueBlockEntity.getVariant());
            matrixStack.m_85849_();
        }
        angel.m_7695_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texture)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    public BlockEntityRenderer<StatueBlockEntity> m_173570_(BlockEntityRendererProvider.Context p_173571_) {
        return new StatueRender(p_173571_);
    }
}

