/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.renders.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.client.renders.entities.AngelCrackedLayer;
import mc.craig.software.angels.client.renders.entities.AngelHeldLayer;
import mc.craig.software.angels.client.renders.entities.SeasonalLayer;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.utils.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public class AngelRender
extends MobRenderer<WeepingAngel, EntityModel<WeepingAngel>>
implements EntityRendererProvider<WeepingAngel> {
    public AngelRender(EntityRendererProvider.Context context) {
        super(context, ClientUtil.getModelForAngel(AngelType.DISASTER_MC), 0.5f);
        this.m_115326_(new AngelCrackedLayer((RenderLayerParent<WeepingAngel, EntityModel<WeepingAngel>>)this));
        this.m_115326_(new AngelHeldLayer(this));
        this.m_115326_(new SeasonalLayer((RenderLayerParent<WeepingAngel, EntityModel<WeepingAngel>>)this));
    }

    protected float getWhiteOverlayProgress(WeepingAngel livingEntityIn, float partialTicks) {
        return 0.0f;
    }

    public void render(WeepingAngel weepingAngel, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStackIn, MultiBufferSource pBufferIn, int pPackedLightIn) {
        this.f_115290_ = ClientUtil.getModelForAngel(weepingAngel.getAngelType());
        EntityModel entityModel = this.f_115290_;
        if (entityModel instanceof IAngelModel) {
            IAngelModel iAngelModel = (IAngelModel)entityModel;
            iAngelModel.toggleHurt(false);
        }
        if (!weepingAngel.getAngelType().canHoldThings() && this.f_115290_ instanceof ArmedModel) {
            ItemStack key = weepingAngel.m_21205_();
            pMatrixStackIn.m_85836_();
            float offset = Mth.m_14089_((float)((float)weepingAngel.f_19797_ * 0.1f)) * -0.09f;
            pMatrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            pMatrixStackIn.m_85837_(0.0, 5.0, 0.0);
            pMatrixStackIn.m_85837_(0.0, (double)offset, 0.0);
            pMatrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_((float)weepingAngel.f_19853_.m_46467_() / 20.0f));
            this.renderItem((LivingEntity)weepingAngel, key, ItemTransforms.TransformType.FIXED, false, pMatrixStackIn, pBufferIn, pPackedLightIn);
            pMatrixStackIn.m_85849_();
        }
        pMatrixStackIn.m_85836_();
        super.m_7392_((Mob)weepingAngel, pEntityYaw, pPartialTicks, pMatrixStackIn, pBufferIn, pPackedLightIn);
        pMatrixStackIn.m_85849_();
    }

    protected float getFlipDegrees(WeepingAngel entityLivingBaseIn) {
        return 90.0f;
    }

    protected void setupRotations(WeepingAngel entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (entityLiving.f_20919_ > 0) {
            float deathRotation = ((float)entityLiving.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((deathRotation = Mth.m_14116_((float)deathRotation)) > 1.0f) {
                deathRotation = 1.0f;
            }
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(deathRotation * this.getFlipDegrees(entityLiving)));
            return;
        }
        super.m_7523_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public ResourceLocation getTextureLocation(WeepingAngel weepingAngel) {
        IAngelModel iAngelModel = (IAngelModel)this.f_115290_;
        return iAngelModel.getTextureForPose((Object)weepingAngel, WeepingAngelPose.getPose(weepingAngel.getAngelPose()));
    }

    private void renderItem(LivingEntity livingEntityIn, ItemStack itemStackIn, ItemTransforms.TransformType transformTypeIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        if (!itemStackIn.m_41619_()) {
            Minecraft.m_91087_().m_91292_().m_109322_(livingEntityIn, itemStackIn, transformTypeIn, leftHand, matrixStackIn, bufferIn, combinedLightIn);
        }
    }

    public EntityRenderer<WeepingAngel> m_174009_(EntityRendererProvider.Context context) {
        return new AngelRender(context);
    }
}

