/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.renders.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3d;
import mc.craig.software.angels.client.models.entity.HeadPlacement;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.models.entity.SantaHat;
import mc.craig.software.angels.client.models.entity.WAModels;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.utils.DateChecker;
import mc.craig.software.angels.utils.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SeasonalLayer
extends RenderLayer<WeepingAngel, EntityModel<WeepingAngel>> {
    public static final ResourceLocation SANTA = new ResourceLocation("weeping_angels", "textures/entities/santa_hat.png");
    private final SantaHat<Entity> model = new SantaHat(Minecraft.m_91087_().m_167973_().m_171103_(WAModels.SANTA_HAT));

    public SeasonalLayer(RenderLayerParent<WeepingAngel, EntityModel<WeepingAngel>> renderer) {
        super(renderer);
    }

    public static void santaHat(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, EntityModel santa, EntityModel model, AbstractVariant abstractVariant) {
        if (abstractVariant.isHeadless()) {
            return;
        }
        if (model instanceof IAngelModel) {
            IAngelModel iAngelModel = (IAngelModel)model;
            Pair<ModelPart, Vector3d> santaHead = iAngelModel.getHeadData(HeadPlacement.SANTA);
            if (DateChecker.isXmas() && santaHead != null && ((Boolean)WAConfig.CONFIG.showSantaHatsAtXmas.get()).booleanValue()) {
                pMatrixStack.m_85836_();
                santaHead.getFirst().m_104299_(pMatrixStack);
                pMatrixStack.m_85837_(santaHead.getSecond().f_86214_, santaHead.getSecond().f_86215_, santaHead.getSecond().f_86216_);
                santa.m_7695_(pMatrixStack, pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)SANTA)), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                pMatrixStack.m_85849_();
            }
        }
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, WeepingAngel pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!pLivingEntity.m_20145_()) {
            SeasonalLayer.santaHat(pMatrixStack, pBuffer, pPackedLight, this.model, this.m_117386_(), pLivingEntity.getVariant());
        }
    }
}

