/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common;

import mc.craig.software.angels.common.blockentities.CoffinBlockEntity;
import mc.craig.software.angels.common.blockentities.PlinthBlockEntity;
import mc.craig.software.angels.common.blockentities.SnowAngelBlockEntity;
import mc.craig.software.angels.common.blockentities.StatueBlockEntity;
import mc.craig.software.angels.common.blocks.ArmBlock;
import mc.craig.software.angels.common.blocks.ChronodyneGeneratorBlock;
import mc.craig.software.angels.common.blocks.CoffinBlock;
import mc.craig.software.angels.common.blocks.MineableBlock;
import mc.craig.software.angels.common.blocks.PlinthBlock;
import mc.craig.software.angels.common.blocks.SnowAngelBlock;
import mc.craig.software.angels.common.blocks.StatueBlock;
import mc.craig.software.angels.common.entities.ChronodyneGeneratorProjectile;
import mc.craig.software.angels.common.entities.Portal;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.items.AngelSpawnerItem;
import mc.craig.software.angels.common.items.ChiselItem;
import mc.craig.software.angels.common.items.ChronodyneGeneratorItem;
import mc.craig.software.angels.common.items.DetectorItem;
import mc.craig.software.angels.common.misc.WATabs;
import mc.craig.software.angels.utils.WADamageSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="weeping_angels", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WAObjects {
    public static DamageSource ANGEL = new WADamageSource("backintime");
    public static DamageSource GENERATOR = new WADamageSource("generator");
    public static DamageSource STONE = new WADamageSource("punch_stone");
    public static DamageSource ANGEL_NECK_SNAP = new WADamageSource("neck_snap");
    public static ResourceLocation CRYPT_LOOT = new ResourceLocation("weeping_angels", "chests/crypt");

    private static Item setUpItem(Item item) {
        return item;
    }

    private static Block setUpBlock(Block block) {
        return block;
    }

    private static void genBlockItems(Block ... blocks) {
        for (Block block : blocks) {
            Blocks.BLOCK_ITEMS.register(block.getRegistryName().m_135815_(), () -> WAObjects.setUpItem((Item)new BlockItem(block, new Item.Properties().m_41491_(WATabs.MAIN_TAB))));
        }
    }

    private static SoundEvent setUpSound(String soundName) {
        return new SoundEvent(new ResourceLocation("weeping_angels", soundName));
    }

    @SubscribeEvent
    public static void regBlockItems(RegistryEvent.Register<Item> e) {
        WAObjects.genBlockItems((Block)Blocks.WALL_ARM.get(), (Block)Blocks.COFFIN.get(), (Block)Blocks.SNOW_ANGEL.get(), (Block)Blocks.KONTRON_ORE.get(), (Block)Blocks.KONTRON_ORE_DEEPSLATE.get(), (Block)Blocks.PLINTH.get(), (Block)Blocks.STATUE.get());
    }

    private static <T extends BlockEntity> BlockEntityType<T> registerTiles(BlockEntityType.BlockEntitySupplier<T> tile, Block validBlock) {
        return BlockEntityType.Builder.m_155273_(tile, (Block[])new Block[]{validBlock}).m_58966_(null);
    }

    private static <T extends Entity> EntityType<T> registerBase(EntityType.EntityFactory<T> factory, IClientSpawner<T> client, MobCategory classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("weeping_angels", name);
        EntityType.Builder builder = EntityType.Builder.m_20704_(factory, (MobCategory)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.m_20702_(10);
        builder.m_20699_(width, height);
        builder.setCustomClientFactory((spawnEntity, world) -> (Entity)client.spawn((Level)world));
        return builder.m_20712_(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerFireImmuneBase(EntityType.EntityFactory<T> factory, IClientSpawner<T> client, MobCategory classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("weeping_angels", name);
        EntityType.Builder builder = EntityType.Builder.m_20704_(factory, (MobCategory)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.m_20719_();
        builder.m_20702_(10);
        builder.m_20720_();
        builder.m_20699_(width, height);
        builder.setCustomClientFactory((spawnEntity, world) -> (Entity)client.spawn((Level)world));
        return builder.m_20712_(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerFireResistMob(EntityType.EntityFactory<T> factory, IClientSpawner<T> client, MobCategory classification, float width, float height, String name, boolean velocity) {
        return WAObjects.registerFireImmuneBase(factory, client, classification, width, height, 80, 2, velocity, name);
    }

    public static <T extends Entity> EntityType<T> registerStatic(EntityType.EntityFactory<T> factory, IClientSpawner<T> client, MobCategory classification, float width, float height, String name) {
        return WAObjects.registerBase(factory, client, classification, width, height, 64, 40, false, name);
    }

    public static <T extends Entity> EntityType<T> registerMob(EntityType.EntityFactory<T> factory, IClientSpawner<T> client, MobCategory classification, float width, float height, String name, boolean velocity) {
        return WAObjects.registerBase(factory, client, classification, width, height, 80, 3, velocity, name);
    }

    public static class Blocks {
        public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"weeping_angels");
        public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"weeping_angels");
        public static final RegistryObject<Block> SNOW_ANGEL = BLOCKS.register("snow_angel", () -> WAObjects.setUpBlock((Block)new SnowAngelBlock()));
        public static final RegistryObject<Block> CHRONODYNE_GENERATOR = BLOCKS.register("chronodyne_generator", () -> WAObjects.setUpBlock(new ChronodyneGeneratorBlock()));
        public static final RegistryObject<Block> PLINTH = BLOCKS.register("plinth", () -> WAObjects.setUpBlock(new PlinthBlock()));
        public static final RegistryObject<Block> KONTRON_ORE = BLOCKS.register("kontron_ore", () -> WAObjects.setUpBlock((Block)new MineableBlock(Material.f_76278_, SoundType.f_56742_, 3.0f, 3.0f)));
        public static final RegistryObject<Block> KONTRON_ORE_DEEPSLATE = BLOCKS.register("kontron_ore_deepslate", () -> WAObjects.setUpBlock((Block)new MineableBlock(Material.f_76278_, SoundType.f_154677_, 4.5f, 3.0f)));
        public static final RegistryObject<Block> STATUE = BLOCKS.register("statue", () -> WAObjects.setUpBlock(new StatueBlock()));
        public static final RegistryObject<Block> COFFIN = BLOCKS.register("coffin", () -> WAObjects.setUpBlock((Block)new CoffinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)net.minecraft.world.level.block.Blocks.f_50015_).m_60955_().m_60991_((p_61036_, p_61037_, p_61038_) -> {
            BlockEntity patt8876$temp = p_61037_.m_7702_(p_61038_);
            if (patt8876$temp instanceof CoffinBlockEntity) {
                CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)patt8876$temp;
                return coffinBlockEntity.getCoffin().isPoliceBox();
            }
            return false;
        }))));
        public static final RegistryObject<Block> WALL_ARM = BLOCKS.register("wall_arm", () -> WAObjects.setUpBlock(new ArmBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)net.minecraft.world.level.block.Blocks.f_50069_).m_60910_())));
    }

    public static interface IClientSpawner<T> {
        public T spawn(Level var1);
    }

    public static class EntityEntries {
        public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"weeping_angels");
        public static final RegistryObject<EntityType<WeepingAngel>> WEEPING_ANGEL = ENTITIES.register("weeping_angel", () -> WAObjects.registerFireResistMob(WeepingAngel::new, WeepingAngel::new, MobCategory.MONSTER, 0.6f, 1.95f, "weeping_angel", false));
        public static final RegistryObject<EntityType<Portal>> ANOMALY = ENTITIES.register("anomaly", () -> WAObjects.registerMob(Portal::new, Portal::new, MobCategory.MONSTER, 1.0f, 1.75f, "anomaly", false));
        public static final RegistryObject<EntityType<ChronodyneGeneratorProjectile>> CHRONODYNE_GENERATOR = ENTITIES.register("chronodyne_generator", () -> WAObjects.registerMob(ChronodyneGeneratorProjectile::new, ChronodyneGeneratorProjectile::new, MobCategory.MISC, 0.5f, 0.5f, "chronodyne_generator", true));
    }

    public static class Sounds {
        public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"weeping_angels");
        public static final RegistryObject<SoundEvent> ANGEL_SEEN = SOUNDS.register("angel_seen", () -> WAObjects.setUpSound("angel_seen"));
        public static final RegistryObject<SoundEvent> STONE_SCRAPE = SOUNDS.register("stone_scrape", () -> WAObjects.setUpSound("stone_scrape"));
        public static final RegistryObject<SoundEvent> CHILD_RUN = SOUNDS.register("child_run", () -> WAObjects.setUpSound("child_run"));
        public static final RegistryObject<SoundEvent> LAUGHING_CHILD = SOUNDS.register("laughing_child", () -> WAObjects.setUpSound("laughing_child"));
        public static final RegistryObject<SoundEvent> LIGHT_BREAK = SOUNDS.register("light_break", () -> WAObjects.setUpSound("light_break"));
        public static final RegistryObject<SoundEvent> ANGEL_AMBIENT = SOUNDS.register("angel_ambient", () -> WAObjects.setUpSound("angel_ambient"));
        public static final RegistryObject<SoundEvent> DING = SOUNDS.register("ding", () -> WAObjects.setUpSound("ding"));
        public static final RegistryObject<SoundEvent> BLOW = SOUNDS.register("blow", () -> WAObjects.setUpSound("blow"));
        public static final RegistryObject<SoundEvent> ANGEL_DEATH = SOUNDS.register("angel_death", () -> WAObjects.setUpSound("angel_death"));
        public static final RegistryObject<SoundEvent> ANGEL_NECK_SNAP = SOUNDS.register("angel_neck_snap", () -> WAObjects.setUpSound("angel_neck_snap"));
        public static final RegistryObject<SoundEvent> PROJECTOR = SOUNDS.register("projector", () -> WAObjects.setUpSound("projector"));
        public static final RegistryObject<SoundEvent> TELEPORT = SOUNDS.register("teleport", () -> WAObjects.setUpSound("teleport"));
        public static final RegistryObject<SoundEvent> ANGEL_MOCKING = SOUNDS.register("angel_mocking", () -> WAObjects.setUpSound("angel_mocking"));
        public static final RegistryObject<SoundEvent> TARDIS_TAKEOFF = SOUNDS.register("tardis_takeoff", () -> WAObjects.setUpSound("tardis_takeoff"));
        public static final RegistryObject<SoundEvent> DISC_SALLY = SOUNDS.register("disc_sally", () -> WAObjects.setUpSound("disc_sally"));
        public static final RegistryObject<SoundEvent> DISC_TIME_PREVAILS = SOUNDS.register("disc_time_prevails", () -> WAObjects.setUpSound("disc_time_prevails"));
        public static final RegistryObject<SoundEvent> CATACOMB = SOUNDS.register("catacomb", () -> WAObjects.setUpSound("catacomb"));
        public static final RegistryObject<SoundEvent> KNOCK = SOUNDS.register("knock", () -> WAObjects.setUpSound("knock"));
    }

    public static class Items {
        public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"weeping_angels");
        public static final RegistryObject<Item> TIMEY_WIMEY_DETECTOR = ITEMS.register("timey_wimey_detector", DetectorItem::new);
        public static final RegistryObject<Item> CHRONODYNE_GENERATOR = ITEMS.register("chronodyne_generator", ChronodyneGeneratorItem::new);
        public static final RegistryObject<Item> ANGEL_SPAWNER = ITEMS.register("weeping_angel", () -> WAObjects.setUpItem(new AngelSpawnerItem()));
        public static final RegistryObject<Item> KONTRON_INGOT = ITEMS.register("kontron_ingot", () -> WAObjects.setUpItem(new Item(new Item.Properties().m_41491_(WATabs.MAIN_TAB))));
        public static final RegistryObject<Item> CHISEL = ITEMS.register("chisel", () -> WAObjects.setUpItem(new ChiselItem(new Item.Properties().m_41487_(1).m_41491_(WATabs.MAIN_TAB))));
        public static final RegistryObject<Item> SALLY = ITEMS.register("music_disc_sally", () -> WAObjects.setUpItem((Item)new RecordItem(6, Sounds.DISC_SALLY, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.RARE))));
        public static final RegistryObject<Item> TIME_PREVAILS = ITEMS.register("music_disc_time_prevails", () -> WAObjects.setUpItem((Item)new RecordItem(6, Sounds.DISC_TIME_PREVAILS, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.RARE))));
    }

    public static class Tiles {
        public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"weeping_angels");
        public static RegistryObject<BlockEntityType<SnowAngelBlockEntity>> SNOW_ANGEL = TILES.register("snow_angel", () -> WAObjects.registerTiles(SnowAngelBlockEntity::new, (Block)Blocks.SNOW_ANGEL.get()));
        public static RegistryObject<BlockEntityType<PlinthBlockEntity>> PLINTH = TILES.register("plinth", () -> WAObjects.registerTiles(PlinthBlockEntity::new, (Block)Blocks.PLINTH.get()));
        public static RegistryObject<BlockEntityType<StatueBlockEntity>> STATUE = TILES.register("statue", () -> WAObjects.registerTiles(StatueBlockEntity::new, (Block)Blocks.STATUE.get()));
        public static RegistryObject<BlockEntityType<CoffinBlockEntity>> COFFIN = TILES.register("coffin", () -> WAObjects.registerTiles(CoffinBlockEntity::new, (Block)Blocks.COFFIN.get()));
    }
}

